"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const _=require("lodash");class K4DeviceConverter{constructor(e,t){this.client=e,this.devices=t}convert(){const e=this.devices.filter(e=>this.isDeviceEnabled(e)).map(e=>this.convertPrinter(e));return{serial:this.client.serverSerial,interface:{type:this.client.isV6Connection?3:2,ipAddress:this.client.ipAddress},isLocalServer:this.client.isLocalServer,isAdditionalServer:this.client.isAdditionalServer,printers:e}}isDeviceEnabled(e){return"printer"===e.deviceType&&""!==e.printerID.serial}convertPrinter(e){return{serial:e.printerID.serial,nickname:e.friendlyName||"",firmware:e.firmVersion||"",model:{name:e.model.replace(/^EPSON\s*/i,"")},interface:this.convertInterface(e),region:e.regionID||"",monitoring:e.allowAutoMonitoring?1:0,master:{serial:"",interface:this.convertNetworkInterface(e.masterV4,e.masterV6)},identity:e.agentID,isAutoMonitoring:e.allowAutoMonitoring,defaultNickname:e.printerID.name,workOffline:e.workOffline,queues:e.queue}}convertInterface(e){if(!e.connection)return{type:0,ipAddress:""};switch(e.connection.toUpperCase()){case"LAN":return this.convertNetworkInterface(e.ipv4,e.ipv6);case"USB":default:return{type:1,ipAddress:""}}}convertNetworkInterface(e,t){return e?{type:2,ipAddress:e}:t?{type:3,ipAddress:t}:{type:2,ipAddress:""}}}exports.K4DeviceConverter=K4DeviceConverter;class K4StatusConverter{constructor(e,t,r){this.client=e,this.status=t,this.printer=r}convert(){return{status:this.convertStatus(this.status.status,this.status.warning),notification:{information:this.status.info||[],warning:this.status.warning||[],error:this.status.error||[]},inputMedia:this.convertInputMedia(this.status.inputPath),totalPrint:this.convertTotalPrint(this.status.totalPrint),inkKind:this.status.inkSet?this.status.inkSet:void 0,inkType:this.status.inkType?this.status.inkType:void 0,supply:{ink:this.convertInk(this.status.inkInfo,this.status.cissCommonInfo),mntTank:this.convertMntParts(this.status.tanks),mntParts:this.convertMntParts(this.status.replacements)},heater:this.convertHeater(this.status.heater),jobName:this.status.jobName||void 0,statusProgress:void 0,maintenanceProgress:this.convertMntProgress(this.status.cleaningInfo),maintenanceNotice:this.convertMntNotice(this.status.noticeCleaningInfo),cleaningNozzle:this.status.cleaningNozzle?this.status.cleaningNozzle:void 0,jobProgress:this.convertJobProgress(this.status.operationInfo),equipment:this.convertEquipment(this.status.printerInfo),currentPrinterMedia:this.status.mechaParam?this.status.mechaParam:void 0,printer:{serial:this.printer.serial,type:this.printer.interface.type},printerServer:{serial:this.client.serverSerial||"",isLocal:this.client.isLocalServer},date:new Date(this.status.utc)}}convertStatus(e,t){const r=t&&0!==t.length;switch(e.toUpperCase()){case"OFFLINE":return 1;case"READY":return r?100:10;case"PRINTING":return r?101:11;case"ERROR":return r?102:12;case"UPDATING":return r?103:13;case"OPERATING":return r?104:14;case"SLEEPING":return 200;case"STARTUP":return 201;case"SHUTDOWN":return 202;case"PAUSE":return 203;default:return-1}}convertMediaType(e){switch(e.toUpperCase()){case"OFFICIAL":return 0;case"USER":return 1;case"EMX":return 2;default:return 0}}convertMediaFeed(e){switch(e.toUpperCase()){case"CONTINUOUS":return 2;case"CSF":return 3;case"MANUAL":return 1;case"ROLL":return 0;case"BOARD":return 4;default:return 0}}convertHeaterStatus(e){switch(e.toUpperCase()){case"OK":return 1;case"OFF":return 2;case"TRANSIT":return 3;case"SETTINGDISABLE":return 4;case"RISING":case"DECENDING":return 3;case"UNKNOWN":default:return 0}}convertMntPartsStatus(e){let t=0;return e.ok&&(t+=1),e.low&&(t+=2),e.end&&(t+=4),e.error&&(t+=8),e.unlock&&(t+=16),e.cleaning&&(t+=268435456),e.unknown&&(t+=2147483648),e.standby&&(t+=32),e.nongenuine&&(t+=64),e.initializer&&(t+=128),t}convertMediaUnit(e){let t;return(t=/^(.*)mm$/i.exec(e))?{n:Number(t[1])||1,type:0}:(t=/^(.*)cm$/i.exec(e))?{n:Number(t[1])||1,type:1}:(t=/^(.*)inch$/i.exec(e))?{n:Number(t[1])||1,type:2}:(t=/^(.*)ft$/i.exec(e))?{n:Number(t[1])||1,type:3}:/^count$/i.test(e)?{n:1,type:4}:{n:1,type:0}}convertHeaterUnit(e){switch(e.toUpperCase()){case"C":return 0;case"F":return 1;default:return 0}}convertInputMedia(e){if(!e||!e.hasOwnProperty("current")||!e.hasOwnProperty("paths"))return{current:-1,media:[]};const t=e.paths.filter(e=>e.type).map(e=>({id:e.media?Number(e.media.id):void 0,type:e.media?this.convertMediaType(e.media.unit):void 0,name:e.media?e.media.name||"":"",feed:{id:Number(e.id),type:this.convertMediaFeed(e.type),name:e.name},size:e.size?{unit:this.convertMediaUnit(e.size.unit),width:e.size.w,height:e.size.h||null}:void 0,remain:e.remain?{unit:this.convertMediaUnit(e.remain.unit),value:e.remain.value}:void 0}));return{current:Number(e.current),media:t}}convertTotalPrint(e){return e&&e.hasOwnProperty("unit")&&e.hasOwnProperty("value")?{unit:this.convertMediaUnit(e.unit),value:e.value}:{unit:{n:0,type:0},value:-1}}convertInk(e,t){return e?e.map(e=>({code:e.colorName,color:e.color,remain:e.remain,state:this.convertMntPartsStatus(e.state),ciss:this.convertCiss(t,e.cissInfo)})):[]}convertCiss(e,t){return{charge:t?this.convertCissCharge(t.level):{unknown:!0,remain:-1,text:"unknown"},reserve:t?this.convertCissReserve(t.reserve):"unknown",slot:t?this.convertCissSlotStatus(t.status):"unknown",error:_.merge(e?this.convertCissCommonError(e.state):{},t?this.convertCissError(t.state):{})}}convertCissCharge(e){const t=e.toUpperCase();let r="unknown";switch(t){case"0":r="0";break;case"1":r="1";break;case"2":r="2";break;case"3":r="3";break;case"4":r="4";break;case"5":r="5";break;case"6":r="6";break;case"EMPTY":r="empty"}return{empty:"EMPTY"===t||void 0,unknown:"UNKNOWN"===t||void 0,remain:Number.isNaN(Number(t))?-1:Number(t),text:r}}convertCissReserve(e){switch(e.toUpperCase()){case"NEW":return"new";case"USED":return"used";case"NONE":return"none";case"CANCELED":return"canceled";case"FAILED":return"failed";case"UNSETTLED":return"unsettled";case"UNKNOWN":default:return"unknown"}}convertCissSlotStatus(e){switch(e.toUpperCase()){case"NORMAL":return"normal";case"ERROR":return"error";case"LOW":return"low";case"LOW2":return"low2";case"CHARGEFAILED":return"chargeFailed";case"CHARGEFAILEDEND":return"chargeFailedEnd";case"NOTICE":return"notice";case"UNSETTLED":return"unsettled";case"UNKNOWN":default:return"unknown"}}convertCissCommonError(e){return{inkMixture:!!e.inkMixError||void 0}}convertCissError(e){return{inkEmpty:!!e.inkEmpty||void 0,inkMismatch:!!e.inkMismatch||void 0,inkSensor:!!e.sensorError||void 0,noChip:!!e.noChip||void 0,chipLockReleased:!!e.lockReleased||void 0,chipReadWrite:!!e.csicRWError||void 0,chipUnsettled:!!e.chipUnsettled||void 0,chipUnavailableA:!!e.chipUnavailableA||void 0,chipUnavailableB:!!e.chipUnavailableB||void 0,chipUnavailableC:!!e.chipUnavailableC||void 0,reserveFailed:!!e.reserveFailed||void 0,reserveCanceled:!!e.reserveCanceled||void 0,chargeFailed:!!e.chargeFailed||void 0,chargeRemainlow:!!e.low||void 0,chargeRemainlow2:!!e.low2||void 0,chargeRemainEnd:!!e.chargeEnd||void 0}}convertMntParts(e){return e?e.map(e=>({remain:e.remain,state:this.convertMntPartsStatus(e.state),name:e.name||void 0})):[]}convertHeater(e){if(e&&e.unit&&e.heaters)return e.heaters.map(t=>({current:t.currentTemp,setting:t.settingTemp,unit:this.convertHeaterUnit(e.unit),state:this.convertHeaterStatus(t.state),name:t.name||void 0}))}convertMntProgress(e){if(!e)return;const t=e=>e?{start:e.minutesToStart?60*e.minutesToStart:void 0,total:e.totalSeconds,elapsed:e.elapsedSeconds}:void 0;return{cleaning:t(e.cleaning),inkCirculation:t(e.inkStirring)}}convertMntNotice(e){if(e)return{cleaning:{seconds:e.seconds,length:e.length,pages:e.pages}}}convertJobProgress(e){if(e)return{statusCode:e.statusCode,total:e.totalSeconds,elapsed:e.elapsedSeconds}}convertEquipment(e){return e?{cdr:e["CD-REnabled"],duplexPrint:e.duplexPrintEnabled,boardTray:e.boardTrayEnabled,pw:e.PWEnabled,colorimetry:e.colorimetryEnabled,winder:e.winderEnabled,hdd:e.hddEnabled,headMode:e.headMode,ciss:e.CISS,psOption:e.PSOption,blower:this.convertBlowerState(e.blowerState),HDK:e.HDK,reel:e.reelEnabled,roll:e.rollEnabled}:{}}convertBlowerState(e){if(void 0===e||null===e)return e;switch(e){case 0:return 0;case 1:return 1;case 10:return 10;default:return 1}}}exports.K4StatusConverter=K4StatusConverter;class K4AttributesConverter{constructor(e,t,r){this.client=e,this.attributes=t,this.printer=r}convert(){return{allowAutoMonitoring:this.attributes.allowAutoMonitoring,monitoring:this.attributes.monitoring,monitoringRawBit:this.attributes.monitoringRawBit,printer:{serial:this.printer.serial,type:this.printer.interface.type},printerServer:{serial:this.client.serverSerial||""}}}}exports.K4AttributesConverter=K4AttributesConverter;class K4EmxInfoConverter{constructor(e){this.info=e}convert(){let e=/^\.(.+)/.exec(this.info.ext);const t=e?e[1].toLowerCase():"unknown",r=(e=/(\d{4})(\d{2})(\d{2})(\d{2})(\d{2})/.exec(this.info.timestamp.toString()))?new Date(Date.UTC(Number(e[1]),Number(e[2])-1,Number(e[3]),Number(e[4]),Number(e[5]))):new Date(0);return{type:t,id:this.info.id,model:this.info.series,serial:this.info.serial,timeStamp:r,publish:this.info.publish,mediaVendor:{en:this.info.manufacturer},mediaName:{en:this.info.media_name},mediaType:this.info.base_media,hasInformation:this.info.has_info,information:{},fileName:this.info.file_name,dir:this.info.data}}}exports.K4EmxInfoConverter=K4EmxInfoConverter;