"use strict";var __awaiter=this&&this.__awaiter||function(e,t,r,s){return new(r||(r=Promise))(function(i,n){function u(e){try{a(s.next(e))}catch(e){n(e)}}function o(e){try{a(s.throw(e))}catch(e){n(e)}}function a(e){e.done?i(e.value):new r(function(t){t(e.value)}).then(u,o)}a((s=s.apply(e,t||[])).next())})};Object.defineProperty(exports,"__esModule",{value:!0});const path=require("path"),fs=require("fs"),_=require("lodash"),uuid=require("node-uuid"),appError_1=require("../../../appError"),platform_1=require("../../../modules/platform"),k4Converter_1=require("./k4Converter");class K4RequestSender{static sendRequest(e,t){switch(t.request){case 100:return new K4GetAgencyID(e).sendRequest(t);case 101:return new K4GetDeviceList(e).sendRequest(t);case 102:return new K4GetStatus(e).sendRequest(t);case 103:return new K4GetAttributes(e).sendRequest(t);case 104:return new K4SetTime(e).sendRequest(t);case 105:return new K4SetMasterPC(e).sendRequest(t);case 106:return new K4SearchPrinter(e).sendRequest(t);case 107:return new K4RefreshPrinter(e).sendRequest(t);case 108:return new K4CheckConnection(e).sendRequest(t);case 109:return new K4GetPrinterData(e).sendRequest(t);case 110:return new K4GetStatusSheet(e).sendRequest(t);case 111:return new K4CleanNozzle(e).sendRequest(t);case 112:return new K4CheckNozzle(e).sendRequest(t);case 113:return new K4PreheatHeater(e).sendRequest(t);case 114:return new K4CircurateInk(e).sendRequest(t);case 115:return new K4GetDefaultMediaInfo(e).sendRequest(t);case 116:return new K4GetMediaInfo(e).sendRequest(t);case 117:return new K4SetPrinterFriendlyName(e).sendRequest(t);case 118:return new K4SetCurrentMedia(e).sendRequest(t);case 119:return new K4SetMedia(e).sendRequest(t);case 120:return new K4SetMediaFeed(e).sendRequest(t);case 121:return new K4SetMediaUsage(e).sendRequest(t);case 122:return new K4GetMediaLibrary(e).sendRequest(t);case 123:return new K4SetFile(e).sendRequest(t);case 124:return new K4SetEmxFile(e).sendRequest(t);case 125:return new K4GetFile(e).sendRequest(t);case 126:return new K4GetFilePath(e).sendRequest(t);case 127:return new K4RemoveFile(e).sendRequest(t);default:return Promise.resolve({err:new appError_1.default(1002,`[${e.ipAddress}] K4RequestSender: ${JSON.stringify(t)}`)})}}}exports.K4RequestSender=K4RequestSender;class K4Requester{constructor(e){this.client=e}sendRequest(e){return Promise.resolve({err:new appError_1.default(1e5,`[${this.client.ipAddress}] K4SendRequest`)})}error(e,t){if(e.err)return Promise.resolve(e);if(e.reply){if(0<=e.reply.result)return null;{let r=1005;switch(e.reply.result){case-9:case-11:r=1006;break;case-103:default:r=1005}return Promise.resolve({err:new appError_1.default(r,`[${this.client.ipAddress}] k4Result: ${this.sensitiveStringify(t)}`,e.reply.result)})}}return Promise.resolve({err:new appError_1.default(1e5,`[${this.client.ipAddress}] K4SendRequest: ${this.sensitiveStringify(t)}`)})}sensitiveStringify(e){return JSON.stringify(e,(e,t)=>{return["password"].some(t=>e.toLowerCase().includes(t))?"******":t})}}class K4GetAgencyID extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t={request:{type:"GetAgencyID",id:e.id||uuid.v4(),args:{}}},r=yield this.client.sendRequest(t,null,e.timeout),s=this.error(r,t);if(s)return s;{const e=r.reply;return e.args.uuid?Promise.resolve({uuid:e.args.uuid}):Promise.resolve({err:new appError_1.default(1005,`[${this.client.ipAddress}] k4Result Parameter('uuid'): ${t.request.type}`,e.result)})}})}}exports.K4GetAgencyID=K4GetAgencyID;class K4GetDeviceList extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t={request:{type:"GetDeviceList",id:e.id||uuid.v4(),args:{}}},r=yield this.client.sendRequest(t,null,e.timeout);return this.response(r,t)})}response(e,t){const r=this.error(e,t);if(r)return r;{const r=e.reply;if(r.args.devices){const e=new k4Converter_1.K4DeviceConverter(this.client,r.args.devices).convert();return Promise.resolve({printerServer:e})}return Promise.resolve({err:new appError_1.default(1005,`[${this.client.ipAddress}] k4Result Parameter('devices'): ${t.request.type}`,r.result)})}}}exports.K4GetDeviceList=K4GetDeviceList;class K4GetStatus extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t={request:{type:"GetStatus",device:{printerID:{serial:e.printer.serial}},id:e.id||uuid.v4(),args:e.params}},r=this.client.getPrinter(e.printer.serial,e.printer.type),s=yield this.client.sendRequest(t,e.printer.type,e.timeout);return this.response(s,t,r)})}response(e,t,r){const s=this.error(e,t);if(s)return s;{const t=e.reply,s=new k4Converter_1.K4StatusConverter(this.client,t.args,r).convert();return Promise.resolve({status:s})}}}exports.K4GetStatus=K4GetStatus;class K4GetAttributes extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t={request:{type:"GetAttributes",device:{printerID:{serial:e.printer.serial}},id:e.id||uuid.v4(),args:{}}},r=this.client.getPrinter(e.printer.serial,e.printer.type),s=yield this.client.sendRequest(t,e.printer.type,e.timeout);return this.response(s,t,r)})}response(e,t,r){const s=this.error(e,t);if(s)return s;{const t=e.reply,s=new k4Converter_1.K4AttributesConverter(this.client,t.args,r).convert();return Promise.resolve({attributes:s})}}}exports.K4GetAttributes=K4GetAttributes;class K4SetTime extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t=new Date,r={request:{type:"SetTime",device:{printerID:{serial:e.printer.serial}},id:e.id||uuid.v4(),args:{year:t.getFullYear(),month:t.getMonth()+1,day:t.getDate(),hour:t.getHours(),minute:t.getMinutes(),second:t.getSeconds()}}},s=yield this.client.sendRequest(r,e.printer.type,e.timeout);return this.error(s,r)||Promise.resolve({})})}}exports.K4SetTime=K4SetTime;class K4SetMasterPC extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t={request:{type:"SetMasterPC",device:{printerID:null},id:e.id||uuid.v4(),args:e.params}},r=yield this.client.sendRequest(t,null,e.timeout);return this.error(r,t)||Promise.resolve({})})}}exports.K4SetMasterPC=K4SetMasterPC;class K4SearchPrinter extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t=this.getPrinterAddresses(e.params.searchOptions),r={request:{type:"UpdateDeviceList",id:e.id||uuid.v4(),args:{ipv4:t.v4,ipv6:t.v6}}},s=yield this.client.sendRequest(r,null,e.timeout);return this.response(s,r)})}getPrinterAddresses(e){if(this.client.isLocalServer&&e.printerIpAddresses){const t=e.printerIpAddresses;return{v4:t.filter(e=>2===e.type).map(e=>e.ipAddress),v6:t.filter(e=>3===e.type).map(e=>e.ipAddress)}}return{}}response(e,t){const r=this.error(e,t);if(r)return r;{const r=e.reply;if(r.args.devices){const e=new k4Converter_1.K4DeviceConverter(this.client,r.args.devices).convert();return Promise.resolve({printerServer:e})}return Promise.resolve({err:new appError_1.default(1005,`[${this.client.ipAddress}] k4Result Parameter('devices'): ${t.request.type}`,r.result)})}}}exports.K4SearchPrinter=K4SearchPrinter;class K4RefreshPrinter extends K4SearchPrinter{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t=this.getPrinterAddresses(e.params.searchOptions),r={request:{type:"RenewDeviceList",id:e.id||uuid.v4(),args:{ipv4:t.v4,ipv6:t.v6}}},s=yield this.client.sendRequest(r,null,e.timeout);return this.response(s,r)})}}exports.K4RefreshPrinter=K4RefreshPrinter;class K4CheckConnection extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t={request:{type:"CheckPrinter",id:e.id||uuid.v4(),args:{ipv4:2===e.params.type?e.params.ipAddress:void 0,ipv6:3===e.params.type?e.params.ipAddress:void 0}}},r=yield this.client.sendRequest(t,null,e.timeout),s=this.error(r,t);if(s)return s;{const e=r.reply;return void 0!==e.args.exists&&null!==e.args.exists?Promise.resolve({exists:e.args.exists}):Promise.resolve({err:new appError_1.default(1005,`[${this.client.ipAddress}] k4Result Parameter('exists'): ${t.request.type} ${r.reply.args.exists}`,e.result)})}})}}exports.K4CheckConnection=K4CheckConnection;class K4GetPrinterData extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t=path.join(platform_1.default.TempDir,`PrinterData_${e.printer.serial}_${e.id}.dat`),r=e.params,s={request:{type:"GatherPrinterInfo",device:{printerID:{serial:e.printer.serial}},id:e.id||uuid.v4(),args:{filepath:t,password:r}}},i=yield this.client.sendRequest(s,e.printer.type,e.timeout),n=this.error(i,s);return n?(fs.exists(t,e=>{e&&fs.unlink(t,e=>{})}),n):Promise.resolve({url:`/api/internal/download?path=${t}&delete=true`})})}}exports.K4GetPrinterData=K4GetPrinterData;class K4GetStatusSheet extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t={request:{type:"GatherStatusSheet",device:{printerID:{serial:e.printer.serial}},id:e.id||uuid.v4(),args:{}}},r=yield this.client.sendRequest(t,e.printer.type,e.timeout);return this.error(r,t)||Promise.resolve({content:r.reply.args})})}}exports.K4GetStatusSheet=K4GetStatusSheet;class K4CleanNozzle extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t={request:{type:"CleanNozzle",device:{printerID:{serial:e.printer.serial}},id:e.id||uuid.v4(),args:e.params}},r=yield this.client.sendRequest(t,e.printer.type,e.timeout),s=this.error(r,t);return s||Promise.resolve({unnecessary:101===r.reply.result})})}}exports.K4CleanNozzle=K4CleanNozzle;class K4CheckNozzle extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t={request:{type:"CheckNozzle",device:{printerID:{serial:e.printer.serial}},id:e.id||uuid.v4(),args:e.params}},r=yield this.client.sendRequest(t,e.printer.type,e.timeout);return this.error(r,t)||Promise.resolve({})})}}exports.K4CheckNozzle=K4CheckNozzle;class K4PreheatHeater extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t={request:{type:"PreheatHeater",device:{printerID:{serial:e.printer.serial}},id:e.id||uuid.v4(),args:void 0==e.params?{}:e.params}},r=yield this.client.sendRequest(t,e.printer.type,e.timeout);return this.error(r,t)||Promise.resolve({})})}}exports.K4PreheatHeater=K4PreheatHeater;class K4CircurateInk extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t={request:{type:"CircurateInk",device:{printerID:{serial:e.printer.serial}},id:e.id||uuid.v4(),args:{}}},r=yield this.client.sendRequest(t,e.printer.type,e.timeout);return this.error(r,t)||Promise.resolve({})})}}exports.K4CircurateInk=K4CircurateInk;class K4GetDefaultMediaInfo extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t={request:{type:"GetDefaultMediaInfo",device:{printerID:{serial:e.printer.serial}},id:e.id||uuid.v4(),args:{baseMedia:e.params.baseMedia||"all"}}},r=yield this.client.sendRequest(t,e.printer.type,e.timeout),s=this.error(r,t);if(s)return s;{const e=r.reply;return Promise.resolve({mediaInfo:_.merge(e.args,{date:new Date})})}})}}exports.K4GetDefaultMediaInfo=K4GetDefaultMediaInfo;class K4GetMediaInfo extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t={request:{type:"GetMediaInfo",device:{printerID:{serial:e.printer.serial}},id:e.id||uuid.v4(),args:{no:e.params.no||"all",cache:!0!==e.params.update}}},r=yield this.client.sendRequest(t,e.printer.type,e.timeout),s=this.error(r,t);if(s)return s;{const e=r.reply;return Promise.resolve({mediaInfo:_.merge(e.args,{date:new Date(e.args.utc)})})}})}}exports.K4GetMediaInfo=K4GetMediaInfo;class K4SetPrinterFriendlyName extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t={request:{type:"SetPrinterFriendlyName",device:{printerID:{serial:e.printer.serial}},id:e.id||uuid.v4(),args:e.params}},r=yield this.client.sendRequest(t,e.printer.type,e.timeout);return this.error(r,t)||Promise.resolve({})})}}exports.K4SetPrinterFriendlyName=K4SetPrinterFriendlyName;class K4SetCurrentMedia extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t={request:{type:"SetCurrentMedia",device:{printerID:{serial:e.printer.serial}},id:e.id||uuid.v4(),args:e.params}},r=yield this.client.sendRequest(t,e.printer.type,e.timeout);return this.error(r,t)||Promise.resolve({})})}}exports.K4SetCurrentMedia=K4SetCurrentMedia;class K4SetMedia extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t={request:{type:"SetMedia",device:{printerID:{serial:e.printer.serial}},id:e.id||uuid.v4(),args:_.merge({version:0},e.params)}},r=yield this.client.sendRequest(t,e.printer.type,e.timeout);return this.error(r,t)||Promise.resolve({})})}}exports.K4SetMedia=K4SetMedia;class K4SetMediaFeed extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t={request:{type:"SetMediaFeed",device:{printerID:{serial:e.printer.serial}},id:e.id||uuid.v4(),args:e.params}},r=yield this.client.sendRequest(t,e.printer.type,e.timeout);return this.error(r,t)||Promise.resolve({})})}}exports.K4SetMediaFeed=K4SetMediaFeed;class K4SetMediaUsage extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t={request:{type:"SetMediaUsage",device:{printerID:{serial:e.printer.serial}},id:e.id||uuid.v4(),args:{count:0}}},r=yield this.client.sendRequest(t,e.printer.type,e.timeout);return this.error(r,t)||Promise.resolve({})})}}exports.K4SetMediaUsage=K4SetMediaUsage;class K4GetMediaLibrary extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t={request:{type:"GetEMXList",id:e.id||uuid.v4(),args:this.convert(e.params.conditions)}},r=yield this.client.sendRequest(t,null,e.timeout),s=this.error(r,t);if(s)return s;{const e=r.reply;return Promise.resolve({library:{total:e.args.total,media:e.args.emx.map(e=>new k4Converter_1.K4EmxInfoConverter(e).convert())}})}})}convert(e){if(!e)return{limit:1e3,offset:0};const t={limit:e.limit||1e3,offset:e.offset||0},r=[];return e.id&&r.push({type:1,value:e.id,operator:"="}),e.serial&&r.push({type:8,value:e.serial,operator:"="}),e.model&&r.push({type:2,value:e.model,operator:"="}),e.mediaVendor&&r.push({type:9,value:e.mediaVendor,operator:"="}),e.mediaName&&r.push({type:10,value:e.mediaName,operator:"="}),e.mediaType&&r.push({type:11,value:e.mediaType.toString(),operator:"="}),e.mediaInfo&&r.push({type:12,value:"1",operator:"="}),e.fileName&&r.push({type:4,value:e.fileName,operator:"="}),0!==r.length&&(t.cond=r),t}}exports.K4GetMediaLibrary=K4GetMediaLibrary;class K4SetFile extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t={request:{type:"SetFile",id:e.id||uuid.v4(),args:{app:e.params.model,id:e.params.id,path:e.params.path}}},r=yield this.client.sendRequest(t,null,e.timeout);return this.error(r,t)||Promise.resolve({})})}}exports.K4SetFile=K4SetFile;class K4SetEmxFile extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t={request:{type:"SetEMXFile",id:e.id||uuid.v4(),args:{path:e.params.path}}},r=yield this.client.sendRequest(t,null,e.timeout),s=this.error(r,t);if(s)return s;{const e=r.reply,t=new k4Converter_1.K4EmxInfoConverter(e.args).convert();return Promise.resolve({mediaInfo:t})}})}}exports.K4SetEmxFile=K4SetEmxFile;class K4GetFile extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t={request:{type:"GetFile",id:e.id||uuid.v4(),args:{app:e.params.model,id:e.params.id,folder:e.params.folder}}},r=yield this.client.sendRequest(t,null,e.timeout),s=this.error(r,t);if(s)return s;{const e=r.reply;return Promise.resolve({path:e.args.path})}})}}exports.K4GetFile=K4GetFile;class K4GetFilePath extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t={request:{type:"GetFilePath",id:e.id||uuid.v4(),args:{app:e.params.model,id:e.params.id}}},r=yield this.client.sendRequest(t,null,e.timeout),s=this.error(r,t);if(s)return s;{const e=r.reply;return Promise.resolve({readonly:e.args.readonly})}})}}exports.K4GetFilePath=K4GetFilePath;class K4RemoveFile extends K4Requester{constructor(e){super(e)}sendRequest(e){return __awaiter(this,void 0,void 0,function*(){const t={request:{type:"RemoveFile",id:e.id||uuid.v4(),args:{app:e.params.model,id:e.params.id}}},r=yield this.client.sendRequest(t,null,e.timeout);return this.error(r,t)||Promise.resolve({})})}}exports.K4RemoveFile=K4RemoveFile;