"use strict";var __awaiter=this&&this.__awaiter||function(e,t,r,i){return new(r||(r=Promise))(function(n,s){function o(e){try{a(i.next(e))}catch(e){s(e)}}function l(e){try{a(i.throw(e))}catch(e){s(e)}}function a(e){e.done?n(e.value):new r(function(t){t(e.value)}).then(o,l)}a((i=i.apply(e,t||[])).next())})};Object.defineProperty(exports,"__esModule",{value:!0});const events=require("events"),_=require("lodash"),appError_1=require("../../appError"),printerServerClient_1=require("./printerServerClient"),udp_1=require("./udp"),config_1=require("../data/config"),utility_1=require("../utility"),qlogger_1=require("../qlogger"),k4Requester_1=require("./k4/k4Requester"),k4Subscriber_1=require("./k4/k4Subscriber");class PrinterServerClientManger extends events.EventEmitter{constructor(){super(),this.localServerSerial="localhostServer",this.remoteClients={},this.eptmpFoundClients={},this.aliveRemoteClients={},this.onSubscribed=((e,t,r,i)=>{const n=k4Subscriber_1.K4SubscribeConverter.convert(e,t,r,i);n&&this.emit(PrinterServerClientManger.Events.Subscribed,e,n)}),this.onKeepAlive=(()=>__awaiter(this,void 0,void 0,function*(){const e=yield this.udp.eptmp.discover(PrinterServerClientManger.Time.eptmpTimeout),t=yield this.udp.eptmp.discover(PrinterServerClientManger.Time.eptmpTimeout),r=_.merge({},e,t),i=this.aliveRemoteClients;this.aliveRemoteClients={};for(const e of Object.keys(r))r[e].isLocal||(this.aliveRemoteClients[e]=r[e].addrInfo.address);const n=_.intersection(Object.keys(i),Object.keys(this.aliveRemoteClients)),s=_.difference(Object.keys(i),Object.keys(this.aliveRemoteClients)),o=_.difference(Object.keys(this.aliveRemoteClients),Object.keys(i));for(const e of n){const t=this.allNetworkClients.find(t=>t.serverSerial===e);if(t){const i=r[e].addrInfo;t.ipAddress!==i.address&&t.reconnect(i.address)}}for(const e of o){const t=this.allNetworkClients.find(t=>t.serverSerial===e);if(t){const i=r[e].addrInfo;t.ipAddress!==i.address?t.reconnect(i.address):t.restore()}else r[e].isAdditional||(this.eptmpFoundClients[e]=this.createPrinterServerClient({serverSerial:e}),qlogger_1.default.trace(`found: <${e}> ${r[e].addrInfo.address}`,"EPTMP"))}0===s.length&&0===o.length||this.emit(PrinterServerClientManger.Events.KeepAlive,{offline:s,online:o})})),this.clientSerial=config_1.default.getInst().serial,this.localClient=this.createPrinterServerClient({serverSerial:this.localServerSerial,isLocalServer:!0}),this.udp=new udp_1.default}get allRegisterdClients(){return[this.localClient].concat(Object.keys(this.remoteClients).map(e=>this.remoteClients[e]))}get allNetworkClients(){const e=Object.keys(this.remoteClients).map(e=>this.remoteClients[e]),t=Object.keys(this.eptmpFoundClients).map(e=>this.eptmpFoundClients[e]);return e.concat(t)}connect(e){this.updateConnection(e),this.udp.connect(),!this.keepAliveTimer&&config_1.default.getInst().settings.remoteConnection&&(clearInterval(this.keepAliveTimer),this.keepAliveTimer=setInterval(this.onKeepAlive,PrinterServerClientManger.Time.keepAliveInterval))}disconnect(){this.localClient.disconnect();for(const e of this.allNetworkClients)e.disconnect();this.udp.disconnect(),this.keepAliveTimer&&clearInterval(this.keepAliveTimer)}updateConnection(e){const t=e.filter(e=>e.isLocalServer),r=e.filter(e=>!e.isLocalServer);0===t.length?this.updateLocalConnection([]):this.updateLocalConnection(t[0].printers),0===r.length?this.updateRemoteConnection([]):this.updateRemoteConnection(r)}checkConnection(e,t=!1,r){return __awaiter(this,void 0,void 0,function*(){let t;t=utility_1.default.isLocalAddress(e)?this.localClient:this.allNetworkClients.find(t=>t.ipAddress===e);const i={request:100,timeout:r||PrinterServerClientManger.Time.checkConnectionTimeout};if(t)return yield this.sendRequestCore(t,i);{const t=new printerServerClient_1.default(this.clientSerial);t.connect(e);const r=yield this.sendRequestCore(t,i);return t.disconnect(),Promise.resolve(r)}})}hasPrinter(e){return 0!==this.allRegisterdClients.filter(t=>t.hasPrinter(e)).length}getPrinters(e){const t=this.allRegisterdClients.find(t=>t.serverSerial===e);return t?t.getPrinters().map(e=>({serial:e.serial,type:e.interface.type})):[]}getServers(e,t){return this.allRegisterdClients.filter(r=>!e||e&&r.hasPrinter(e,t)).map(e=>e.serverSerial)}sendRequest(e){switch(e.request){case 106:case 107:return this.discover(e);default:let t;return(t=e.printerServer&&e.printerServer.serial!==this.localServerSerial?this.remoteClients[e.printerServer.serial]:this.localClient)?this.sendRequestCore(t,e):Promise.resolve({err:new appError_1.default(1e3,`sendRequest: ${JSON.stringify(e)}`)})}}sendRequestLocal(e){return __awaiter(this,void 0,void 0,function*(){return this.sendRequestCore(this.localClient,e)})}sendRequestCore(e,t,r){return __awaiter(this,void 0,void 0,function*(){const r=yield k4Requester_1.K4RequestSender.sendRequest(e,t);return r.err&&qlogger_1.default.error(`sendRequest: ${r.err.toString()}`),Promise.resolve(r)})}createPrinterServerClient(e){return new printerServerClient_1.default(this.clientSerial,e).on(printerServerClient_1.default.Events.Subscribed,this.onSubscribed)}updateLocalConnection(e){this.localClient.isConnected||this.localClient.connect("localhost"),this.replacePrinter(this.localClient,e)}updateRemoteConnection(e){for(const t of Object.keys(this.remoteClients))if(!e.find(e=>e.serial===t)){const e=this.remoteClients[t];e.isAdditionalServer?(this.udp.eptmp.removeAddress(e.ipAddress,e.isV6Connection),e.disconnect(),delete this.remoteClients[t]):this.aliveRemoteClients.hasOwnProperty(t)?e.removeAllPrinter():(e.disconnect(),delete this.remoteClients[t])}for(const t of e){this.remoteClients.hasOwnProperty(t.serial)||(this.eptmpFoundClients.hasOwnProperty(t.serial)?(this.remoteClients[t.serial]=this.eptmpFoundClients[t.serial],delete this.eptmpFoundClients[t.serial]):this.remoteClients[t.serial]=this.createPrinterServerClient({serverSerial:t.serial,isAdditionalServer:t.isAdditionalServer}));const e=this.remoteClients[t.serial];e.ipAddress!==t.interface.ipAddress&&e.reconnect(t.interface.ipAddress),this.replacePrinter(e,t.printers),e.isAdditionalServer&&this.udp.eptmp.addAddress(e.ipAddress,e.isV6Connection)}}replacePrinter(e,t){const r=(e,t)=>e.serial===t.serial&&e.interface.type===t.interface.type,i=e.getPrinters(),n=_.intersectionWith(t,i,r),s=_.differenceWith(i,t,r),o=_.differenceWith(t,i,r),l=n.filter(t=>!e.isSameConnection(t.serial,t.interface.type,t));for(const t of n)e.updatePrinter(t.serial,t.interface.type,t);for(const t of s)e.removePrinter(t.serial,t.interface.type);for(const t of o)e.addPrinter(t.serial,t.interface.type,t);if(0!==o.length||0!==l.length){const t=o.concat(l).map(e=>({serial:e.serial,type:e.interface.type}));this.emit(PrinterServerClientManger.Events.Connected,{printers:t,server:e.serverSerial})}}discover(e){return __awaiter(this,void 0,void 0,function*(){const t=this.allRegisterdClients.concat(Object.keys(this.eptmpFoundClients).map(e=>this.eptmpFoundClients[e])),r=e.params.searchOptions.pcIpAddresses.filter(e=>{return!t.find(t=>t.ipAddress===e.ipAddress)}).map((e,t)=>{const r=this.createPrinterServerClient({isAdditionalServer:!0});return r.connect(e.ipAddress),r}),i=t=>__awaiter(this,void 0,void 0,function*(){const r={request:101,printerServer:{serial:t.serverSerial||""},timeout:e.timeout},i=yield this.sendRequestCore(t,r);return i.err?Promise.resolve({}):Promise.resolve(i)}),n=[];return n.push(this.sendRequestCore(this.localClient,e)),n.push(...this.allNetworkClients.map(e=>i(e))),n.push(...r.map(e=>i(e))),new Promise((e,t)=>{Promise.all(n).then(t=>{const r=t.filter(e=>e.err);e({err:0!==r.length?r[0].err:void 0,printerServers:t.filter(e=>e.printerServer).map(e=>e.printerServer)})}).catch(t=>{e(t instanceof Error?{err:new appError_1.default(2009,t),printerServers:[]}:{err:new appError_1.default(2009,"Promise: Exception"),printerServers:[]})})})})}}PrinterServerClientManger.Events={Subscribed:"Subscribed",KeepAlive:"KeepAlive",Connected:"Connected"},PrinterServerClientManger.Time={keepAliveInterval:1e4,checkConnectionTimeout:1e4,eptmpTimeout:3e3},exports.default=PrinterServerClientManger;