"use strict";var __awaiter=this&&this.__awaiter||function(e,r,i,t){return new(i||(i=Promise))(function(s,n){function d(e){try{a(t.next(e))}catch(e){n(e)}}function o(e){try{a(t.throw(e))}catch(e){n(e)}}function a(e){e.done?s(e.value):new i(function(r){r(e.value)}).then(d,o)}a((t=t.apply(e,r||[])).next())})};Object.defineProperty(exports,"__esModule",{value:!0});const _=require("lodash"),sql_1=require("./sql"),dbAccessor_1=require("./dbAccessor"),appError_1=require("../../appError"),platform_1=require("../platform"),config_1=require("./config");class DB{constructor(){this.db=new dbAccessor_1.default(platform_1.default.DbPath,dbAccessor_1.default.OPEN_READWRITE)}close(){this.db.close()}getConfiguration(...e){return new Promise((r,i)=>__awaiter(this,void 0,void 0,function*(){const i={},t=yield this.db.query(sql_1.sql.configuration,{$all:0===e.length?1:0,$key:e});for(const e of t)i[e.key]=e.value;r(i)}))}setConfiguration(e){return new Promise((r,i)=>__awaiter(this,void 0,void 0,function*(){const i=yield this.db.transaction(()=>__awaiter(this,void 0,void 0,function*(){let r={};for(const i of Object.keys(e))if((r=yield this.db.nonquery(sql_1.sql.updateConfiguration,{$key:i,$value:e[i],$use:0})).err)return Promise.resolve({err:new appError_1.default(100,`Configuration: [${i}][${e.config[i]}], '${r.err.message}'`)});return Promise.resolve({})}));r(i.err?{err:new appError_1.default(i.err.errCode||101,i.err)}:{})}))}getConnectionStructure(){return new Promise((e,r)=>__awaiter(this,void 0,void 0,function*(){const r=[],i=yield this.db.query(sql_1.sql.connectionPrinters,{$use:2});for(const e of i){let i=r.find((r,i,t)=>r.serial===e.server_serial);i||(i={id:e.printer_server_id,serial:e.server_serial,interface:{id:e.server_interface_id,type:e.server_interface_type,ipAddress:e.server_ip_address},isLocalServer:this.isLocal(e.server_ip_address),isAdditionalServer:1===e.server_use,printers:[]},r.push(i)),i.printers&&i.printers.push({id:e.printer_id,serial:e.serial,nickname:e.nickname,firmware:e.firmware,model:{id:e.model_id,name:e.model_name},interface:{id:e.interface_id,type:e.interface_type,ipAddress:e.ip_address},region:e.region,monitoring:e.monitoring,identity:e.identity,isAutoMonitoring:1===e.monitoring})}e(r)}))}getPrinters(){return __awaiter(this,void 0,void 0,function*(){const e=yield this.db.query(sql_1.sql.connectionPrinters,{$use:2}),r=[];for(const i of e){let e=r.find((e,r,t)=>e.serial===i.serial);switch(e||(e={serial:i.serial,nickname:i.nickname,firmware:i.firmware,model:i.model_name,region:i.region,interface:{usb:void 0,ipv4:void 0,ipv6:void 0},isAutoMonitoring:!0,isLocal:!1},r.push(e)),i.interface_type){case 1:e.interface.usb=!0,e.isAutoMonitoring=1===i.monitoring;break;case 2:e.interface.ipv4=i.ip_address;break;case 3:e.interface.ipv6=i.ip_address}this.isLocal(i.server_ip_address)&&(e.isLocal=!0)}return Promise.resolve(r)})}getRegistrationPrinters(){return __awaiter(this,void 0,void 0,function*(){const e=yield this.db.query(sql_1.sql.connectionPrinters,{$use:[1,2]}),r=[];for(const i of e){let e=r.find((e,r,t)=>e.serial===i.serial);if(e||(e={id:i.printer_id,serial:i.serial,nickname:i.nickname,firmware:i.firmware,model:{id:i.model_id,name:i.model_name},interface:{id:i.interface_id,type:i.interface_type,ipAddress:i.ip_address},region:i.region,monitoring:i.monitoring,isRegistered:2===i.use,isLocal:this.isLocal(i.server_ip_address),printerServers:[]},r.push(e)),e.printerServers){let r=e.printerServers.find((e,r,t)=>e.serial===i.server_serial);r||(r={id:i.printer_server_id,serial:i.server_serial,interface:{id:i.server_interface_id,type:i.server_interface_type,ipAddress:i.server_ip_address}},e.printerServers.push(r))}}return Promise.resolve(r)})}getSearchOptions(){return new Promise((e,r)=>__awaiter(this,void 0,void 0,function*(){const r={pcIpAddresses:[],printerIpAddresses:[]},i=yield this.db.query(sql_1.sql.searchIpAddresses);for(const e of i)switch(e.use){case 2:r.pcIpAddresses.push({id:e.id,type:e.type,ipAddress:e.ip_address});break;case 3:r.printerIpAddresses.push({id:e.id,type:e.type,ipAddress:e.ip_address})}e(r)}))}getModelName(e){return new Promise((r,i)=>__awaiter(this,void 0,void 0,function*(){const i=yield this.db.query(sql_1.sql.model,{$serial:e});r(0!==i.length?i[0].name:"")}))}setPrinterRegistration(e){return new Promise((r,i)=>__awaiter(this,void 0,void 0,function*(){const i=e.filter(e=>e.isRegistered).map(e=>e.serial),t=e.filter(e=>!e.isRegistered).map(e=>e.serial);if(0!==i.length){const e=(yield this.getPrinters()).map(e=>e.serial),s=_.difference(_.union(e,i),t);if(config_1.default.getInst().settings.registration.printer<s.length)return r({err:new appError_1.default(2001,`Printer Registration upper limit: [${e.length}][${i.length}][${t.length}]`)})}const s=yield this.db.transaction(()=>__awaiter(this,void 0,void 0,function*(){let r={};for(const i of e){const e={$serial:i.serial,$use:i.isRegistered?2:1};if((r=yield this.db.nonquery(sql_1.sql.updateRegistrationStatus,e)).err||(r=yield this.db.nonquery(sql_1.sql.updatePrinterNickname,{$serial:i.serial,$nickname:i.nickname})),r.err)return Promise.resolve({err:new appError_1.default(100,`Registration: ${i.serial}[${i.isRegistered}][${i.nickname}], message[${r.err.message}]`)})}return Promise.resolve({})}));r(s.err?{err:new appError_1.default(s.err.errCode||101,s.err)}:{})}))}setSearchDevice(e,r){return new Promise((i,t)=>__awaiter(this,void 0,void 0,function*(){if(e.isRegistered){const e=yield this.getSearchOptions(),t=r?e.printerIpAddresses||[]:e.pcIpAddresses;if(config_1.default.getInst().settings.registration.ipAddress<=t.length)return i({err:new appError_1.default(2001,`IP Address Registration upper limit: [${t.length}](${r})`)})}let t;const s=yield this.db.query(sql_1.sql.interface,{$type:e.type,$ip_address:e.ipAddress,$use:r?3:2});0!==s.length&&(t=s[0].id);const n={$id:t,$type:e.type,$ip_address:e.ipAddress,$use:e.isRegistered?r?3:2:0},d=yield this.db.nonquery(sql_1.sql.updateInterface,n);if(d.err)return i({err:new appError_1.default(100,`Interface: ${JSON.stringify(n)}, '${d.err.message}'`)});i(d)}))}renewPrinterList(e){return new Promise((r,i)=>__awaiter(this,void 0,void 0,function*(){const i=yield this.db.transaction(()=>__awaiter(this,void 0,void 0,function*(){let r={};if((r=yield this.db.nonquery(sql_1.sql.renewConnection)).err)return Promise.resolve({err:new appError_1.default(100,`Renew: '${r.err.message}'`)});for(const i of e)if((r=yield this.setConnectionStructureCore(i,!1)).err)return Promise.resolve({err:new appError_1.default(100,r.err)});return Promise.resolve({})}));r(i.err?{err:new appError_1.default(i.err.errCode||101,i.err)}:{})}))}setConnectionStructure(e,r){return new Promise((i,t)=>__awaiter(this,void 0,void 0,function*(){const t=yield this.db.transaction(()=>__awaiter(this,void 0,void 0,function*(){const i=yield this.setConnectionStructureCore(e,r);return i.err?Promise.resolve({err:new appError_1.default(100,i.err)}):Promise.resolve({})}));i(t.err?{err:new appError_1.default(t.err.errCode||101,t.err)}:{})}))}setConnectionStructureCore(e,r){return new Promise((i,t)=>__awaiter(this,void 0,void 0,function*(){let t={};if((t=yield this.setPrinterServer(e)).err)return i({err:new appError_1.default(100,t.err)});const s=t.id,n=[];for(const d of e.printers){if((t=yield this.setPrinter(d,s)).err)return i({err:new appError_1.default(100,t.err)});n.push(t.id);const e={printerServerId:s,printerId:t.id,userId:0,identity:d.identity};if((t=yield this.setConnection(e,d.serial,r)).err)return i({err:new appError_1.default(100,t.err)})}return i({})}))}setPrinterServer(e){return new Promise((r,i)=>__awaiter(this,void 0,void 0,function*(){let i,t=e.id,s=e.interface.id;if(!t||!s){const r=yield this.db.query(sql_1.sql.printerServer,{$serial:e.serial});0!==r.length&&(t=t||r[0].id,s=s||r[0].interface_id)}return(i=yield this.db.nonquery(sql_1.sql.updateInterface,{$id:s,$type:e.interface.type,$ip_address:e.interface.ipAddress,$use:1})).err?r({err:new appError_1.default(100,`Interface: [${s}][${JSON.stringify(e.interface)}], '${i.err.message}'`)}):(s=i.id,(i=yield this.db.nonquery(sql_1.sql.updatePrinterServer,{$id:t,$serial:e.serial,$interface_id:s,$use:e.use||e.isAdditionalServer?1:0})).err?r({err:new appError_1.default(100,`PrinterServer: [${s}][${JSON.stringify(e.interface)}], '${i.err.message}'`)}):(t=i.id,void r({err:i.err,id:t})))}))}setPrinter(e,r){return new Promise((r,i)=>__awaiter(this,void 0,void 0,function*(){let i,t=e.id,s=e.interface.id,n=e.nickname;if(!t||!s){const r=yield this.db.query(sql_1.sql.printer,{$serial:e.serial,$type:e.interface.type});0!==r.length&&(t=t||r[0].id,s=s||r[0].interface_id)}if(""===n){const r=yield this.db.query(sql_1.sql.nickname,{$serial:e.serial});n=0!==r.length?r[0].nickname:e.defaultNickname||""}if((i=yield this.db.nonquery(sql_1.sql.updateModel,{$name:e.model.name,$use:0})).err)return r({err:new appError_1.default(100,`Model: [${e.model.name}], '${i.err.message}'`)});const d=i.id;if((i=yield this.db.nonquery(sql_1.sql.updateInterface,{$id:s,$type:e.interface.type,$ip_address:e.interface.ipAddress,$use:1})).err)return r({err:new appError_1.default(100,`Interface: [${s}][${JSON.stringify(e.interface)}], '${i.err.message}'`)});s=i.id;let o;if(e.master){const r=yield this.db.query(sql_1.sql.masterPrinterServerId,{$ip_address:e.master.interface.ipAddress});o=0!==r.length?r[0].id:void 0}if((i=yield this.db.nonquery(sql_1.sql.updatePrinter,{$id:t,$serial:e.serial,$nickname:n,$model_id:d,$firmware:e.firmware,$interface_id:s,$region:e.region,$monitoring:e.monitoring,$printer_server_id:o,$use:0})).err)return r({err:new appError_1.default(100,`Printer: [${t}][${e.serial}][${n}][${d}][${s}][${o}], '${i.err.message}'`)});t=i.id,r({err:i.err,id:t})}))}setConnection(e,r,i){return new Promise((t,s)=>__awaiter(this,void 0,void 0,function*(){let s,n=0;if(i){const i=yield this.db.query(sql_1.sql.registrationStatus,{$printer_server_id:e.printerServerId,$serial:r});if(0!==i.length)n=i[0].use;else{n=2;const r={$printer_id:e.printerId,$use:2};s=yield this.db.nonquery(sql_1.sql.updateRegistrationStatus,r)}}else{const e=yield this.db.query(sql_1.sql.registrationStatus,{$serial:r});n=0!==e.length?e[0].use:1}if((s=yield this.db.nonquery(sql_1.sql.updateConnection,{$printer_server_id:e.printerServerId,$printer_id:e.printerId,$user_id:e.userId,$identity:e.identity,$use:n})).err)return t({err:new appError_1.default(100,`Connection: [${e.printerServerId}][${e.printerId}][${e.identity}][${n}], '${s.err.message}'`)});t({err:s.err,id:e.printerId})}))}isLocal(e){return"localhost"===e}}exports.default=DB;