"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.sql={printerServer:"SELECT\n                     printer_servers.id,\n                     printer_servers.serial,\n                     printer_servers.interface_id\n                    FROM\n                     printer_servers\n                    WHERE\n                     printer_servers.serial = $serial;",printer:"SELECT\n               printers.id,\n               printers.serial,\n               printers.nickname,\n               printers.firmware,\n               printers.region,\n               printers.printer_server_id,\n               interface.id as interface_id,\n               interface.type as interface_type,\n               interface.ip_address\n              FROM\n               printers,\n               interface\n              WHERE\n               printers.interface_id = interface.id AND\n               printers.serial = $serial AND\n               interface.type = $type;",connection:"SELECT\n                  printer_server_id,\n                  printer_id,\n                  user_id,\n                  identity,\n                  use\n                 FROM\n                  connections\n                 WHERE\n                  printer_server_id = $printer_server_id AND\n                  printer_id = $printer_id AND\n                  user_id = $user_id;",model:"SELECT\n             models.id,\n             models.name,\n             models.use\n            FROM\n             models,\n             printers\n            WHERE\n             printers.model_id = models.id AND\n             printers.serial = $serial;",interface:"SELECT\n                 id,\n                 type,\n                 ip_address,\n                 network_address,\n                 gateway,\n                 use\n                FROM\n                 interface\n                WHERE\n                 type = $type AND\n                 ip_address = $ip_address AND\n                 use = $use;",connectionPrinters:"SELECT\n                          connections.printer_server_id,\n                          connections.printer_id,\n                          connections.user_id,\n                          printers.serial,\n                          printers.nickname,\n                          printers.firmware,\n                          models.id as model_id,\n                          models.name as model_name,\n                          interface_prn.id as interface_id,\n                          interface_prn.type as interface_type,\n                          interface_prn.ip_address,\n                          printers.region,\n                          printers.monitoring,\n                          printer_servers.serial as server_serial,\n                          interface_svr.id as server_interface_id,\n                          interface_svr.type as server_interface_type,\n                          interface_svr.ip_address as server_ip_address,\n                          printer_servers.use as server_use,\n                          connections.identity,\n                          connections.use\n                         FROM\n                          connections,\n                          printer_servers,\n                          printers,\n                          models,\n                          interface as interface_svr,\n                          interface as interface_prn\n                         WHERE\n                          connections.use IN ($use) AND\n                          connections.printer_server_id = printer_servers.id AND\n                          connections.printer_id = printers.id AND\n                          printer_servers.interface_id = interface_svr.id AND\n                          printers.interface_id = interface_prn.id AND\n                          printers.model_id = models.id\n                         ORDER BY\n                          printers.nickname,\n                          models.name,\n                          -- localhost優先\n                          (CASE interface_svr.ip_address\n                            WHEN 'localhost' THEN 1\n                            ELSE 9\n                           END),\n                          -- 登録済み優先\n                          (CASE connections.use\n                            WHEN 2 THEN 1\n                            WHEN 1 THEN 2\n                            ELSE 9\n                           END),\n                          -- LAN優先 \n                          (CASE interface_prn.type\n                            WHEN 3 THEN 1\n                            WHEN 2 THEN 2\n                            WHEN 1 THEN 3\n                            ELSE 9\n                           END),\n                          interface_prn.ip_address;",searchIpAddresses:"SELECT\n                         id,\n                         type,\n                         ip_address,\n                         use\n                        FROM\n                         interface\n                        WHERE\n                         interface.use IN (2, 3);",configuration:"SELECT\n                     id,\n                     key,\n                     value\n                    FROM\n                     configurations\n                    WHERE\n                     $all = 1 OR key IN ($key);",nickname:"SELECT\n                nickname\n               FROM\n                printers\n               WHERE\n                serial = $serial\n               LIMIT 1;",registrationStatus:"SELECT\n                          connections.use\n                         FROM\n                          connections,\n                          printers\n                         WHERE\n                          connections.printer_id = printers.id AND\n                          (CASE WHEN $printer_server_id IS NULL THEN 1 ELSE connections.printer_server_id = $printer_server_id END) AND\n                          serial = $serial AND\n                          connections.use <> 0\n                         ORDER BY\n                          -- 登録済み優先\n                          (CASE connections.use\n                            WHEN 2 THEN 1\n                            WHEN 1 THEN 2\n                            ELSE 9\n                           END)\n                         LIMIT 1;",updatePrinterNickname:"UPDATE\n                             printers\n                            SET\n                             nickname = $nickname\n                            WHERE\n                             serial = $serial;",updatePrinterFirmware:"UPDATE\n                             printers\n                            SET\n                             firmware = $firmware\n                            WHERE\n                             serial = $serial;",updateRegistrationStatus:"UPDATE\n                                connections\n                               SET\n                                use = $use\n                               WHERE\n                                (CASE WHEN\n                                  $printer_id IS NOT NULL\n                                 THEN\n                                  printer_id = $printer_id\n                                 ELSE\n                                  printer_id IN (SELECT id FROM printers WHERE serial = $serial)\n                                 END) AND\n                                use <> 0;",renewConnection:"UPDATE\n                       connections\n                      SET\n                       use = 0\n                      WHERE\n                       use = 1;",updateConfiguration:"INSERT OR REPLACE INTO\n                           configurations (id, key, value, use)\n                          VALUES ((SELECT id FROM configurations WHERE key = $key),\n                                  $key,\n                                  $value,\n                                  $use);",updateModel:"INSERT OR REPLACE INTO\n                   models (id, name, use)\n                  VALUES (ifnull($id, (SELECT id FROM models WHERE name like '%' || $name)),\n                          $name,\n                          $use);",updateInterface:"INSERT OR REPLACE INTO\n                       interface (id, type, ip_address, network_address, gateway, use)\n                      VALUES (ifnull($id, (SELECT id FROM interface WHERE type = $type AND use = 0)),\n                              $type,\n                              $ip_address,\n                              $network_address,\n                              $gateway,\n                              $use);",updatePrinterServer:"INSERT OR REPLACE INTO\n                           printer_servers (id, serial, interface_id, use)\n                          VALUES (ifnull($id, (SELECT id FROM printer_servers WHERE serial = $serial)),\n                                  $serial,\n                                  $interface_id,\n                                  $use);",updatePrinter:"INSERT OR REPLACE INTO\n                     printers (id, serial, nickname, model_id, firmware, interface_id, region, monitoring, printer_server_id, use)\n                    VALUES ($id,\n                            $serial,\n                            $nickname,\n                            $model_id,\n                            $firmware,\n                            $interface_id,\n                            $region,\n                            $monitoring,\n                            $printer_server_id,\n                            $use);",updateConnection:"INSERT OR REPLACE INTO\n                        connections (printer_server_id, printer_id, user_id, identity, use)\n                       VALUES ($printer_server_id,\n                               $printer_id,\n                               $user_id,\n                               $identity,\n                               $use);",masterPrinterServerId:"SELECT\n                             id\n                            FROM\n                             printer_servers,\n                             interface\n                            WHERE\n                             printer_servers.interface_id = interface.id AND\n                             interface.ip_address = $ip_address;",registerAdditionalPrinterServer:"UPDATE\n                                       printer_servers\n                                      SET\n                                       use = 1\n                                      WHERE\n                                       id = (SELECT\n                                              printer_servers.id\n                                             FROM\n                                              printer_servers,\n                                              interface\n                                             WHERE\n                                              printer_servers.interface_id = interface.id AND\n                                              interface.ip_address = $ip_address);"};