"use strict";var __awaiter=this&&this.__awaiter||function(t,r,e,s){return new(e||(e=Promise))(function(a,i){function o(t){try{c(s.next(t))}catch(t){i(t)}}function n(t){try{c(s.throw(t))}catch(t){i(t)}}function c(t){t.done?a(t.value):new e(function(r){r(t.value)}).then(o,n)}c((s=s.apply(t,r||[])).next())})};Object.defineProperty(exports,"__esModule",{value:!0});const path=require("path"),fs=require("fs-extra");class Platform{static get SpecificInfoPath(){return path.join(Platform.DataDir,"DB","server.json")}static get DbPath(){return path.join(Platform.DataDir,"DB","EML_DATA.db")}static get SettingPath(){return path.join(Platform.DataDir,"DB","setting.json")}static get TempDir(){return path.join(Platform.DataDir,Platform.isWin?"Temp":"tmp")}static get LogDir(){return path.join(Platform.DataDir,"Log")}static get ScriptsDir(){let t=path.join(Platform.ProgramDir,"scripts");return fs.existsSync(t)||(t=process.cwd()),t}static get ProgramDir(){let t="";switch(process.platform){case"win32":t=path.join(process.env["ProgramFiles(x86)"]||process.env.ProgramFiles,"Epson Software","Epson Edge Dashboard");break;case"darwin":t=path.join("/Applications","Epson Software","Epson Edge Dashboard");break;default:t=path.join("/usr","sbin","Epson","Epson Edge Dashboard")}return t}static get DataDir(){let t="";switch(process.platform){case"win32":t=path.join(process.env.ALLUSERSPROFILE,"Epson","Epson Edge Dashboard");break;case"darwin":t=path.join("/Library","Application Support","Epson","EED Program Data");break;default:t=path.join("/var","lib","Epson","EED Program Data")}return fs.existsSync(t)||(t=process.cwd()),t}static get PublicDir(){let t="";switch(process.platform){case"win32":t=path.join(process.env.PUBLIC,"Documents","Epson","Control Dashboard");break;case"darwin":t=path.join("/Library","Application Support","Epson","Epson Control Dashboard");break;default:t=path.join("/usr","share","Epson","Epson Control Dashboard")}return t}static get EmxDir(){let t="";switch(process.platform){case"win32":case"darwin":t=Platform.PublicDir;break;default:t=path.join(Platform.PublicDir,"EMX")}return t}static get ProfileDir(){return path.join(Platform.PublicDir,"Profile")}static get isWin(){return"win32"===process.platform}static get isMac(){return"darwin"===process.platform}static get isLinux(){return!this.isWin&&!this.isMac}static get cssClass(){switch(process.platform){case"win32":return"win";case"darwin":return"mac";default:return"linux"}}static get RelayModulePath(){return this.isWin?path.join(Platform.ProgramDir,"bin","Utility","Relay.exe"):""}static getAccountingToolPath(){return __awaiter(this,void 0,void 0,function*(){if(this.isMac||this.isLinux)return Promise.resolve(void 0);const t=path.join("EPSON","LFP Accounting Tool","LFPAccountingTool.exe"),r=path.join(process.env["ProgramFiles(x86)"]||process.env.ProgramFiles,t),e=path.join(process.env.ProgramW6432||process.env.ProgramFiles,t);let s;return yield fs.access(r,fs.constants.R_OK).catch(t=>s=t),s?(s=void 0,yield fs.access(e,fs.constants.R_OK).catch(t=>s=t),s?Promise.resolve(void 0):Promise.resolve(e)):Promise.resolve(r)})}static getMediaSettingToolPath(){return __awaiter(this,void 0,void 0,function*(){let t="";if(this.isWin)t=path.join(process.env["ProgramFiles(x86)"]||process.env.ProgramFiles,"Epson Software","Epson Media Installer","MediaInstaller.exe");else{if(!this.isMac)return Promise.resolve(void 0);t=path.join("/Applications","Epson Software","Epson Media Installer","Epson Media Installer.app","Contents","MacOS","Epson Media Installer")}let r;return yield fs.access(t,fs.constants.R_OK).catch(t=>r=t),r?Promise.resolve(void 0):Promise.resolve(t)})}}exports.default=Platform;