"use strict";var __awaiter=this&&this.__awaiter||function(t,e,s,r){return new(s||(s=Promise))(function(i,a){function u(t){try{n(r.next(t))}catch(t){a(t)}}function f(t){try{n(r.throw(t))}catch(t){a(t)}}function n(t){t.done?i(t.value):new s(function(e){e(t.value)}).then(u,f)}n((r=r.apply(t,e||[])).next())})};Object.defineProperty(exports,"__esModule",{value:!0});const events=require("events"),_=require("lodash"),statusBuffer_1=require("./statusBuffer"),qlogger_1=require("../qlogger");class StatusMonitor extends events.EventEmitter{constructor(){super(),this.buffer={},this.registration=[],this.onSubscribed=((t,e)=>__awaiter(this,void 0,void 0,function*(){switch(t){case"NotifyPrinters":{const t=e;for(const e of t.printers){this.cache(t.serial,e.serial,e.interface.type,"printer",e).isChanged&&this.updateStatus(t.serial,e.serial,e.interface.type)}const s=e=>void 0!==t.printers.find(s=>t.serial===e.serverSerial&&s.serial===e.serial&&s.interface.type===e.type),r=this.registration.filter(e=>e.serverSerial===t.serial);for(const t of r)s(t)||this.lost(t.serverSerial,t.serial,t.type);break}case"NotifyStatus":{const t=e;this.cache(t.printerServer.serial,t.printer.serial,t.printer.type,"status",t).isChanged&&this.updateStatus(t.printerServer.serial,t.printer.serial,t.printer.type);break}case"NotifyAttributes":{const t=e;this.cache(t.printerServer.serial,t.printer.serial,t.printer.type,"attributes",t).isChanged&&this.updateStatus(t.printerServer.serial,t.printer.serial,t.printer.type);break}}})),this.onKeepAlive=(t=>{for(const e of t.offline)this.offline(e);for(const e of t.online)this.online(e)}),this.onNotifyStatus=(()=>{this.statusBuffer.update(),this.statusBuffer.isChanged&&(this.statusBuffer.changed.forEach(t=>{qlogger_1.default.info(`onNotifyStatus: [${t.printer.serial}] ${JSON.stringify(t)}`,"status")}),this.emit("NotifyStatus",this.statusBuffer.changed,this.statusBuffer.all),this.statusBuffer.resetChangedFlag())}),this.statusBuffer=new statusBuffer_1.default}start(){this.notifyStatusTimer||(clearInterval(this.notifyStatusTimer),this.notifyStatusTimer=setInterval(this.onNotifyStatus,StatusMonitor.NotifyStatusInterval))}stop(){this.notifyStatusTimer&&clearInterval(this.notifyStatusTimer)}updateRegistration(t){const e=[];for(const s of t)for(const t of s.printers)e.push({serverSerial:s.serial,serial:t.serial,type:t.interface.type});const s=_.differenceWith(this.registration,e,(t,e)=>t.serverSerial===e.serverSerial&&t.serial===e.serial&&t.type===e.type);for(const t of s)this.clearStatus(t.serverSerial,t.serial,t.type);this.registration=e}getStatus(...t){return this.statusBuffer.get(...t)}getUpdatedStatus(...t){this.onNotifyStatus();const e=0!==t.length?this.statusBuffer.get(...t):this.statusBuffer.all;return this.emit("NotifyStatus",e,this.statusBuffer.all),e}notifyStatus(t){this.onSubscribed("NotifyStatus",t);const e=this.statusBuffer.get(t.printer.serial);0!==e.length&&(qlogger_1.default.info(`notifyStatus: [${e[0].printer.serial}] ${JSON.stringify(e[0])}`,"status"),this.emit("NotifyStatus",e,this.statusBuffer.all))}cache(t,e,s,r,i){let a=!0;if(this.buffer.hasOwnProperty(t)||(this.buffer[t]={}),this.buffer[t].hasOwnProperty(e)||(this.buffer[t][e]={}),this.buffer[t][e].hasOwnProperty(s)||(this.buffer[t][e][s]={}),this.buffer[t][e][s].hasOwnProperty(r)&&(a=!_.isEqual(this.buffer[t][e][s][r],i)),this.buffer[t][e][s][r]=i,"printer"===r){const r=i;if(r.queues&&0!==r.queues.length){this.buffer[t][e][s].hasOwnProperty("queues")||(this.buffer[t][e][s].queues={});for(const i of r.queues)this.buffer[t][e][s].queues[i]=r}}return{isChanged:a}}updateStatus(t,e,s){if(!this.buffer.hasOwnProperty(t))return;if(!this.buffer[t].hasOwnProperty(e))return;if(!this.buffer[t][e].hasOwnProperty(s))return;const r=this.buffer[t][e][s];if(!r.status)return;const i=_.cloneDeep(r.status);i.isMonitoring=(r.attributes?r.attributes.monitoring:void 0)||!!r.printer&&r.printer.isAutoMonitoring,r.printer&&(i.nickname=r.printer.nickname,i.firmware=r.printer.firmware,i.ipAddress=2===r.printer.interface.type||3===r.printer.interface.type?r.printer.interface.ipAddress:void 0);const a={},u=this.buffer[t][e];for(const t of Object.keys(u))if(u[t].queues)for(const e of Object.keys(u[t].queues))a[e]={};i.queues=_.isEmpty(a)?void 0:Object.keys(a).sort(),this.statusBuffer.cache(i)}clearStatus(t,e,s){this.buffer.hasOwnProperty(t)&&this.buffer[t].hasOwnProperty(e)&&this.buffer[t][e].hasOwnProperty(s)&&delete this.buffer[t][e][s],this.statusBuffer.clear(t,e,s)}lost(t,e,s){if(!this.buffer.hasOwnProperty(t))return;if(!this.buffer[t].hasOwnProperty(e))return;if(!this.buffer[t][e].hasOwnProperty(s))return;const r=this.buffer[t][e][s];if(r.status&&1!==r.status.status){const i=r.status.status;r.status.status=1,this.updateStatus(t,e,Number(s)),qlogger_1.default.info(`lost: [${t}][${e}][${s}] "${i}"->"${r.status.status}"`,"status")}}offline(t){if(!this.buffer.hasOwnProperty(t))return;const e=this.buffer[t];for(const s of Object.keys(e))for(const r of Object.keys(e[s])){const i=e[s][Number(r)];if(i.status&&0!==i.status.status){const e=i.status.status;i.status.status=0,this.updateStatus(t,s,Number(r)),qlogger_1.default.info(`offline: [${t}][${s}][${r}] "${e}"->"${i.status.status}"`,"status")}}}online(t){if(!this.buffer.hasOwnProperty(t))return;const e=this.buffer[t];for(const s of Object.keys(e))for(const r of Object.keys(e[s])){const e=this.buffer[t][s][Number(r)];if(e.status&&0===e.status.status){const i=e.status.status;e.status.status=1,this.updateStatus(t,s,Number(r)),qlogger_1.default.info(`online: [${t}][${s}][${r}] "${i}"->"${e.status.status}"`,"status")}}}}StatusMonitor.NotifyStatusInterval=5e3,exports.default=StatusMonitor;