"use strict";var __awaiter=this&&this.__awaiter||function(e,r,i,t){return new(i||(i=Promise))(function(o,n){function s(e){try{d(t.next(e))}catch(e){n(e)}}function a(e){try{d(t.throw(e))}catch(e){n(e)}}function d(e){e.done?o(e.value):new i(function(r){r(e.value)}).then(s,a)}d((t=t.apply(e,r||[])).next())})};Object.defineProperty(exports,"__esModule",{value:!0});const path=require("path"),_=require("lodash"),uuid=require("node-uuid"),ini=require("ini"),util=require("util"),fs=require("fs-extra"),xml2js=require("xml2js"),JSZip=require("jszip"),appError_1=require("./appError"),platform_1=require("./modules/platform"),qlogger_1=require("./modules/qlogger"),contentDownloader_1=require("./modules/cloud/contentDownloader"),medialist_1=require("./models/javascripts/medialist"),intWindingFeedAdjList_1=require("./models/javascripts/intWindingFeedAdjList"),printerServerClientManger_1=require("./modules/communication/printerServerClientManger"),printerRequestHelper_1=require("./printerRequestHelper");class PrinterMediaData{constructor(e){this.printerMediaData=null,this.printer=e}dispose(){}get(e,r){return __awaiter(this,void 0,void 0,function*(){return this.printerMediaData||(yield this.load()),this.printerMediaData?e&&r?this.printerMediaData.hasOwnProperty(e)&&this.printerMediaData[e].hasOwnProperty(r)?Promise.resolve(this.printerMediaData):Promise.resolve(void 0):e?this.printerMediaData.hasOwnProperty(e)?Promise.resolve(this.printerMediaData):Promise.resolve(void 0):Promise.resolve(this.printerMediaData):Promise.resolve(null)})}set(e,r,i){return __awaiter(this,void 0,void 0,function*(){const t=yield this.get(e,r);return t?t[e][r].memo=i.memo:(null===t&&(this.printerMediaData={}),this.printerMediaData.hasOwnProperty(e)||(this.printerMediaData[e]={}),this.printerMediaData[e][r]={memo:i.memo}),this.save()})}load(){return __awaiter(this,void 0,void 0,function*(){const e=yield this.printer.sendRequest({request:126,params:{model:"EdgeDashboard",id:"PrinterMediaData"}});if(e.err){-4===e.err.errCodeK4&&(this.printerMediaData={})}else{const r=yield fs.readFile(e.readonly).catch(e=>null);this.printerMediaData=r?JSON.parse(r.toString()):{}}return Promise.resolve(e)})}save(){return __awaiter(this,void 0,void 0,function*(){const e=path.join(platform_1.default.TempDir,"data.json");if(yield fs.writeFile(e,Buffer.from(JSON.stringify(this.printerMediaData))).catch(e=>e))return Promise.resolve({err:new appError_1.default(2004)});{const r={request:123,params:{model:"EdgeDashboard",id:"PrinterMediaData",path:e}};return this.printer.sendRequest(r)}})}}class PrinterMedia{constructor(e,r,i,t,o,n){this.onSubscribed=((e,r)=>__awaiter(this,void 0,void 0,function*(){switch(e){case"NotifyMedia":const i=r,t={};t[i.printer.serial]=i,this.io.emit("NotifyUpdateMedia",t)}})),this.db=e,this.printer=r,this.printerModel=i,this.printerStatus=t,this.printerManagement=o,this.io=n,this.printerMediaData=new PrinterMediaData(this.printer),this.printer.on(printerServerClientManger_1.default.Events.Subscribed,this.onSubscribed)}dispose(){this.printerMediaData.dispose()}getMediaLibrary(e,r){return __awaiter(this,void 0,void 0,function*(){const i={id:r?r.id:void 0,request:122,params:{conditions:e},timeout:r?r.timeout:void 0},t=yield this.printer.sendRequest(i);if(t.err){if(-4===t.err.errCodeK4){return Promise.resolve({library:{total:0,media:[]}})}return Promise.resolve(t)}const o=yield this.getLanguage();for(const e of t.library.media){const r=path.join(e.dir,e.fileName);if("en"!==o){const i=e=>{const r=e.filter(e=>e.$["xml:lang"]===o);return 0!==r.length?r[0]._:void 0},t=yield this.getEmxControlXml(r);if(!t.err){const r=t.detail.xml.Model.MediaInfo[0],n=i(r.Manufacturer),s=i(r.MediaName);n&&(e.mediaVendor[o]=n),s&&(e.mediaName[o]=s)}}const i=yield this.getEmxInfo(r,o);i.err||(e.information=i.detail.info)}return Promise.resolve(t)})}getEmxDetail(e,r,i,t){return __awaiter(this,void 0,void 0,function*(){const o=yield this.getEmxPath(e,r);return o.err?Promise.resolve(o):this.getEmxDetailCore(o.readonly,e,r,i,t)})}getEmxDetails(e,r,i){return __awaiter(this,void 0,void 0,function*(){const t={details:{}},o=Object.keys(r);if(0===o.length)return Promise.resolve(t);const n=yield this.getEmxPaths(e,o,i);if(n.err)return Promise.resolve(n);for(const s of o)if(n.paths[s]){const o=n.paths[s].readonly,a=r[s],d=yield this.getEmxDetailCore(o,e,s,a,i);d.err||(t.details[s]=d.detail)}return Promise.resolve(t)})}importEmx(e){return __awaiter(this,void 0,void 0,function*(){return this.saveEmx(e,{timeout:5e3})})}deleteEmx(e,r,i){return __awaiter(this,void 0,void 0,function*(){const i={request:127,params:{model:e,id:r}};return this.printer.sendRequest(i)})}downloadEmx(e,r){return __awaiter(this,void 0,void 0,function*(){const i=yield this.download(e,platform_1.default.TempDir,r?r.timeout:void 0);if(i.err)return qlogger_1.default.error(`downloadEmx: "${i.err.message}" ${JSON.stringify(i.err)} "${e}"`),Promise.resolve({err:new appError_1.default("ENOSPC"!==i.err.code?2007:2008,i.err)});const t=i.path,o=yield this.saveEmx(t,r);return fs.unlink(t),Promise.resolve(o)})}getPrinterDefaultCpb(e,r,i){return __awaiter(this,void 0,void 0,function*(){const t=printerRequestHelper_1.default.select(e,i,this.printerStatus);if(t.err)return Promise.resolve({err:new appError_1.default(t.err)});const o={id:i?i.id:void 0,request:115,params:{baseMedia:r},printerServer:t.printerServer,printer:t.printer,timeout:i?i.timeout:void 0},n=yield this.printer.sendRequest(o);if(n.err)return Promise.resolve(n);for(const e of Object.keys(n.mediaInfo))Number.isNaN(Number(e))||n.mediaInfo[e].hasOwnProperty(PrinterMedia.cpbMemoKey)||(n.mediaInfo[e][PrinterMedia.cpbMemoKey]="");return Promise.resolve(n)})}getPrinterMedia(e,r,i,t){return __awaiter(this,void 0,void 0,function*(){const o=printerRequestHelper_1.default.select(e,t,this.printerStatus);if(o.err)return Promise.resolve({err:new appError_1.default(o.err)});const n={id:t?t.id:void 0,request:116,params:{no:r,update:i},printerServer:o.printerServer,printer:o.printer,timeout:t?t.timeout:void 0},s=yield this.printer.sendRequest(n);if(s.err)return Promise.resolve(s);for(const r of Object.keys(s.mediaInfo))if(!Number.isNaN(Number(r))){const i=yield this.printerMediaData.get(e,r);s.mediaInfo[r][PrinterMedia.cpbMemoKey]=i?i[e][r].memo:""}return Promise.resolve(s)})}setPrinterMedia(e,r,i){return __awaiter(this,void 0,void 0,function*(){const t=printerRequestHelper_1.default.select(e,i,this.printerStatus);if(t.err)return Promise.resolve({err:new appError_1.default(t.err)});const o={id:i?i.id:void 0,request:119,params:r,printerServer:t.printerServer,printer:t.printer,timeout:i?i.timeout:void 0},n=yield this.printer.sendRequest(o);for(const i of Object.keys(r))Number.isNaN(Number(i))||(yield this.printerMediaData.set(e,i,{memo:r[i][PrinterMedia.cpbMemoKey]}));return Promise.resolve(n)})}setPrinterMediaCurrent(e,r,i){return __awaiter(this,void 0,void 0,function*(){const t=printerRequestHelper_1.default.select(e,i,this.printerStatus);if(t.err)return Promise.resolve({err:new appError_1.default(t.err)});const o={id:i?i.id:void 0,request:118,params:{current:r.no},printerServer:t.printerServer,printer:t.printer,timeout:i?i.timeout:void 0};return this.printer.sendRequest(o)})}getPrinterMediaListPdf(e,r){return __awaiter(this,void 0,void 0,function*(){const i=yield this.getPrinterMediaList(e,r);if(i.err)return Promise.resolve(i);const t=new medialist_1.default,o=r?r.id||uuid.v4():uuid.v4(),n=path.join(platform_1.default.TempDir,`MediaList_${e}_${o}.pdf`),s=yield this.printerModel.getAppInfoBySerial(e),a=yield this.getLanguage(),d=yield t.save(n,s.modelKey,s.stringKey,a,i.content);return d?(qlogger_1.default.error(`getPrinterMediaListPdf: "${d.message}" ${JSON.stringify(d)} [${e}] ${JSON.stringify(r)}`),Promise.resolve({err:new appError_1.default(2e3,d)})):Promise.resolve({url:`/api/internal/download?path=${n}&delete=true`})})}createIntermittentWindingFeedAdjustListPdf(e,r){return __awaiter(this,void 0,void 0,function*(){const i=yield this.getPrinterMedia(e,void 0,!1,r);if(i.err)return Promise.resolve(null);for(const t of Object.keys(i.mediaInfo))if(!Number.isNaN(Number(t))&&(void 0===i.mediaInfo[t].ExpandParam||null===i.mediaInfo[t].ExpandParam))return qlogger_1.default.error(`createIntermittentWindingFeedAdjustListPdf: Invalid(${t}) ${JSON.stringify(i.mediaInfo)} [${e}] ${JSON.stringify(r)}`),Promise.resolve(null);const t=_.merge({serial:e,cpbModel:void 0,date:i.mediaInfo.date},i.mediaInfo),o=new intWindingFeedAdjList_1.default,n=path.join(platform_1.default.TempDir,`IntermittentWindingFeedAdjust_${e}.pdf`),s=yield this.getLanguage(),a=yield o.save(n,s,t);return a?(qlogger_1.default.error(`createIntermittentWindingFeedAdjustListPdf: "${a.message}" ${JSON.stringify(a)} [${e}] ${JSON.stringify(r)}`),Promise.resolve(null)):Promise.resolve(n)})}getPrinterCpbFile(e,r){return __awaiter(this,void 0,void 0,function*(){const i=yield this.getPrinterMedia(e,void 0,!1,r);if(i.err)return Promise.resolve({err:i.err});const t=e=>("0"+e).slice(-2);let o=yield this.db.getModelName(e);const n=this.printerModel.getAppInfo(o);n.options&&n.options.media&&n.options.media.cpbModel&&(o=n.options.media.cpbModel);const s=Object.keys(i.mediaInfo).filter(e=>!Number.isNaN(Number(e))).map(e=>Number(e)),a=new Date,d=util.format(PrinterMedia.cpb.MakeTimeFormat,a.getFullYear(),t(a.getMonth()+1),t(a.getDate()),t(a.getHours()),t(a.getMinutes()),t(a.getSeconds())),l={Base:{Version:PrinterMedia.cpb.Version,MakeTime:d,Model:o,SettingNum:Math.max(...s),SerialNumber:e}};for(const e of s){l[`Setting${t(e)}`]=i.mediaInfo[e.toString()]}const u=r?r.id||uuid.v4():uuid.v4(),m=path.join(platform_1.default.TempDir,`MediaFile_${e}_${u}.cpb`),p=yield fs.writeFile(m,ini.stringify(l)).catch(e=>e);return p?(qlogger_1.default.error(`getPrinterMediaFile: "${p.message}" ${JSON.stringify(p)} [${e}] ${JSON.stringify(r)}`),Promise.resolve({err:new appError_1.default(2004,p)})):Promise.resolve({url:`/api/internal/download?path=${m}&delete=true`})})}parsePrinterCpb(e){return __awaiter(this,void 0,void 0,function*(){let r;const i=yield fs.readFile(e).catch(e=>(r=e,null));if(r)return qlogger_1.default.error(`parsePrinterCpb: "${r.message}" ${JSON.stringify(r)} "${path.basename(e)}"`),Promise.resolve({err:new appError_1.default(2003,r)});const t=ini.parse(i.toString());if(!(t.hasOwnProperty("Base")&&t.Base.hasOwnProperty("Version")&&t.Base.hasOwnProperty("MakeTime")&&t.Base.hasOwnProperty("Model")))return qlogger_1.default.error(`parsePrinterCpb: invalid file format. "${path.basename(e)}"`),Promise.resolve({err:new appError_1.default(2005)});const o=util.format(PrinterMedia.cpb.MakeTimeFormat,"(\\d{4})","(\\d{1,2})","(\\d{1,2})","(\\d{1,2})","(\\d{1,2})","(\\d{1,2})");let n=new RegExp(o).exec(t.Base.MakeTime);const s=n?new Date(Number(n[1]),Number(n[2])-1,Number(n[3]),Number(n[4]),Number(n[5]),Number(n[6])):new Date(0),a={serial:t.Base.SerialNumber,cpbModel:t.Base.Model,date:s};for(const e of Object.keys(t))(n=/Setting0?(\d+)/i.exec(e))&&(a[n[1]]=t[e]);return Promise.resolve({mediaInfo:a})})}getEmxControlXml(e,r){return __awaiter(this,void 0,void 0,function*(){const r=this.getEmxDownloadUrl(e),i=path.dirname(e),t=(yield fs.readdir(i).catch(e=>[])).filter(e=>/.*\.xml$/i.test(e));if(0===t.length)return Promise.resolve({detail:{url:r}});const o=path.join(i,t[0]),n=yield fs.readFile(o).catch(e=>null);if(!n)return Promise.resolve({detail:{url:r}});let s=yield util.promisify(xml2js.parseString.bind(xml2js))(n).catch(e=>null);return s?(s=yield this.filter3LPrintMode(s),Promise.resolve({detail:{xml:s,url:r}})):Promise.resolve({detail:{url:r}})})}getEmxCpb(e,r){return __awaiter(this,void 0,void 0,function*(){const r=this.getEmxDownloadUrl(e),i=path.dirname(e),t=(yield fs.readdir(i).catch(e=>[])).filter(e=>/.*\.cpb$/i.test(e));if(0===t.length)return Promise.resolve({detail:{url:r}});const o=path.join(i,t[0]),n=yield this.parsePrinterCpb(o);return n.err?Promise.resolve(n):Promise.resolve({detail:{cpb:n.mediaInfo,url:r}})})}getEmxCpbFix(e,r){return __awaiter(this,void 0,void 0,function*(){const i=yield this.getEmxCpb(e,r);if(i.err)return Promise.resolve(i);const t=yield this.getEmxControlXml(e,r);if(t.err)return Promise.resolve(i);for(const e of Object.keys(i.detail.cpb))Number.isNaN(Number(e))||(i.detail.cpb[e].MediaID=t.detail.xml.Model.MediaInfo[0].ID[0]);return Promise.resolve(i)})}getEmxInfo(e,r,i){return __awaiter(this,void 0,void 0,function*(){const i=this.getEmxDownloadUrl(e),t={};r=r||"en";const o=path.join(path.dirname(e),"files",r,"Information.txt");if(!(yield fs.access(o).catch(e=>e))){const e=yield fs.readFile(o).catch(e=>null);e&&(t[r]=e.toString())}return Promise.resolve({detail:{info:t,url:i}})})}getPrinterMediaList(e,r){return __awaiter(this,void 0,void 0,function*(){const i=(yield this.db.getPrinters()).filter(r=>r.serial===e);if(0===i.length)return Promise.resolve({err:new appError_1.default(2009)});const t=i[0],o=yield this.getPrinterMedia(e,void 0,!1,r);if(o.err)return Promise.resolve(o);const n={};let s=!0;const a={};for(const e of Object.keys(o.mediaInfo))if(!isNaN(Number(e))){const r=Number(e);n[r]=o.mediaInfo[r],n[r].hasOwnProperty("MediaID")?0!==n[r].MediaID&&(a[n[r].MediaID]={xml:!0}):s=!1}const d=s?yield this.getEmxDetails(t.model,a,r):void 0,l={printer:{serial:t.serial,nickname:t.nickname,firmware:t.firmware,model:t.model},media:[],disable:{mediaVendor:!s},date:new Date(o.mediaInfo.date)};for(const e of Object.keys(n)){const r=n[Number(e)];let i="";d&&!d.err&&d.details[r.MediaID]&&(i=d.details[r.MediaID].xml.Model.MediaInfo[0].Manufacturer[0]._),l.media.push({no:Number(e),name:r.MediaName||"",mediaName:r.MediaFullName||"",mediaType:r.hasOwnProperty("LegacyBaseMedia")?r.LegacyBaseMedia:r.hasOwnProperty("BaseMedia")?r.BaseMedia:-1,mediaVendor:i})}return Promise.resolve({content:l})})}getEmxPath(e,r,i){return __awaiter(this,void 0,void 0,function*(){const t={id:i?i.id:void 0,request:126,params:{model:e,id:r},timeout:i?i.timeout:void 0};return this.printer.sendRequest(t)})}getEmxPaths(e,r,i){return __awaiter(this,void 0,void 0,function*(){const t=[];for(let r=0;;r++){const o={id:i?i.id:void 0,request:122,params:{conditions:{model:e,limit:100,offset:100*r}},timeout:i?i.timeout:void 0},n=yield this.printer.sendRequest(o);if(n.err&&0===t.length)return Promise.resolve(n);if(!n.library||0===n.library.media.length)break;if(t.push(...n.library.media),n.library.total<100*(r+1))break}const o={paths:{}},n=t.filter(e=>-1!==r.indexOf(e.id));for(const e of n)o.paths[e.id]={readonly:path.join(e.dir,e.fileName)};return Promise.resolve(o)})}getEmxDetailCore(e,r,i,t,o){return __awaiter(this,void 0,void 0,function*(){const r={detail:{url:this.getEmxDownloadUrl(e)}};let i=r;if(t.xml){if((i=yield this.getEmxControlXml(e,o)).err)return Promise.resolve(i);r.detail=_.merge(r.detail,i.detail)}if(t.cpb){if((i=yield this.getEmxCpbFix(e,o)).err)return Promise.resolve(i);r.detail=_.merge(r.detail,i.detail)}if(t.info){if((i=yield this.getEmxInfo(e,t.lang,o)).err)return Promise.resolve(i);r.detail=_.merge(r.detail,i.detail)}return Promise.resolve(r)})}saveEmx(e,r){return __awaiter(this,void 0,void 0,function*(){const i=yield this.verifyEmx(e);if(!i.valid){const e=i.rip?2006:2005;return Promise.resolve({err:new appError_1.default(e)})}const t=path.basename(e),o=t.split(" ")[0],n=path.join(platform_1.default.EmxDir,o);let s=0;if(yield fs.mkdirs(n).catch(e=>null),yield util.promisify(fs.copyFile)(e,path.join(n,t)).catch(e=>{s="ENOSPC"===e.code?2008:2007}),0!==s)return Promise.resolve({err:new appError_1.default(s)});const a={id:r?r.id:void 0,request:124,params:{path:e},timeout:r?r.timeout:void 0};return yield this.printer.sendRequest(a)})}download(e,r,i){return __awaiter(this,void 0,void 0,function*(){const t=yield this.db.getConfiguration("HttpProxy","HttpProxyPort","HttpsProxy","HttpsProxyPort"),o=(e,r)=>e&&r&&""!==e&&""!==r?`${e}:${r}`:null,n=new contentDownloader_1.default;return n.httpProxy=o(t.HttpProxy,t.HttpProxyPort),n.httpsProxy=o(t.HttpsProxy,t.HttpsProxyPort),yield fs.mkdirs(r).catch(e=>null),yield n.download(e,r,i)})}verifyEmx(e){return __awaiter(this,void 0,void 0,function*(){if(!/.+\.(emx|epml)$/i.test(e))return Promise.resolve({valid:!1});const r=yield fs.readFile(e).catch(e=>null);if(!r)return Promise.resolve({valid:!1});const i=yield JSZip.loadAsync(r).catch(e=>null);if(!i)return Promise.resolve({valid:!1});const t=i.files,o=Object.keys(t).filter(e=>(e=>!e.dir&&0===path.parse(e.name).dir.length&&/.*\.xml$/i.test(e.name))(t[e]));if(0===o.length)return Promise.resolve({valid:!1});const n=yield t[o[0]].async("text").catch(e=>null);if(!n)return Promise.resolve({valid:!1});const s=yield util.promisify(xml2js.parseString.bind(xml2js))(n).catch(e=>null);if(!(s&&s.hasOwnProperty("Model")&&s.Model.hasOwnProperty("EMXFileInfo")&&s.Model.hasOwnProperty("MediaInfo")&&Array.isArray(s.Model.EMXFileInfo)&&Array.isArray(s.Model.MediaInfo)))return Promise.resolve({valid:!1});const a=s.Model.EMXFileInfo[0],d=s.Model.MediaInfo[0];if(!a.hasOwnProperty("Publish")||!Array.isArray(a.Publish))return Promise.resolve({valid:!1});if(!d.hasOwnProperty("ID")||!Array.isArray(d.ID))return Promise.resolve({valid:!1});const l=d.ID[0],u=a.Publish[0];return l?0===l.indexOf("90")?Promise.resolve({valid:!1,rip:!0}):"All"!==u&&"SEC_Eval"!==u?Promise.resolve({valid:!1}):Promise.resolve({valid:!0}):Promise.resolve({valid:!1})})}filter3LPrintMode(e){return __awaiter(this,void 0,void 0,function*(){const r=yield this.printerManagement.getPrinters();return 0!==_.uniq(r.filter(e=>e.appInfo.options&&e.appInfo.options.mode3&&-1===e.appInfo.options.mode3.indexOf(e.region)).map(e=>e.model)).length&&_.remove(e.Model.MediaInfo[0].ModeInfo,e=>"3"===e.OnePassLayerNum[0]),Promise.resolve(e)})}getLanguage(){return __awaiter(this,void 0,void 0,function*(){const e=(yield this.db.getConfiguration("Language")).Language;return Promise.resolve(e)})}getEmxDownloadUrl(e){return`/api/internal/download?path=${e}`}}PrinterMedia.cpb={Version:"1.0.0",MakeTimeFormat:"%s/%s/%s %s:%s:%s"},PrinterMedia.cpbMemoKey="MediaFullName",exports.default=PrinterMedia;