// TODO: Move all of this setup into test helper
import chai, { expect } from 'chai';
import sinonChai from 'sinon-chai';
import { jsdom } from 'jsdom';
import sinon from 'sinon';
import jsonp from '../src/superagent-jsonp';

chai.use(sinonChai);

const generateDOM = () => {
  global.navigator = {
    userAgent: 'node.js',
  };

  global.window = jsdom('<html><body></body></html>');
  global.document = window;
};

const tearDownDOM = () => {
  delete global.navigator;
  delete global.document;
  delete global.window;
};

describe('SuperagentJSONP', () => {
  let sandbox;
  let clock;

  beforeEach(() => {
    sandbox = sinon.sandbox.create();
    clock = sinon.useFakeTimers();
  });

  afterEach(() => {
    sandbox.restore();
  });

  describe('#jsonp', () => {
    const end = 'Hello ';
    const requestMock = { end };

    context('when window is not defined', () => {
      it('does nothing', () => {
        expect(jsonp({})('hello')).to.eq('hello');
      });
    });

    context('when window is defined', () => {
      beforeEach(generateDOM);
      afterEach(tearDownDOM);

      it('sets up the request object', () => {
        const newRequest = jsonp({})(requestMock);
        expect(newRequest.end).not.to.eq(end);
        expect(typeof newRequest.end).to.eq('function');
      });
    });

    context('when the url returns a 404', () => {
      const superagentMock = {
        _query: [],
        url: 'http://test.com',
      };

      beforeEach(generateDOM);
      afterEach(tearDownDOM);

      it('calls the error handler', () => {
        const callbackSpy = sandbox.spy();
        sinon.spy(jsonp, 'errorWrapper');

        jsonp({ timeout: 100 })(superagentMock).end(callbackSpy);

        clock.tick(110);

        expect(jsonp.errorWrapper).to.have.been.called; // eslint-disable-line no-unused-expressions
        expect(callbackSpy).to.have.been.calledWith(new Error('404 NotFound'), null);
      });

      it('script and window callback are correctly removed', () => {
        const callbackName = 'testErrorCb';
        jsonp({ timeout: 10, callbackName })(superagentMock).end(() => {});

        clock.tick(15);

        expect(typeof window[callbackName]).to.eq('undefined');
        expect(document.querySelectorAll('script').length).to.eq(0);
      });
    });
  });
});
