#!/bin/sh
if [ "`whoami`" != "root" ]; then
    echo 'error: This script must be run as root'
    exit 1
fi

cd `dirname $0`

case `echo $LANG | awk '{print substr($0, 1, 2)}'` in
de)
    eula='eula/EULA_german-utf8.txt'
    ;;
es)
    eula='eula/EULA_spanish-utf8.txt'
    ;;
fr)
    eula='eula/EULA_french-utf8.txt'
    ;;
it)
    eula='eula/EULA_italian-utf8.txt'
    ;;
ja)
    eula='eula/EULA_japanese-utf8.txt'
    ;;
ko)
    eula='eula/EULA_korean-utf8.txt'
    ;;
nl)
    eula='eula/EULA_dutch-utf8.txt'
    ;;
pt)
    eula='eula/EULA_portuguese-utf8.txt'
    ;;
ru)
    eula='eula/EULA_russian-utf8.txt'
    ;;
tr)
    eula='eula/EULA_turkish-utf8.txt'
    ;;
zh)
    case `echo $LANG | awk '{print substr($0, index($0, "_")+1, 2)}'` in
    CN)
        eula='eula/EULA_schinese-utf8.txt'
        ;;
    *)
        eula='eula/EULA_tchinese-utf8.txt'
        ;;
    esac
    ;;
*)
    eula='eula/EULA_english-utf8.txt'
    ;;
esac

more $eula
while true
do
    read -p "agree?(y:yes,n:no,r:show again) " yn
    case "$yn" in
    [yY])
        break
        ;;
    [nN])
        exit 1
        ;;
    [rR])
        more $eula
        ;;
    esac
done

EED=`basename epson-edge-dashboard_*`
if [ "$EED" = 'epson-edge-dashboard_*' ]; then
	echo 'error: Epson Edge Dashboard not found'
	exit 1
fi

EDF=`basename epson-deviceframework_*`
if [ "$EDF" = 'epson-deviceframework_*' ]; then
	echo 'error: Epson DeviceFramework not found'
	exit 1
fi

dpkg -i "$EDF"
if [ $? != 0 ]; then
	echo 'error: Epson DeviceFramework installation failed.'
	exit 1
fi

dpkg -i "$EED"
if [ $? != 0 ]; then
	echo 'error: Epson Edge Dashboard installation failed.'
	exit 1
fi

ECDPath="/usr/sbin/EpsonControlDashboard/"
if [ -d "$ECDPath" ]; then
	dpkg --purge epson-control-dashboard
fi

exit 0

