// Copyright 2020 Seiko Epson Corporation.
// Epson Europe
// EEB/RDC
// 2020/12  ka
// This program is intended for demonstration purposes only and not for production environment.

#ifndef __EPSONTSELIBCMULTI_H__
#define __EPSONTSELIBCMULTI_H__

#ifdef __TSE_USING_STATIC_LIB__
#define EPSON_TSE_API
#else /*__TSE_USING_STATIC_LIB__*/
//FOR DLL
#ifdef EPSON_TSE_EXPORTS
#define EPSON_TSE_API __declspec(dllexport)
#else /*EPSON_TSE_EXPORTS*/
#define EPSON_TSE_API __declspec(dllimport)
#endif /*EPSON_TSE_EXPORTS*/
#endif /*__TSE_USING_STATIC_LIB__*/

#ifdef __cplusplus
extern "C" {
#endif /*__cplusplus*/


/**** Log Levels ****/
#define TSELIBCLOGLVLDISABLE			0x00
#define TSELIBCLOGLVLERROR				0x01
#define TSELIBCLOGLVLWARNING			0x02
#define TSELIBCLOGLVLINFO				0x03
#define TSELIBCLOGLVLTRACE				0x04
#define TSELIBCLOGLVLVERBOSE			0x05

/**** Log Methods ****/
#define TSELIBCLOGDEBUGGER				(1<<0)
#define TSELIBCLOGFILE					(1<<1)
#define TSELIBCLOGSTDOUT				(1<<2)
#define TSELIBCLOGDEBUGGERANDFILE		(TSELIBCLOGDEBUGGER|TSELIBCLOGFILE)
#define TSELIBCLOGDEBUGGERANDSTDOUT		(TSELIBCLOGDEBUGGER|TSELIBCLOGSTDOUT)
#define TSELIBCLOGFILEANDSTDOUT			(TSELIBCLOGFILE|TSELIBCLOGSTDOUT)
#define TSELIBCLOGALL					(TSELIBCLOGDEBUGGER|TSELIBCLOGFILE|TSELIBCLOGSTDOUT)

/**** Access Methods for TSEConnect() ****/
#define ACCESS_BY_SERIAL_ESCPOS			0x0
#define ACCESS_BY_NETWORK_ESCPOS		0x1
#define ACCESS_BY_EPOS_DEVICE			0x2

/**** TSE Information data struct ****/
#define NULLCHAR 1
typedef struct 
{	
	unsigned long int	softwareVersion;
	unsigned long int	hardwareVersion;
	unsigned long int	tseCapacity;
	unsigned long int	tseCurrentSize;
	unsigned long int	timeUntilNextSelfTest;
	unsigned long int	maxUpdateDelay;
	unsigned long int	startedTransactions;
	unsigned long int	maxStartedTransactions;
	unsigned long int	createdSignatures;
	unsigned long int	remainingSignatures;
	unsigned long int	maxSignatures;
	unsigned long int	registeredClients;
	unsigned long int	maxRegisteredClients;
	unsigned long int	tarExportSize;
	unsigned long int	certificateExpirationDate;
	unsigned long int	lastExportExecutedDate;
	unsigned char		certificateExpirationDateStr[30 + NULLCHAR];
	unsigned char		lastExportExecutedDateStr[30 + NULLCHAR];
	unsigned char		vendorType[100 + NULLCHAR];
	unsigned char		tseInitializationState[100 + NULLCHAR];
	unsigned char		tseDescription[128 + NULLCHAR];
	unsigned char		signatureAlgorithm[100 + NULLCHAR];
	unsigned char		cdcId[18 + NULLCHAR];
	unsigned char		cdcHash[64 + NULLCHAR];
	unsigned char		*serialNumber = NULL;
	unsigned long int	serialNumberLength = 0;
	unsigned char		*tsePublicKey = NULL;
	unsigned long int	tsePublicKeyLength = 0;
	unsigned char		*rawTseInfo = NULL;
	unsigned long int	rawTseInfoLength = 0;
	bool 				hasValidTime;
	bool 				hasPassedSelfTest;
	bool 				isTransactionInProgress;
	bool 				isTSEUnlocked;
	bool				isExportEnabledIfCspTestFails;
} EPSON_TSE_INFO;

typedef struct
{
	unsigned char		spareBlockStatus_healthStatus[64 + NULLCHAR];
	unsigned long int	spareBlockStatus_remainingSpareBlocks;
	unsigned char		dataIntegrity_healthStatus[64 + NULLCHAR];
	unsigned long int	dataIntegrity_uncorrectableECCErrors;
	unsigned char		eraseLifetimeStatus_healthStatus[64 + NULLCHAR];
	unsigned long int	eraseLifetimeStatus_remainingEraseCounts;
	unsigned long int	remainingTenYearsDataRetention;
	unsigned char		tseHealth[64 + NULLCHAR];
	bool 				isReplacementNeeded;
} EPSON_TSE_SMART_INFO;

typedef void* EPSON_TSE_HANDLE;
/**************** API Functions ****************/
EPSON_TSE_API short int GetTseDeviceList(
	/*in*/  unsigned char		*ipAddress,
	/*in*/  unsigned long int	ipAddressLength,
	/*out*/ unsigned char		**tseDeviceList,
	/*out*/ unsigned long int	*tseDeviceListSize);

EPSON_TSE_API short int TSEConnect(
	/*in*/  unsigned short int	method,
	/*in*/  unsigned char		*portId,
	/*in*/  unsigned long int	portIdLength,
	/*in*/  unsigned char		*tseId,
	/*in*/  unsigned long int	tseIdLength,
	/*out*/ EPSON_TSE_HANDLE*	tseHandle);

EPSON_TSE_API short int TSEDisconnect(
	/*in*/  EPSON_TSE_HANDLE	tseHandle);

EPSON_TSE_API short int TSEOpenDevice(
	/*in*/  EPSON_TSE_HANDLE	tseHandle);

EPSON_TSE_API short int TSECloseDevice(
	/*in*/  EPSON_TSE_HANDLE	tseHandle);

EPSON_TSE_API short int Setup(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*in*/  unsigned char		*adminPin,
	/*in*/  unsigned long int	adminPinLength,
	/*in*/  unsigned char		*clientIdPin,
	/*in*/  unsigned long int	clientIdPinLength,
	/*in*/  unsigned char		*puk,
	/*in*/  unsigned long int	pukLength);

EPSON_TSE_API short int RunTSESelfTest(
	/*in*/  EPSON_TSE_HANDLE	tseHandle);

EPSON_TSE_API short int FactoryReset(
	/*in*/  EPSON_TSE_HANDLE	tseHandle);

EPSON_TSE_API short int GetRawStorageInfo(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*out*/ unsigned char		**rawTseInfo,
	/*out*/ unsigned long int	*rawTseInfoLength);

EPSON_TSE_API short int GetStorageInfo(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*out*/ EPSON_TSE_INFO		*tseInfo);

EPSON_TSE_API short int GetRawStorageSmartInfo(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*out*/ unsigned char		**rawSmartInfo,
	/*out*/ unsigned long int	*rawSmartInfoLength);

EPSON_TSE_API short int GetStorageSmartInfo(
	/*in*/  EPSON_TSE_HANDLE		tseHandle,
	/*out*/ EPSON_TSE_SMART_INFO	*smartInfo);

EPSON_TSE_API short int GetStartedTransactionList(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*in*/  unsigned char		*clientId,
	/*in*/  unsigned long int	clientIdLength,
	/*out*/ unsigned long int	**startedTransactionList,
	/*out*/ unsigned long int	*startedTransactionListSize);

EPSON_TSE_API short int GetLastTransactionResponse(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*in*/  unsigned char		*clientId,
	/*in*/  unsigned long int	clientIdLength,
	/*out*/ unsigned long int	*transactionNumber,
	/*out*/ unsigned long int	*logTime,
	/*out*/ unsigned long int	*signatureCounter,
	/*out*/ unsigned char		**signatureValue,
	/*out*/ unsigned long int	*signatureValueLength,
	/*out*/ unsigned char		**serialNumber,
	/*out*/ unsigned long int	*serialNumberLength);

EPSON_TSE_API short int GetMaxNumberOfClients(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*out*/ unsigned long int	*maxNumberClients);

EPSON_TSE_API short int GetCurrentNumberOfClients(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*out*/ unsigned long int	*currentNumberClients);

EPSON_TSE_API short int GetMaxNumberOfTransactions(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*out*/ unsigned long int	*maxNumberTransactions);

EPSON_TSE_API short int GetCurrentNumberOfTransactions(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*out*/ unsigned long int	*currentNumberTransactions);

EPSON_TSE_API short int ExportCertificate(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*out*/ unsigned char		**certificate,
	/*out*/ unsigned long int	*certificateLength);

EPSON_TSE_API short int ExportSerialNumber(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*out*/ unsigned char		**serialNumber,
	/*out*/ unsigned long int	*serialNumberLength);

EPSON_TSE_API short int AuthenticateUser(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*in*/  unsigned char		*userId,
	/*in*/  unsigned long int	userIdLength,
	/*in*/  unsigned char		*pin,
	/*in*/  unsigned long int	pinLength,
	/*in*/  unsigned char		*secretKey,
	/*in*/  unsigned long int	secretKeyLength,
	/*out*/ short int			*remainingRetries);

EPSON_TSE_API short int LogOut(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*in*/  unsigned char		*userId,
	/*in*/  unsigned long int	userIdLength);

EPSON_TSE_API short int ChangePin(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*in*/  unsigned char		*userId,
	/*in*/  unsigned long int	userIdLength,
	/*in*/  unsigned char		*oldPin,
	/*in*/  unsigned long int	oldPinLength,
	/*in*/  unsigned char		*newPin,
	/*in*/  unsigned long int	newPinLength,
	/*out*/ short int			*remainingRetries);

EPSON_TSE_API short int UpdateTime(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*in*/  unsigned char		*userId,
	/*in*/  unsigned long int	userIdLength,
	/*in*/  unsigned long int	newDateTime,
	/*in*/  bool				updateForFirstTime);

EPSON_TSE_API short int DisableSecureElement(
	/*in*/  EPSON_TSE_HANDLE	tseHandle);

EPSON_TSE_API short int RegisterTSEToHost(
	/*in*/  EPSON_TSE_HANDLE	tseHandle);

EPSON_TSE_API short int RegisterSecretKey(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*in*/  unsigned char		*secretKey,
	/*in*/  unsigned long int	secretKeyLength);

EPSON_TSE_API short int RegisterClient(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*in*/  unsigned char		*newClientId,
	/*in*/  unsigned long int	newClientIdLength);

EPSON_TSE_API short int DeregisterClient(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*in*/  unsigned char		*clientId,
	/*in*/  unsigned long int	clientIdLength);

EPSON_TSE_API short int LockTse(
	/*in*/  EPSON_TSE_HANDLE	tseHandle);

EPSON_TSE_API short int UnlockTse(
	/*in*/  EPSON_TSE_HANDLE	tseHandle);

EPSON_TSE_API short int EnableExportIfCspTestFails(
	/*in*/  EPSON_TSE_HANDLE	tseHandle);

EPSON_TSE_API short int DisableExportIfCspTestFails(
	/*in*/  EPSON_TSE_HANDLE	tseHandle);

EPSON_TSE_API short int SetTimeOutInterval(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*in*/  unsigned long int	timeoutIntervalForAdmin,
	/*in*/  unsigned long int	timeoutIntervalForTimeAdmin,
	/*in*/  unsigned long int	timeoutIntervalForExport);

EPSON_TSE_API short int GetTimeOutInterval(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*out*/ unsigned long int	*timeoutIntervalForAdmin,
	/*out*/ unsigned long int	*timeoutIntervalForTimeAdmin,
	/*out*/ unsigned long int	*timeoutIntervalForExport);

EPSON_TSE_API short int GetAuthenticatedUserList(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*in*/  unsigned char		*userRole,
	/*in*/  unsigned long int	userRoleLength,
	/*out*/ unsigned char		**AuthenticatedUserList,
	/*out*/ unsigned long int	*AuthenticatedUserListLength);

EPSON_TSE_API short int GetRegisteredClientList(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*out*/ unsigned char		**registeredClientList,
	/*out*/ unsigned long int	*registeredClientListLength);

EPSON_TSE_API short int StartTransaction(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*in*/  unsigned char		*clientId,
	/*in*/  unsigned long int	clientIdLength,
	/*in*/  unsigned char		*processData,
	/*in*/  unsigned long int	processDataLength,
	/*in*/  unsigned char		*processType,
	/*in*/  unsigned long int	processTypeLength,
	/*in*/  unsigned char		*additionalData,
	/*in*/  unsigned long int	additionalDataLength,
	/*out*/ unsigned long int	*transactionNumber,
	/*out*/ unsigned long int	*logTime,
	/*out*/ unsigned char		**serialNumber,
	/*out*/ unsigned long int	*serialNumberLength,
	/*out*/ unsigned long int	*signatureCounter,
	/*out*/ unsigned char		**signatureValue,
	/*out*/ unsigned long int	*signatureValueLength);

EPSON_TSE_API short int UpdateTransaction(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*in*/  unsigned char		*clientId,
	/*in*/  unsigned long int	clientIdLength,
	/*in*/  unsigned long int	transactionNumber,
	/*in*/  unsigned char		*processData,
	/*in*/  unsigned long int	processDataLength,
	/*in*/  unsigned char		*processType,
	/*in*/  unsigned long int	processTypeLength,
	/*out*/ unsigned long int	*logTime,
	/*out*/ unsigned char		**signatureValue,
	/*out*/ unsigned long int	*signatureValueLength,
	/*out*/ unsigned long int	*signatureCounter);

EPSON_TSE_API short int FinishTransaction(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*in*/  unsigned char		*clientId,
	/*in*/  unsigned long int	clientIdLength,
	/*in*/  unsigned long int	transactionNumber,
	/*in*/  unsigned char		*processData,
	/*in*/  unsigned long int	processDataLength,
	/*in*/  unsigned char		*processType,
	/*in*/  unsigned long int	processTypeLength,
	/*in*/  unsigned char		*additionalData,
	/*in*/  unsigned long int	additionalDataLength,
	/*out*/ unsigned long int	*logTime,
	/*out*/ unsigned char		**signatureValue,
	/*out*/ unsigned long int	*signatureValueLength,
	/*out*/ unsigned long int	*signatureCounter);

EPSON_TSE_API short int ExportDataFilteredByTransactionNumberAndClientId(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*in*/  unsigned long int	transactionNumber,
	/*in*/  unsigned char		*clientId,
	/*in*/  unsigned long int	clientIdLength,
	/*out*/ unsigned char		**exportedData,
	/*out*/ unsigned long int	*exportedDataLength);

EPSON_TSE_API short int ExportDataFilteredByTransactionNumber(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*in*/  unsigned long int	transactionNumber,
	/*out*/ unsigned char		**exportedData,
	/*out*/ unsigned long int	*exportedDataLength);

EPSON_TSE_API short int ExportDataFilteredByTransactionNumberIntervalAndClientId(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*in*/  unsigned long int	startTransactionNumber,
	/*in*/  unsigned long int	endTransactionNumber,
	/*in*/  unsigned char		*clientId,
	/*in*/  unsigned long int	clientIdLength,
	/*out*/ unsigned char		**exportedData,
	/*out*/ unsigned long int	*exportedDataLength);

EPSON_TSE_API short int ExportDataFilteredByTransactionNumberInterval(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*in*/  unsigned long int	startTransactionNumber,
	/*in*/  unsigned long int	endTransactionNumber,
	/*out*/ unsigned char		**exportedData,
	/*out*/ unsigned long int	*exportedDataLength);

EPSON_TSE_API short int ExportDataFilteredByPeriodOfTimeAndClientId(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*in*/  unsigned long int	startDate,
	/*in*/  unsigned long int	endDate,
	/*in*/  unsigned char		*clientId,
	/*in*/  unsigned long int	clientIdLength,
	/*out*/ unsigned char		**exportedData,
	/*out*/ unsigned long int	*exportedDataLength);

EPSON_TSE_API short int ExportDataFilteredByPeriodOfTime(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*in*/  unsigned long int	startDate,
	/*in*/  unsigned long int	endDate,
	/*out*/ unsigned char		**exportedData,
	/*out*/ unsigned long int	*exportedDataLength);

EPSON_TSE_API short int ExportData(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*out*/ unsigned char		**exportedData,
	/*out*/ unsigned long int	*exportedDataLength);

EPSON_TSE_API short int FinalizeExport(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*in*/  bool				deleteStoredData);

EPSON_TSE_API short int CancelExport(
	/*in*/  EPSON_TSE_HANDLE	tseHandle);

EPSON_TSE_API short int ChangePuk(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*in*/  unsigned char		*oldPuk,
	/*in*/  unsigned long int	oldPukLength,
	/*in*/  unsigned char		*newPuk,
	/*in*/  unsigned long int	newPukLength,
	/*in*/  unsigned char		*secretKey,
	/*in*/  unsigned long int	secretKeyLength,
	/*out*/ short int			*remainingRetries);

EPSON_TSE_API short int UnblockUser(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*in*/  unsigned char		*userId,
	/*in*/  unsigned long int	userIdLength,
	/*in*/  unsigned char		*puk,
	/*in*/  unsigned long int	pukLength,
	/*in*/  unsigned char		*newPin,
	/*in*/  unsigned long int	newPinLength,
	/*in*/  unsigned char		*secretKey,
	/*in*/  unsigned long int	secretKeyLength,
	/*out*/ short int			*remainingRetries);

EPSON_TSE_API void		TSEMemDealloc(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*out*/  void				*memoryAddress);

EPSON_TSE_API void		TSEMemDeallocTseInfoObject(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*out*/  EPSON_TSE_INFO		*tseInfo);

EPSON_TSE_API void		TSESetLog(
	/*in*/  EPSON_TSE_HANDLE	tseHandle,
	/*in*/  unsigned short int	logLevel,
	/*in*/  unsigned short int	logMethod);

EPSON_TSE_API void		TSEGetErrorDescription(
	/*in*/  short int			errorCode,
	/*in*/  short int			language,
	/*out*/ unsigned char		errorDescription[100]);

#ifdef __cplusplus
   }
#endif /*__cplusplus*/

#endif /*__EPSONTSELIBCMULTI_H__*/