// Copyright 2020 Seiko Epson Corporation.
// Epson Europe
// EEB/RDC
// 2020/12  ka
// This Application is intended for demonstration purposes only and not for production environment.

#include "stdafx.h"
#include <windows.h>
#include "TSEAccess.h"
#include "TSEUtil.h"
#include "TSELogger.h"
#include <sstream>


void TSEAccess::SetTseDeviceId(const std::string &tTseDevId) 
{
	mTseDevId = tTseDevId;
}

unsigned long TSEAccess::GetLastRcvTime() 
{
	return mTotalRcvTime;
}

unsigned long TSEAccess::GetTotalTime()
{
	return mTotalTime;
}

void TSEAccess::SendMsg(const std::vector<unsigned char>& tBuffer) 
{
	SYSTEMTIME st, et;
	union timeunion {
		FILETIME fT;
		ULARGE_INTEGER uL;
	} fst, fet;
	unsigned long timeSpent;
	std::stringstream sLogAll;

	GetSystemTime(&st);
	SystemTimeToFileTime(&st, &fst.fT);

	SendTo(tBuffer);

	GetSystemTime(&et);
	SystemTimeToFileTime(&et, &fet.fT);
	timeSpent = (unsigned long)((fet.uL.QuadPart - fst.uL.QuadPart) / 10000);
	
	sLogAll << "Bytes SENT: " << tBuffer.size() << " (time: " << timeSpent << " ms)" << std::endl;
	sLogAll << "SENT: " << mLog.MakePrintableString(tBuffer);
	TSEPRINTLOG(mLog, LIBLOG_LEVEL_VERBOSE, ("%s", sLogAll.str().c_str()));
};

void TSEAccess::RecvMsg(std::vector<unsigned char>& tBuffer, const unsigned long& tMaxSize, const unsigned long& tTimeout, unsigned long& tTimeSpent)
{
	SYSTEMTIME st, et;
	union timeunion {
		FILETIME fT;
		ULARGE_INTEGER uL;
	} fst, fet;
	std::stringstream sLogAll;

	GetSystemTime(&st);
	SystemTimeToFileTime(&st, &fst.fT);
	//sprintf_s(nowTime, "[%d-%02d-%02d] %02d:%02d:%02d:%03d", st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, st.wSecond, st.wMilliseconds);

	RecvFrom(tBuffer, tMaxSize, tTimeout);

	GetSystemTime(&et);
	SystemTimeToFileTime(&et, &fet.fT);
	tTimeSpent = (unsigned long)((fet.uL.QuadPart - fst.uL.QuadPart) / 10000);
	
	sLogAll << "Bytes RECV: " << tBuffer.size() << " (time: " << tTimeSpent << " ms)" << std::endl;
	sLogAll << "RECV: " << mLog.MakePrintableString(tBuffer);
	TSEPRINTLOG(mLog, LIBLOG_LEVEL_VERBOSE, ("%s", sLogAll.str().c_str()));
};

//EOF