// Copyright 2020 Seiko Epson Corporation.
// Epson Europe
// EEB/RDC
// 2020/12  ka
// This Application is intended for demonstration purposes only and not for production environment.

#pragma once
#include <string>
#include "TSEAccess.h"
#include "AccessBySocket.h"
#include <winsock2.h>

class TSEAccessByEposDevice:public TSEAccess
{
public:
	TSEAccessByEposDevice(const std::string& tIpAddress, TSELogger& tLog);
	~TSEAccessByEposDevice();
	bool EnableTseAccess();
	void SendJsonStringToTse(const std::string& tJsonStr, std::string& tResponse);
	bool DisableTseAccess();
private:
	AccessSocket * mASocket;
	std::string mPort;
	std::string mClientId;
	std::string mLastDataId;
	std::string mTseClibCompleteDataDir;
	void SendRecv(const std::vector<BYTE>& sendCmd, std::vector<BYTE>& recvBuffer);
	bool Reconnect(bool doreconnect);
	bool ManagePreviousConnectionStatus();
	void CreateConnectFile();
	std::string GetConnectFileName();
	bool IsXmlResponseCorrect(const char* tXmlString, const std::string& tTag);
	std::string GetValueFromXml(const char* tXmlString, const std::string& tTag);
	void SendTo(const std::vector<unsigned char>& tBuffer);
	void RecvFrom(std::vector<unsigned char>& tBuffer, const unsigned long& tMaxSize, const unsigned long& tTimeout);
};

//EOF