// Copyright 2020 Seiko Epson Corporation.
// Epson Europe
// EEB/RDC
// 2020/12  ka
// This Application is intended for demonstration purposes only and not for production environment.

#pragma once
#include <string>
#include "TSEAccess.h"
#include "AccessBySerial.h"

class TSEAccessByEscPosSerial :public TSEAccess
{
public:
	TSEAccessByEscPosSerial(const std::string& tIdentifier, TSELogger& tLog);
	~TSEAccessByEscPosSerial();
	bool EnableTseAccess();
	void SendJsonStringToTse(const std::string& tJsonStr, std::string& tResponse);
	bool DisableTseAccess();
private:
	AccessSerial * mSerial;

	void SendTo(const std::vector<unsigned char>& tBuffer);
	void RecvFrom(std::vector<BYTE>& tBuffer, const unsigned long& tMaxSize, const unsigned long& tTimeout);
};

//EOF