// Copyright 2020 Seiko Epson Corporation.
// Epson Europe
// EEB/RDC
// 2020/12  ka
// This Application is intended for demonstration purposes only and not for production environment.

#include "stdafx.h"
#include "TSEDeviceList.h"
#include "TSESimpleJsonAndXmlParser.h"
#include "TSELogger.h"
#undef USING_REGEX 
#ifdef USING_REGEX
#include <regex>
#endif /*USING_REGEX*/  

#include "AccessBySocket.h"
#include <vector>
#include <stdexcept>
#define DEFAULT_RCV_TIMEOUT		10000

void TSEGetDeviceList(const std::string& tIpAddress, std::string& tTseList, TSELogger& tLog)
{
	tTseList = "";
	if (tIpAddress == "") return;

	std::string  s_get_cmd = "GET /epson_eposdevice/getDeviceList.cgi HTTP/1.1\r\nHost: " + tIpAddress + "\r\nConnection: close\r\n\r\n";
	std::string  s_recv = "";
	std::vector<unsigned char> v_send(s_get_cmd.begin(), s_get_cmd.end());
	std::vector<unsigned char> v_recv;
	
	try
	{
		AccessSocket ac_socket(tIpAddress.c_str(), "80", false, tLog);
		ac_socket.SocketSend(v_send);
		ac_socket.SocketRecv(v_recv, 65535, DEFAULT_RCV_TIMEOUT);
	}
	catch (...)
	{
		TSEPRINTLOG(tLog, LIBLOG_LEVEL_ERROR, ("Connection error."));
		throw std::runtime_error("Connection error.");
	}

	for (std::vector<unsigned char>::iterator iter = v_recv.begin(); iter != v_recv.end(); ++iter)
	{
		if  (*iter >= 32 || *iter == '\n' || *iter == '\r')
		{
			s_recv += *iter;
		}
	}

	std::string strStart("[{");
	std::string strEnd("}]");

	std::size_t found1 = s_recv.find(strStart);
	std::size_t found2 = s_recv.find(strEnd);
	if ((found1 == std::string::npos) || (found2 == std::string::npos))
	{
		TSEPRINTLOG(tLog, LIBLOG_LEVEL_WARNING, ("Data not found."));
		return;
	}

	std::string str2 = s_recv.substr(found1 + 1, found2 - 1);
#ifndef USING_REGEX
	if (str2 == "")
	{
		return;
	}

	size_t start = 0, it = 0;
	int openp = 0;
	for (it = 0; it < str2.size(); it++)
	{
		if (it == 0)
		{
			if (str2.at(it) == '{')
			{
				start = it;
				openp++;
			}
		}
		else
		{
			if (str2.at(it - 1) == '\\')
			{
				continue;
			}

			if (str2.at(it) == '{')
			{
				start = it;
				openp++;
			}

			else if (str2.at(it) == '}')
			{
				openp--;
				if (openp == 0)
				{
					std::string match = str2.substr(start, (it - start) + 1);

					if ((TseSimpleJsonAndXmlParser::JsonGetValue(match, "deviceType") == "type_storage") &&
						(TseSimpleJsonAndXmlParser::JsonGetValue(match, "connection") == "connected"))
					{
						if (tTseList == "")
						{
							tTseList = "\"" + TseSimpleJsonAndXmlParser::JsonGetValue(match, "deviceId") + "\"";
						}
						else
						{
							tTseList = tTseList + ",\"" + TseSimpleJsonAndXmlParser::JsonGetValue(match, "deviceId") + "\"";
						}
					}
				}
			}
		} //(it != 0)
	}//for
#else /*USING_REGEX*/
	try
	{
		std::regex re("\\{[\\s\\S]*?\\}");
		std::sregex_iterator next(str2.begin(), str2.end(), re);
		std::sregex_iterator end;
		while (next != end)
		{
			std::smatch match = *next;

			if ((TseSimpleJsonAndXmlParser::JsonGetValue(match.str(), "deviceType") == "type_storage") &&
				(TseSimpleJsonAndXmlParser::JsonGetValue(match.str(), "connection") == "connected"))
			{
				if (tTseList == "")
				{
					tTseList = "\"" + TseSimpleJsonAndXmlParser::JsonGetValue(match.str(), "deviceId") + "\"";
				}
				else
				{
					tTseList = tTseList + ",\"" + TseSimpleJsonAndXmlParser::JsonGetValue(match.str(), "deviceId") + "\"";
				}
			}
			next++;
		}
	}
	catch (std::regex_error& e)
	{
		TSEPRINTLOG(LIBLOG_LEVEL_ERROR, ("Error in parsing (%s).", e.what()));
		throw std::runtime_error("Error in parsing.");
	}
#endif /*USING_REGEX*/

	return;
}

//EOF