// Copyright 2019-2020 Seiko Epson Corporation.
// Epson Europe
// EEB/RDC
// 2020/12  ka
// This Application is intended for demonstration purposes only and not for production environment.

#pragma once
#include "TSEAccess.h"
#include "TSEOptions.h"
#include "TSELogger.h"
#include <string>

class TSEOperate
{
public:
	explicit TSEOperate(const TSEOptions& tTseOpt);
	~TSEOperate();
	unsigned long GetTotalTime();
	unsigned long GetLastRcvTime();
	TSELogger& GetLoggerIntance();

	void TSEOpenDevice();
	void TSECloseDevice();

	std::string GetChallenge(
		const std::string& tUserId,
		std::string& tChallenge);

	std::string AuthenticateUserForAdmin(
		const std::string& tUserId,
		const std::string& tPin,
		const std::string& tHash,
		std::string& tRemainingRetries);

	std::string AuthenticateUserForTimeAdmin(
		const std::string& tClientId,
		const std::string& tPin,
		const std::string& tHash,
		std::string& tRemainingRetries);

	std::string AuthenticateHost(
		const std::string& tUserId,
		const std::string& tHash);

	std::string LogOutForAdmin();

	std::string LogOutForTimeAdmin(
		const std::string& tClientId);

	std::string DeauthenticateHost(
		const std::string& tUserId);

	std::string UpdateTimeForFirst(
		const std::string& tClientId,
		const std::string& tNewTime,
		const std::string& tUseTimeSync);

	std::string UpdateTime(
		const std::string& tClientId,
		const std::string& tNewTime,
		const std::string& tUseTimeSync);

	std::string StartTransaction(
		const std::string& tClientId,
		const std::string& tProcessData,
		const std::string& tProcessType,
		const std::string& tAdditionalData,
		std::string& tTrxNo,
		std::string& tLogTime,
		std::string& tSerialNo,
		std::string& tSignatureCtr,
		std::string& tSignature);

	std::string GetTimeOutInterval(
		std::string& tAdmin,
		std::string& tTimeAdmin,
		std::string& tExport);

	std::string UpdateTransaction(
		const std::string& tClientId,
		const std::string& tTrxNo,
		const std::string& tProcessData,
		const std::string& tProcessType,
		std::string& tLogTime,
		std::string& tSignatureCtr,
		std::string& tSignature);

	std::string FinishTransaction(
		const std::string& tClientId,
		const std::string& tTrxNo,
		const std::string& tProcessData,
		const std::string& tProcessType,
		const std::string& tAdditionalData,
		std::string& tLogTime,
		std::string& tSignatureCtr,
		std::string& tSignature);

	std::string ExportFilteredByTransactionNumber(
		const std::string& tUserId,
		const std::string& tTrxNo);

	std::string ExportFilteredByTransactionNumberInterval(
		const std::string& tUserId,
		const std::string& tStartTrxNo,
		const std::string& tEndTrxNo);

	std::string ExportFilteredByPeriodOfTime(
		const std::string& tUserId,
		const std::string& tStartDateTime,
		const std::string& tEndDateTime);

	std::string ArchiveExport(
		std::string& tTarSize);

	std::string GetExportData(
		std::string& tExportData,
		std::string& tExportStatus);

	std::string FinalizeExport(
		const std::string& tDeleteData);

	std::string CancelExport();

	std::string Setup(
		const std::string& tPuk,
		const std::string& tAdmPin,
		const std::string& tTimeAdmPin);

	std::string RegisterSecretKey(
		const std::string& tNewSecretKey);

	std::string DisableSecureElement();

	std::string UnblockUserForAdmin(
		const std::string& tUserId,
		const std::string& tPuk,
		const std::string& tNewPin,
		std::string& tRemainingRetries);

	std::string UnblockUserForTimeAdmin(
		const std::string& tUserId,
		const std::string& tPuk,
		const std::string& tPin,
		std::string& tRemainingRetries);

	std::string ChangePuk(
		const std::string& tUserId,
		const std::string& tOldPuk,
		const std::string& tNewPuk,
		std::string& tRemainingRetries
	);

	std::string ChangePinForAdmin(
		const std::string& tUserId,
		const std::string& tOldPin,
		const std::string& tNewPin,
		std::string& tRemainingRetries
	);

	std::string ChangePinForTimeAdmin(
		const std::string& tClientId,
		const std::string& tOldPin,
		const std::string& tNewPin,
		std::string& tRemainingRetries
	);

	std::string RegisterClient(
		const std::string& tNewClientId);

	std::string DeregisterClient(
		const std::string& tClientId);
	
	std::string UnlockTSE();

	std::string LockTSE();

	std::string GetAuthenticatedUserList(
		const std::string& tUserRole,
		std::string & tAuthenticatedUserList);

	std::string GetLogMessageCertificate(
			std::string & tLogMsgCertificate);

	std::string GetLastTransactionResponse(
		const std::string& tClientId,
		std::string& tTrxNo,
		std::string& tLogTime,
		std::string& tSignatureCtr,
		std::string& tSignature,
		std::string& tSerialNo);

	std::string GetStartedTransactionList(
		const std::string& tClientId,
		std::string& tStartedTrList);

	std::string GetRegisteredClientList(
		std::string& tRegisteredClientList);

	std::string GetStorageInfo(
		std::string& tTseInfo);

	std::string GetStorageSmartInfo(
		std::string& tSmartInfo);
	
	std::string SetTimeOutInterval(			
		const std::string& tAdmin,		
		const std::string& tTimeAdmin,									
		const std::string& tExport);

	std::string SetUpForPrinter();

	std::string RunTSESelfTest();

	std::string DisableExportIfCspTestFails();

	std::string EnableExportIfCspTestFails();

	std::string FactoryReset();

	std::string GetOperateHostId();
	std::string GetOperateTseId();

private:
	TSEAccess * mTseAcs;
	TSELogger * mLog;

	std::string mJsonHeader;
	std::string mJsonFooter;
	unsigned short mConMethod;
	std::string mTseVendor;
	bool mIsTseDeviceOpen;
	std::string GetJsonObj(const std::string& tJsonStr, const std::string& tObj);
	std::string GetValueFromJsonKey(const std::string& tJsonStr, const std::string& tKey, int tValType);

	std::string mHostId;
	std::string mTseId;

};
