// Copyright 2020 Seiko Epson Corporation.
// Epson Europe
// EEB/RDC
// 2020/12  ka
// This Application is intended for demonstration purposes only and not for production environment.

#include "stdafx.h"
#undef USING_REGEX 
#ifdef USING_REGEX
#include <regex>
#endif /*USING_REGEX*/  
#include "TSELogger.h"
#include "TSESimpleJsonAndXmlParser.h"

std::string TseSimpleJsonAndXmlParser::JsonGetObject(const std::string& tJsonStr, const std::string& tObj)
{
#ifndef USING_REGEX
	size_t index, start, it;
	std::string obj = "";
	index = tJsonStr.find(tObj);
	if (index == std::string::npos)
	{
		return "";
	}

	index = tObj.size() + index + 1;
	if (tJsonStr.at(index) != ':')
	{
		return "";
	}
	index++;

	if (tJsonStr.at(index) != '{')
	{
		return "";
	}

	start = index;

	int openp = 0;
	for (it = index + 1; it < tJsonStr.size(); it++)
	{
		if (tJsonStr.at(it - 1) == '\\')
		{
			continue;
		}

		if (tJsonStr.at(it) == '{')
		{
			openp++;
		}
		else if (tJsonStr.at(it) == '}')
		{
			openp--;
			if (openp == -1)
			{
				break;
			}
		}
	}
	obj = tJsonStr.substr(start, (it - start) + 1);
	return obj;
#else /*USING_REGEX*/
	// for some reason, std::regex fails when tJsonStr is too long
	try
	{
		std::string result;

		//std::string regstr("\"" + tObj + "\":\\{[\\s\\S]*?\\}[\\},]");
		std::string regstr("\"" + tObj + "\":\\{(\"[^\"]*\":\\{[^\\}]*\\},?|\"[^\"]*\":[^\"^\\}]*,?|\"[^\"]*\":\"[^\"]*\",?)*\\}");
		std::regex re(regstr);

		std::smatch match;
		if (std::regex_search(tJsonStr, match, re))
		{
			//re = ("\\{[\\s\\S]*?\\}[\\},]");
			re = ("\\{(\"[^\"]*\":\\{[^\\}]*\\},?|\"[^\"]*\":[^\"^\\}]*,?|\"[^\"]*\":\"[^\"]*\",?)*\\}");
			std::string mat = match.str(0);
			std::smatch m2;
			std::regex_search(mat, m2, re);
			result = m2.str(0).substr(0, m2.str(0).length());

			return result;
		}
	}
	catch (std::regex_error&)
	{
		TSEPRINTLOG(LIBLOG_LEVEL_ERROR, ("Regex error"));
		throw std::runtime_error("");
	}
#endif /*USING_REGEX*/

	return "";
}

std::string TseSimpleJsonAndXmlParser::JsonGetArray(const std::string& tJsonStr, const std::string& tKey)
{
#ifndef USING_REGEX
	size_t index, start, it;
	std::string obj = "";
	index = tJsonStr.find(tKey);
	if (index == std::string::npos)
	{
		return "";
	}

	index = tKey.size() + index + 1;
	if (tJsonStr.at(index) != ':')
	{
		return "";
	}
	index++;

	if (tJsonStr.at(index) != '[')
	{
		return "";
	}

	start = index;

	int openp = 0;
	for (it = index + 1; it < tJsonStr.size(); it++)
	{
		if (tJsonStr.at(it - 1) == '\\')
		{
			continue;
		}

		if (tJsonStr.at(it) == '[')
		{
			openp++;
		}
		else if (tJsonStr.at(it) == ']')
		{
			openp--;
			if (openp == -1)
			{
				break;
			}
		}
	}
	obj = tJsonStr.substr(start + 1, (it - start) - 1);
	return obj;

#else /*USING_REGEX*/
	try
	{
		std::string result;
		std::string regstr("\"" + tKey + "\":\\[[\\s\\S]*?\\]");
		std::regex re(regstr);

		std::smatch match;
		if (std::regex_search(tJsonStr, match, re))
		{
			re = (":\\[[\\s\\S]*?\\]");
			std::string mat = match.str(0);
			std::smatch m2;
			std::regex_search(mat, m2, re);
			result = m2.str(0).substr(2, m2.str(0).length() - 3);
			return result;
		}
	}
	catch (std::regex_error&)
	{
		TSEPRINTLOG(LIBLOG_LEVEL_ERROR, ("Regex error"));
		throw std::runtime_error("");
	}
	return "";
#endif /*USING_REGEX*/
}

std::string TseSimpleJsonAndXmlParser::JsonGetValue(const std::string& tJsonStr, const std::string& tKey)
{
#ifndef USING_REGEX
	size_t index, start, it;
	std::string obj = "";
	index = tJsonStr.find(tKey);
	if (index == std::string::npos)
	{
		return "";
	}

	index = tKey.size() + index + 1;
	if (tJsonStr.at(index) != ':')
	{
		return "";
	}
	index++;

	if (tJsonStr.at(index) != '"')
	{
		return "";
	}

	start = index;

	for (it = index + 1; it < tJsonStr.size(); it++)
	{
		if ((tJsonStr.at(it) == '"') && (tJsonStr.at(it-1) != '\\'))
		{
			break;
		}

	}
	obj = tJsonStr.substr(start + 1, (it - start) - 1);
	return obj;
#else /*USING_REGEX*/
	try
	{
		std::string result;
		std::string regstr("\"" + tKey + "\":\"[\\s\\S]*?\"");
		std::regex re(regstr);

		std::smatch match;
		if (std::regex_search(tJsonStr, match, re))
		{
			re = (":\"[\\s\\S]*?\"");
			std::string mat = match.str(0);
			std::smatch m2;
			std::regex_search(mat, m2, re);
			result = m2.str(0).substr(2, m2.str(0).length() - 3);
			return result;

		}
	}
	catch (std::regex_error&)
	{
		TSEPRINTLOG(LIBLOG_LEVEL_ERROR, ("Regex error"));
		throw std::runtime_error("");
	}
	return "";
#endif /*USING_REGEX*/
}

std::string TseSimpleJsonAndXmlParser::JsonGetNonStringValue(const std::string& tJsonStr, const std::string& tKey)
{
#ifndef USING_REGEX
	size_t index, start, it;
	std::string obj = "";
	index = tJsonStr.find(tKey);
	if (index == std::string::npos)
	{
		return "";
	}

	index = tKey.size() + index + 1;
	if (tJsonStr.at(index) != ':')
	{
		return "";
	}

	start = index;

	for (it = index + 1; it < tJsonStr.size(); it++)
	{
		if (tJsonStr.at(it - 1) == '\\')
		{
			continue;
		}

		if ((tJsonStr.at(it) == ',') || (tJsonStr.at(it) == '}'))
		{
			break;

		}
	}
	obj = tJsonStr.substr(start + 1, (it - start) - 1);
	return obj;
#else /*USING_REGEX*/
	try 
	{
		std::string result;
		std::string regstr("\"" + tKey + "\":[\\s\\S]*?[,}]");
		std::regex re(regstr);

		std::smatch match;
		if (std::regex_search(tJsonStr, match, re))
		{
			re = (":[\\s\\S]*?[,}]");
			std::string mat = match.str(0);
			std::smatch m2;
			std::regex_search(mat, m2, re);
			result = m2.str(0).substr(1, m2.str(0).length() - 2);
			return result;

		}
	}
	catch (std::regex_error&)
	{
		TSEPRINTLOG(LIBLOG_LEVEL_ERROR, ("Regex error"));
		throw std::runtime_error("");
	}
	return "";
#endif /*USING_REGEX*/
}


std::string TseSimpleJsonAndXmlParser::XmlGetValue(const std::string& tXmlString, const std::string& tTag)
{
	std::string xmlStr = tXmlString;
	xmlStr.erase(std::remove(xmlStr.begin(), xmlStr.end(), '\r'), xmlStr.end() );
	xmlStr.erase(std::remove(xmlStr.begin(), xmlStr.end(), '\n'), xmlStr.end() );
#ifndef USING_REGEX
	size_t start, end;
	std::string obj = "";
	start = xmlStr.find("<"+tTag+">");
	if (start == std::string::npos)
	{
		return "";
	}

	end = xmlStr.find("</" + tTag + ">");
	if (end == std::string::npos)
	{
		return "";
	}

	if (end < start)
	{
		return "";
	}

	obj = xmlStr.substr(start + tTag.size() + 2, end - (start + tTag.size() + 2));

	return obj;
#else /*USING_REGEX*/
	try
	{
		std::string regstr = "\\s*<" + tTag + ">[\\s\\S]*?</" + tTag + ">\\s*";
		std::regex re(regstr);

		std::smatch match;
		if (std::regex_search(xmlStr, match, re))
		{
			re = (">[\\s\\S]*?<");
			std::string mat = match.str(0);
			std::smatch m2;
			std::regex_search(mat, m2, re);
			return m2.str(0).substr(1, m2.str(0).length() - 2);
		}
	}
	catch (std::regex_error&)
	{
		TSEPRINTLOG(LIBLOG_LEVEL_ERROR, ("Regex error"));
		throw std::runtime_error("");
	}
	return "";
#endif /*USING_REGEX*/
}

bool TseSimpleJsonAndXmlParser::XmlIsResponseCorrect(const std::string& tXmlString, const std::string& tTag)
{
	std::string xmlStr = tXmlString;
	xmlStr.erase(std::remove(xmlStr.begin(), xmlStr.end(), '\r'), xmlStr.end());
	xmlStr.erase(std::remove(xmlStr.begin(), xmlStr.end(), '\n'), xmlStr.end());
#ifndef USING_REGEX
	size_t start, end;
	start = xmlStr.find("<"+tTag+">");
	if (start == std::string::npos)
	{
		return false;
	}

	end = xmlStr.find("</" + tTag + ">");
	if (end == std::string::npos)
	{
		return false;
	}

	if (end < start)
	{
		return false;
	}

	return true;
#else /*USING_REGEX*/
	try
	{
		std::string regstr = "\\s*<" + tTag + ">[\\s\\S]*?</" + tTag + ">\\s*";
		std::regex re(regstr);

		return std::regex_match(xmlStr, re);
	}
	catch (std::regex_error&)
	{
		TSEPRINTLOG(LIBLOG_LEVEL_ERROR, ("Regex error"));
		throw std::runtime_error("");
	}
	return false;
#endif /*USING_REGEX*/
}

//EOF