// Copyright 2020-2021 Seiko Epson Corporation.
// Epson Europe
// EEB/RDC
// 2021/05  ka
// This Application is intended for demonstration purposes only and not for production environment.

#pragma once

#include "../Include/EpsonTseLibStatusCodes.h"
#include <map>
#include <string>

static const std::map<short int, std::string> gErrDescEN =
{
	{ EXECUTION_OK, "Execution has successfully completed." },
	{ JSON_ERROR_NOT_ENOUGH_CONTENTS, "Inadequate JSON message contents (missing parameter, etc.)." },
	{ JSON_ERROR_UNEXPECTED_PARAM_TYPE, "Incorrect JSON message parameter data type." },
	{ JSON_ERROR_OVER_DATA_SIZE, "JSON message size exceeds the maximum value supported (64 KB)." },
	{ JSON_ERROR_INVALID_PARAMETER_RANGE, "JSON message parameters are outside their valid range." },
	{ JSON_ERROR_INVALID_PARAMETER, "Invalid parameter." },
	{ JSON_ERROR_INVALID_TIME_FORMAT, "Invalid (not supported) timestamp format for a specified JSON message parameter." },
	{ JSON_ERROR_UNEXPECTED_STORAGE_TYPE, "Unexpected (not supported) \"storage\" \"type\" specified by a JSON message parameter." },
	{ JSON_ERROR_UNEXPECTED_STORAGE_VENDOR, "Unexpected (not supported) \"storage\" \"vendor\" specified by a JSON message parameter." },
	{ JSON_ERROR_UNEXPECTED_FUNCTION, "Unexpected \"function\" specified by a JSON message parameter." },
	{ JSON_ERROR_UNEXPECTED_COMPRESSION_TYPE, "Unexpected (not supported) \"compress\" \"type\" specified by a JSON message parameter." },
	{ JSON_ERROR_WRONG_JSON_FORMAT, "JSON message is not in JSON format." },
	{ OTHER_ERROR_UNKNOWN_STORAGE, "Inserted storage is not a supported TSE." },
	{ OTHER_ERROR_NO_STORAGE_FOUND, "No valid storage is inserted." },
	{ OTHER_ERROR_UPDATE_SYSTIME_FAIL, "Failed to update the printer time." },
	{ OTHER_ERROR_INVALID_ADMIN_USER_ID, "A user ID with Admin privileges besides \"Administrator\" was specified." },
	{ OTHER_ERROR_HOST_AUTHENTICATION_FAILED, "Failed to authenticate the host. Incorrect hash value." },
	{ OTHER_ERROR_UNAUTHENTICATED_TIME_ADMIN_USER, "A request was received from an unauthenticated (not logged-in) user with TimeAdmin privileges." },
	{ OTHER_ERROR_UNAUTHENTICATED_ADMIN_USER, "A request was received from an unauthenticated (not logged-in) user with Admin privileges." },
	{ OTHER_ERROR_UNAUTHENTICATED_USER, "A request was received from a user not authenticated with Admin or TimeAdmin privileges." },
	{ OTHER_ERROR_UNAUTHENTICATED_HOST, "A request was received from an unauthenticated (not logged-in) host." },
	{ OTHER_ERROR_CURRENTLY_EXPORTING, "Another request was received while in export status." },
	{ OTHER_ERROR_NO_EXPORT_STARTED, "A request was received that can only be executed in export status while not in export status."},
	{ OTHER_ERROR_CURRENTLY_EXPORTING_USER, "The user ID who is currently exporting has logged out."},
	{ OTHER_ERROR_NO_TIME_SET_BEFORE_EXPORT, "TSE time was not updated before starting the export." },
	{ OTHER_ERROR_ALREADY_ALL_DATA_EXPORTED, "An export data acquisition request was received when all export data had been acquired." },
	{ OTHER_ERROR_ALL_DATA_NOT_EXPORTED_YET, "An export end request was received when all export data had not been acquired." },
	{ OTHER_ERROR_TSE_ALREADY_SET_UP, "Another set-up request was received for a TSE that is already set-up." },
	{ OTHER_ERROR_SECRETKEY_REGISTRATION_FAILED, "Failed to register the secret key." },
	{ OTHER_ERROR_PARAMETER_MISMATCH, "Incorrect parameters entered to specify the export range." },
	{ OTHER_ERROR_TOO_MANY_TIME_ADMIN_USER_LOGGED_IN, "The number of users (clients) logged in with TimeAdmin privileges exceeds the upper limit." },
	{ OTHER_ERROR_TOO_MANY_CHALLENGE_REQUESTED, "The number of users requesting the challenge exceeds the upper limit." },
	{ OTHER_ERROR_NO_MEMORY, "Memory overflow error. This does not normally occur." },
	{ OTHER_ERROR_FATAL, "Fatal error due to an unexpected event (mainly at the TSE side)." },
	{ OTHER_ERROR_CANNOT_GET_TSE_LIST, "Cannot retrieve list of TSE devices." },
	{ TSE1_ERROR_INVALID_PARAMETER, "Invalid input parameter." },
	{ TSE1_ERROR_NO_TSE, "No TSE was found at the provided path." },
	{ TSE1_ERROR_IO, "No TSE detected (inserted) when a command request arrived." },
	{ TSE1_ERROR_TIMEOUT, "The operation timed out." },
	{ TSE1_ERROR_OUTOFMEM, "A location was accessed that is outside the memory." },
	{ TSE1_ERROR_INVALID_RESPONSE, "No correct response from the TSE." },
	{ TSE1_ERROR_STORE_FULL_INTERNAL, "TSE is internally full." },
	{ TSE1_ERROR_RESPONSE_MISSING, "Two commands are sent at the same time or a command is not allowed in the current state." },
	{ TSE1_ERROR_EXPORT_NOT_INITIALIZED, "TSE Store not initialized." },
	{ TSE1_ERROR_EXPORT_FAILED, "Export Failed." },
	{ TSE1_ERROR_POWER_CYCLE_DETECTED, "A power cycle occurred during command execution." },
	{ TSE1_ERROR_FIRMWARE_UPDATE_NOT_APPLIED, "The firmware update was not properly applied." },
	{ TSE1_ERROR_FROM_TSE_FIRST, "Lowest error code that might be raised from the TSE." },
	{ TSE1_ERROR_UNKNOWN, "Unspecified, internal processing error." },
	{ TSE1_ERROR_NO_TIME_SET, "Time not set." },
	{ TSE1_ERROR_NO_TRANSACTION_IN_PROGRESS, "No transaction in progress." },
	{ TSE1_ERROR_INVALID_CMD_SYNTAX, "Wrong command length." },
	{ TSE1_ERROR_NOT_ENOUGH_DATA_WRITTEN, "Not enough data written during transaction." },
	{ TSE1_ERROR_TSE_INVALID_PARAMETER, "Invalid Parameter." },
	{ TSE1_ERROR_TRANSACTION_NOT_STARTED, "Given transaction is not started." },
	{ TSE1_ERROR_MAX_PARALLEL_TRANSACTIONS, "Maximum parallel transactions reached." },
	{ TSE1_ERROR_CERTIFICATE_EXPIRED, "Certificate expired." },
	{ TSE1_ERROR_NO_LAST_TRANSACTION, "No last transaction to fetch." },
	{ TSE1_ERROR_CMD_NOT_ALLOWED, "Command not allowed in current state." },
	{ TSE1_ERROR_TRANSACTION_SIGNATURES_EXCEEDED, "Signatures exceeded." },
	{ TSE1_ERROR_NOT_AUTHORIZED, "Not authorized." },
	{ TSE1_ERROR_MAX_REGISTERED_CLIENTS_REACHED, "Maximum registered clients reached." },
	{ TSE1_ERROR_CLIENT_NOT_REGISTERED, "Client not registered." },
	{ TSE1_ERROR_EXPORT_UNACKNOWLEDGED_DATA, "Failed to delete, data not completely exported." },
	{ TSE1_ERROR_CLIENT_HAS_UNFINISHED_TRANSACTIONS, "Failed to deregister, client has unfinished transactions." },
	{ TSE1_ERROR_TSE_HAS_UNFINISHED_TRANSACTIONS, "Failed to decommission, TSE has unfinished transactions." },
	{ TSE1_ERROR_TSE_NO_RESPONSE_TO_FETCH, "Wrong state, there is no response to fetch." },
	{ TSE1_ERROR_NOT_ALLOWED_EXPORT_IN_PROGRESS, "Wrong state, ongoing Filtered Export must be finished before this command is allowed." },
	{ TSE1_ERROR_STORE_FULL, "Operation failed, not enough remaining capacity in TSE Store." },
	{ TSE1_ERROR_WRONG_STATE_NEEDS_PUK_CHANGE, "Wrong state, changed PUK required." },
	{ TSE1_ERROR_WRONG_STATE_NEEDS_PIN_CHANGE, "Wrong state, changed PIN required." },
	{ TSE1_ERROR_WRONG_STATE_NEEDS_TSE_UNLOCK, "Wrong state, unlocked TSE required." },
	{ TSE1_ERROR_WRONG_STATE_NEEDS_SELF_TEST, "Wrong state, self test must be run first." },
	{ TSE1_ERROR_WRONG_STATE_NEEDS_SELF_TEST_PASSED, "Wrong state, passed self test required." },
	{ TSE1_ERROR_FWU_INTEGRITY_FAILURE, "Firmware Update: Integrity check failed." },
	{ TSE1_ERROR_FWU_DECRYPTION_FAILURE, "Firmware Update: Decryption failed." },
	{ TSE1_ERROR_FWU_WRONG_FORMAT, "Firmware Update: Wrong format." },
	{ TSE1_ERROR_FWU_INTERNAL_ERROR, "Firmware Update: Internal error." },
	{ TSE1_ERROR_FWU_DOWNGRADE_PROHIBITED, "Firmware Update: downgrade prohibited." },
	{ TSE1_ERROR_TSE_ALREADY_INITIALIZED, "TSE already initialized." },
	{ TSE1_ERROR_TSE_DECOMMISSIONED, "TSE decommissioned." },
	{ TSE1_ERROR_TSE_NOT_INITIALIZED, "TSE not initialized." },
	{ TSE1_ERROR_AUTHENTICATION_FAILED, "Authentication failed." },
	{ TSE1_ERROR_AUTHENTICATION_PIN_BLOCKED, "PIN/PUK is blocked." },
	{ TSE1_ERROR_AUTHENTICATION_USER_NOT_LOGGED_IN, "Given user is not authenticated." },
	{ TSE1_ERROR_SELF_TEST_FAILED_FW, "Self test of FW failed." },
	{ TSE1_ERROR_SELF_TEST_FAILED_CSP, "Self test of CSP failed." },
	{ TSE1_ERROR_SELF_TEST_FAILED_RNG, "Self test of RNG failed." },
	{ TSE1_ERROR_FWU_BASE_FW_ERROR, "Firmware Update: Base FW update error." },
	{ TSE1_ERROR_FWU_FWEXT_ERROR, "Firmware Update: FW Extension update error." },
	{ TSE1_ERROR_FWU_CSP_ERROR, "Firmware Update: CSP update error." },
	{ TSE1_ERROR_EXPORT_NONE_IN_PROGRESS, "Filtered Export: no export in progress." },
	{ TSE1_ERROR_EXPORT_RETRY, "Filtered Export: no new data, keep polling." },
	{ TSE1_ERROR_EXPORT_NO_DATA_AVAILABLE, "Filtered Export: no matching entries, export would be empty." },
	{ TSE1_ERROR_CMD_NOT_FOUND, "Command not found." },
	{ TSE1_ERROR_SIG_ERROR, "Signature creation error." },
	{ TSE1_ERROR_FROM_TSE_LAST, "Highest error code that might be raised from the Germany Fiscal Element (TSE)." },
	{ TSE1_ERROR_RAISED_FROM_WORM_CARD, "Other Errors that raised from the Germany Fiscal Element (TSE)." },
	{ EXECUTION_COMPLETED_BUT_WITH_ERROR_ALLOCATING_FOR_RESULT, "Operation on the TSE is completed however DLL failed to allocate memory for the result." },
	{ EXECUTION_COMPLETED_BUT_WITH_ERROR_DECODING_RESULT, "Operation on the TSE is completed however DLL failed to decode the result." },
	{ EXECUTION_COMPLETED_BUT_WITH_UNFINALIZED_EXPORT, "Operation on the TSE is completed however DLL failed to end the export (FinalizeExport)." },
	{ DEVICE_NO_CONNECTION, "No connection has been established with the TSE." },
	{ DEVICE_CONNECTION_ERROR, "Connection with the TSE has failed." },
	{ OTHER_ERROR_INVALID_POINTER, "Pointer passed to the API function is invalid." },
	{ OTHER_ERROR_ENCODING_FAILED, "Encoding data failed." }
};


static const std::map<short int, std::string> gErrDescDE =
{
	{ EXECUTION_OK, "Operation wurde erfolgreich ausgefhrt." },
	{ JSON_ERROR_NOT_ENOUGH_CONTENTS, "Ungltiger Inhalt in der JSON-Nachricht (fehlender Parameter etc.)." },
	{ JSON_ERROR_UNEXPECTED_PARAM_TYPE, "Ungltiger Datentyp eines Parameters in der JSON-Nachricht." },
	{ JSON_ERROR_OVER_DATA_SIZE, "JSON-Nachricht berschreitet die maximal untersttzte Gre (64 KB)." },
	{ JSON_ERROR_INVALID_PARAMETER_RANGE, "Parameter der JSON Nachricht sind auerhalb des gltigen Bereichs." },
	{ JSON_ERROR_INVALID_PARAMETER, "Ungltiger Parameter." },
	{ JSON_ERROR_INVALID_TIME_FORMAT, "Ungltiges Zeitstempel-Format in einem der Parameter der JSON-Nachricht." },
	{ JSON_ERROR_UNEXPECTED_STORAGE_TYPE, "Ungltiger Wert fr \"storage\" \"type\" in einem Parameter der JSON-Nachricht." },
	{ JSON_ERROR_UNEXPECTED_STORAGE_VENDOR, "Ungltiger Wert fr \"storage\" \"vendor\" in einem Parameter der JSON-Nachricht." },
	{ JSON_ERROR_UNEXPECTED_FUNCTION, "Unerwarteter Wert fr function\" in einem der Parameter der JSON - Nachricht\"." },
	{ JSON_ERROR_UNEXPECTED_COMPRESSION_TYPE, "Unerwarteter Wert fr \"compress\" \"type\" in einem Parameter der JSON-Nachricht." },
	{ JSON_ERROR_WRONG_JSON_FORMAT, "JSON-Nachricht ist nicht im JSON-Format." },
	{ OTHER_ERROR_UNKNOWN_STORAGE, "Eingelegtes Speichermedium ist keine untersttzte TSE." },
	{ OTHER_ERROR_NO_STORAGE_FOUND, "Kein gltiges Speichermedium eingelegt." },
	{ OTHER_ERROR_UPDATE_SYSTIME_FAIL, "Aktualisierung der Drucker-Zeit fehlgeschlagen." },
	{ OTHER_ERROR_INVALID_ADMIN_USER_ID, "Fr Administrator-Zugriff wurde eine andere User ID als \"Administrator\" angegeben." },
	{ OTHER_ERROR_HOST_AUTHENTICATION_FAILED, "Fehler bei der Host-Authentifizierung. Der Hash-Wert ist inkorrekt." },
	{ OTHER_ERROR_UNAUTHENTICATED_TIME_ADMIN_USER, "Ein Request von nicht authentifiziertem Benutzer mit TimeAdmin-Rechten wurde empfangen." },
	{ OTHER_ERROR_UNAUTHENTICATED_ADMIN_USER, "Ein Request von nicht authentifiziertem Benutzer mit Admin-Rechten wurde empfangen." },
	{ OTHER_ERROR_UNAUTHENTICATED_USER, "Request von nicht mit Admin- oder TimeAdmin-Rechten authentifiziertem Benutzer wurde empfangen." },
	{ OTHER_ERROR_UNAUTHENTICATED_HOST, "Ein Request von nicht authentifiziertem Host wurde empfangen.." },
	{ OTHER_ERROR_CURRENTLY_EXPORTING, "Whrend des laufenden Exports wurde ein anderer Request empfangen." },
	{ OTHER_ERROR_NO_EXPORT_STARTED, "Ein Request wurde empfangen, der nur whrend eines laufenden Exports ausgefhrt werden kann." },
	{ OTHER_ERROR_CURRENTLY_EXPORTING_USER, "Die User-ID, mit der gerade exportiert wird, wurde ausgeloggt."},
	{ OTHER_ERROR_NO_TIME_SET_BEFORE_EXPORT, "Die TSE-Zeit wurde vor dem Export nicht aktualisiert." },
	{ OTHER_ERROR_ALREADY_ALL_DATA_EXPORTED, "Ein Befehl zum Abruf von Exportdaten wurde empfangen, nachdem bereits alle Daten abgerufen waren." },
	{ OTHER_ERROR_ALL_DATA_NOT_EXPORTED_YET, "Ein Befehl zum Beenden des Exports wurde empfangen, bevor alle Daten abgerufen waren." },
	{ OTHER_ERROR_TSE_ALREADY_SET_UP, "Ein SetUp-Befehl wurde empfangen, obwohl die TSE bereits eingerichtet ist." },
	{ OTHER_ERROR_SECRETKEY_REGISTRATION_FAILED, "Registrierung des Secret Key fehlgeschlagen." },
	{ OTHER_ERROR_PARAMETER_MISMATCH, "Inkorrekte Parameter zur Spezifizierung des Export-Umfangs angegeben." },
	{ OTHER_ERROR_TOO_MANY_TIME_ADMIN_USER_LOGGED_IN, "Das obere Limit der Anzahl gleichzeitig angemeldeter TimeAdmin-User wurde berschritten." },
	{ OTHER_ERROR_TOO_MANY_CHALLENGE_REQUESTED, "Maximale Anzahl von Usern, die gleichzeitig eine Challenge anfragen wurde berschritten." },
	{ OTHER_ERROR_NO_MEMORY, "Speicherberlauf. Dies sollte normalerweise nicht vorkommen." },
	{ OTHER_ERROR_FATAL, "Fataler Fehler aufgrund eines unerwarteten Ereignisses (hauptschlich von Seiten der TSE)." },
	{ OTHER_ERROR_CANNOT_GET_TSE_LIST, "Kann keine Liste der TSE-Gerte abrufen." },
	{ TSE1_ERROR_INVALID_PARAMETER, "Ungltiger Eingabeparameter." },
	{ TSE1_ERROR_NO_TSE, "Am angegebenen Pfad wurde keine TSE gefunden." },
	{ TSE1_ERROR_IO, "Keine TSE erkannt / eingelegt als ein Befehl empfangen wurde." },
	{ TSE1_ERROR_TIMEOUT, "Der Time-Out fr die Operation ist abgelaufen." },
	{ TSE1_ERROR_OUTOFMEM, "Es wurde ein Bereich auerhalb der Arbeitsspeichers adressiert." },
	{ TSE1_ERROR_INVALID_RESPONSE, "Inkorrekte Antwort von der TSE." },
	{ TSE1_ERROR_STORE_FULL_INTERNAL, "TSE ist intern voll." },
	{ TSE1_ERROR_RESPONSE_MISSING, "Dies passiert, wenn man zwei Befehle parallel oder einen aktuell nicht erlaubten Befehl schickt." },
	{ TSE1_ERROR_EXPORT_NOT_INITIALIZED, "TSE Store wurde nicht initialisiert." },
	{ TSE1_ERROR_EXPORT_FAILED, "Export fehlgeschlagen." },
	{ TSE1_ERROR_POWER_CYCLE_DETECTED, "Ein Ein-Aus-Zyklus fand whrend der Befehlsausfhrung statt." },
	{ TSE1_ERROR_FIRMWARE_UPDATE_NOT_APPLIED, "Das Firmware-Update wurde nicht korrekt ausgefhrt." },
	{ TSE1_ERROR_FROM_TSE_FIRST, "Der niedrigste Fehlercode, der von der TSE gemeldet werden kann." },
	{ TSE1_ERROR_UNKNOWN, "Unspezifiziert, interner Verarbeitungsfehler." },
	{ TSE1_ERROR_NO_TIME_SET, "Zeit wurde nicht gesetzt." },
	{ TSE1_ERROR_NO_TRANSACTION_IN_PROGRESS, "Keine offene Transaktion vorhanden." },
	{ TSE1_ERROR_INVALID_CMD_SYNTAX, "Befehl hat falsche Lnge." },
	{ TSE1_ERROR_NOT_ENOUGH_DATA_WRITTEN, "Nicht genug Daten geschrieben whrend der Transaktion." },
	{ TSE1_ERROR_TSE_INVALID_PARAMETER, "Ungltiger Parameter." },
	{ TSE1_ERROR_TRANSACTION_NOT_STARTED, "Die angegebene Transaktion wurde nicht gestartet." },
	{ TSE1_ERROR_MAX_PARALLEL_TRANSACTIONS, "Maximale Anzahl paralleler Transaktionen erreicht." },
	{ TSE1_ERROR_CERTIFICATE_EXPIRED, "Zertikat abgelaufen." },
	{ TSE1_ERROR_NO_LAST_TRANSACTION, "Keine letzte Transaktion vorhanden." },
	{ TSE1_ERROR_CMD_NOT_ALLOWED, "Befehl im aktuellen Status nicht erlaubt." },
	{ TSE1_ERROR_TRANSACTION_SIGNATURES_EXCEEDED, "Maximale Anzahl an Signaturen berschritten" },
	{ TSE1_ERROR_NOT_AUTHORIZED, "Nicht authorisiert." },
	{ TSE1_ERROR_MAX_REGISTERED_CLIENTS_REACHED, "Die Maxmimalanzahl registrierter Clients wurde erreicht." },
	{ TSE1_ERROR_CLIENT_NOT_REGISTERED, "Client ist nicht registriert." },
	{ TSE1_ERROR_EXPORT_UNACKNOWLEDGED_DATA, "Lschen fehlgeschlagen, nicht alle Daten wurden exportiert." },
	{ TSE1_ERROR_CLIENT_HAS_UNFINISHED_TRANSACTIONS, "Deregistrierung fehlgeschlagen: Client hat offene Transaktionen." },
	{ TSE1_ERROR_TSE_HAS_UNFINISHED_TRANSACTIONS, "Dekomissionierung fehlgeschlagen: TSE hat offene Transaktionen." },
	{ TSE1_ERROR_TSE_NO_RESPONSE_TO_FETCH, "Falscher Status: Es liegt keine Antwort vor." },
	{ TSE1_ERROR_NOT_ALLOWED_EXPORT_IN_PROGRESS, "Falscher Status: FilteredExport muss beendet werden, bevor dieser Befehl erlaubt ist." },
	{ TSE1_ERROR_STORE_FULL, "Operation fehlgeschlagen, es ist nicht genug verbleibende Speicherkapazitt in der TSE vorhanden." },
	{ TSE1_ERROR_WRONG_STATE_NEEDS_PUK_CHANGE, "Falscher Status: PUK-nderung bentigt." },
	{ TSE1_ERROR_WRONG_STATE_NEEDS_PIN_CHANGE, "Falscher Status: PIN-nderung bentigt." },
	{ TSE1_ERROR_WRONG_STATE_NEEDS_TSE_UNLOCK, "Falscher Status: Entsperrte TSE bentigt" },
	{ TSE1_ERROR_WRONG_STATE_NEEDS_SELF_TEST, "Falscher Status: Self-Test muss erst durchgefhrt werden." },
	{ TSE1_ERROR_WRONG_STATE_NEEDS_SELF_TEST_PASSED, "Falscher Status: Self-Test bentigt." },
	{ TSE1_ERROR_FWU_INTEGRITY_FAILURE, "Firmware-Update: Integrittsprfung fehlgeschlagen." },
	{ TSE1_ERROR_FWU_DECRYPTION_FAILURE, "Firmware-Update: Entschlsselung fehlgeschlagen." },
	{ TSE1_ERROR_FWU_WRONG_FORMAT, "Firmware-Update: Falsches Format." },
	{ TSE1_ERROR_FWU_INTERNAL_ERROR, "Firmware-Update: Interner Fehler." },
	{ TSE1_ERROR_FWU_DOWNGRADE_PROHIBITED, "Firmware-Update: Downgrade ist nicht gestattet." },
	{ TSE1_ERROR_TSE_ALREADY_INITIALIZED, "TSE wurde bereits initialisiert." },
	{ TSE1_ERROR_TSE_DECOMMISSIONED, "TSE wurde dekommissioniert." },
	{ TSE1_ERROR_TSE_NOT_INITIALIZED, "TSE wurde nicht initialisiert." },
	{ TSE1_ERROR_AUTHENTICATION_FAILED, "Authentifizierung fehlgeschlagen." },
	{ TSE1_ERROR_AUTHENTICATION_PIN_BLOCKED, "PIN/PUK ist gesperrt" },
	{ TSE1_ERROR_AUTHENTICATION_USER_NOT_LOGGED_IN, "Der angegebene User ist nicht authentifiziert." },
	{ TSE1_ERROR_SELF_TEST_FAILED_FW, "Selbsttest der FW fehlgeschlagen." },
	{ TSE1_ERROR_SELF_TEST_FAILED_CSP, "Selbsttest des CSP fehlgeschlagen." },
	{ TSE1_ERROR_SELF_TEST_FAILED_RNG, "Selbsttest des RNG fehlgeschlagen." },
	{ TSE1_ERROR_FWU_BASE_FW_ERROR, "Firmware-Update: Basis-FW-Update-Fehler." },
	{ TSE1_ERROR_FWU_FWEXT_ERROR, "Firmware-Update: FW-Erweiterungs-Update-Fehler." },
	{ TSE1_ERROR_FWU_CSP_ERROR, "Firmware-Update: CSP-Update-Fehler." },
	{ TSE1_ERROR_EXPORT_NONE_IN_PROGRESS, "Gefilterter Export: Es wurde kein Export gestartet." },
	{ TSE1_ERROR_EXPORT_RETRY, "Gefilterter Export: Keine neuen Daten bisher, weiterhin pollen." },
	{ TSE1_ERROR_EXPORT_NO_DATA_AVAILABLE, "Gefilterter Export: Keine passenden Eintrge vorhanden, der Export wre leer." },
	{ TSE1_ERROR_CMD_NOT_FOUND, "Befehl nicht gefunden." },
	{ TSE1_ERROR_SIG_ERROR, "Fehler bei Erstellung der Signatur." },
	{ TSE1_ERROR_FROM_TSE_LAST, "Der hchste Fehlercode, der von der TSE gemeldet werden kann." },
	{ TSE1_ERROR_RAISED_FROM_WORM_CARD, "Andere Fehler, die von der TSE gemeldet wurden." },
	{ EXECUTION_COMPLETED_BUT_WITH_ERROR_ALLOCATING_FOR_RESULT, "Vollstndige Operation auf TSE, aber die DLL konnte keine Speicher fr das Ergebnis bereitstellen." },
	{ EXECUTION_COMPLETED_BUT_WITH_ERROR_DECODING_RESULT, "Vollstndige Operation auf TSE, aber die DLL konnte das Ergebnis nicht dekodieren." },
	{ EXECUTION_COMPLETED_BUT_WITH_UNFINALIZED_EXPORT, "Vollstndige Operation auf TSE, aber die DLL konnte den Export nicht beenden (FinalizeExport)." },
	{ DEVICE_NO_CONNECTION, "Es konnte keine Verbindung zur TSE hergestellte werden." },
	{ DEVICE_CONNECTION_ERROR, "Verbindung mit der TSE ist fehlgeschlagen." },
	{ OTHER_ERROR_INVALID_POINTER, "Ungltiger Zeiger an API-Funktion bergeben." },
	{ OTHER_ERROR_ENCODING_FAILED, "Datenkodierung fehlgeschlagen." }
};