// Copyright 2020-2021 Seiko Epson Corporation.
// Epson Europe
// EEB/RDC
// 2021/03  ka
// This Application is intended for demonstration purposes only and not for production environment.

#include "stdafx.h"
#include <string>
#include <sstream>
#include <vector>
#include <iomanip> 
#include "../../Core/TSEUtil.h"
#include "../../Core/TseSimpleJsonAndXmlParser.h"
#include "../Include/EpsonTSELibStatusCodes.h"
#include "../Include/EpsonTseLibCMulti.h"
#undef USING_REGEX 
#ifdef USING_REGEX
#include <regex>
#endif /*USING_REGEX*/  

short int LGetStatusCode(const std::string& tResult)
{
	if (tResult == "EXECUTION_OK")											return EXECUTION_OK;
	else if (tResult == "JSON_ERROR_NOT_ENOUGH_CONTENTS")					return JSON_ERROR_NOT_ENOUGH_CONTENTS;
	else if (tResult == "JSON_ERROR_UNEXPECTED_PARAM_TYPE")					return JSON_ERROR_UNEXPECTED_PARAM_TYPE;
	else if (tResult == "JSON_ERROR_OVER_DATA_SIZE")						return JSON_ERROR_OVER_DATA_SIZE;
	else if (tResult == "JSON_ERROR_INVALID_PARAMETER_RANGE")				return JSON_ERROR_INVALID_PARAMETER_RANGE;
	else if (tResult == "JSON_ERROR_INVALID_PARAMETER")						return JSON_ERROR_INVALID_PARAMETER;
	else if (tResult == "JSON_ERROR_INVALID_TIME_FORMAT")					return JSON_ERROR_INVALID_TIME_FORMAT;
	else if (tResult == "JSON_ERROR_UNEXPECTED_STORAGE_TYPE")				return JSON_ERROR_UNEXPECTED_STORAGE_TYPE;
	else if (tResult == "JSON_ERROR_UNEXPECTED_STORAGE_VENDOR")				return JSON_ERROR_UNEXPECTED_STORAGE_VENDOR;
	else if (tResult == "JSON_ERROR_UNEXPECTED_FUNCTION")					return JSON_ERROR_UNEXPECTED_FUNCTION;
	else if (tResult == "JSON_ERROR_UNEXPECTED_COMPRESSION_TYPE")			return JSON_ERROR_UNEXPECTED_COMPRESSION_TYPE;
	else if (tResult == "JSON_ERROR_WRONG_JSON_FORMAT")						return JSON_ERROR_WRONG_JSON_FORMAT;

	else if (tResult == "OTHER_ERROR_UNKNOWN_STORAGE")						return OTHER_ERROR_UNKNOWN_STORAGE;
	else if (tResult == "OTHER_ERROR_NO_STORAGE_FOUND")						return OTHER_ERROR_NO_STORAGE_FOUND;
	else if (tResult == "OTHER_ERROR_UPDATE_SYSTIME_FAIL")					return OTHER_ERROR_UPDATE_SYSTIME_FAIL;
	else if (tResult == "OTHER_ERROR_INVALID_ADMIN_USER_ID")				return OTHER_ERROR_INVALID_ADMIN_USER_ID;
	else if (tResult == "OTHER_ERROR_HOST_AUTHENTICATION_FAILED")			return OTHER_ERROR_HOST_AUTHENTICATION_FAILED;
	else if (tResult == "OTHER_ERROR_UNAUTHENTICATED_TIME_ADMIN_USER")		return OTHER_ERROR_UNAUTHENTICATED_TIME_ADMIN_USER;
	else if (tResult == "OTHER_ERROR_UNAUTHENTICATED_ADMIN_USER")			return OTHER_ERROR_UNAUTHENTICATED_ADMIN_USER;
	else if (tResult == "OTHER_ERROR_UNAUTHENTICATED_USER")					return OTHER_ERROR_UNAUTHENTICATED_USER;
	else if (tResult == "OTHER_ERROR_UNAUTHENTICATED_HOST")					return OTHER_ERROR_UNAUTHENTICATED_HOST;
	else if (tResult == "OTHER_ERROR_CURRENTLY_EXPORTING")					return OTHER_ERROR_CURRENTLY_EXPORTING;
	else if (tResult == "OTHER_ERROR_NO_EXPORT_STARTED")					return OTHER_ERROR_NO_EXPORT_STARTED;
	else if (tResult == "OTHER_ERROR_CURRENTLY_EXPORTING_USER")				return OTHER_ERROR_CURRENTLY_EXPORTING_USER;
	else if (tResult == "OTHER_ERROR_NO_TIME_SET_BEFORE_EXPORT")			return OTHER_ERROR_NO_TIME_SET_BEFORE_EXPORT;
	else if (tResult == "OTHER_ERROR_ALREADY_ALL_DATA_EXPORTED")			return OTHER_ERROR_ALREADY_ALL_DATA_EXPORTED;
	else if (tResult == "OTHER_ERROR_ALL_DATA_NOT_EXPORTED_YET")			return OTHER_ERROR_ALL_DATA_NOT_EXPORTED_YET;
	else if (tResult == "OTHER_ERROR_TSE_ALREADY_SET_UP")					return OTHER_ERROR_TSE_ALREADY_SET_UP;
	else if (tResult == "OTHER_ERROR_SECRETKEY_REGISTRATION_FAILED")		return OTHER_ERROR_SECRETKEY_REGISTRATION_FAILED;
	else if (tResult == "OTHER_ERROR_PARAMETER_MISMATCH")					return OTHER_ERROR_PARAMETER_MISMATCH;
	else if (tResult == "OTHER_ERROR_TOO_MANY_TIME_ADMIN_USER_LOGGED_IN")	return OTHER_ERROR_TOO_MANY_TIME_ADMIN_USER_LOGGED_IN;
	else if (tResult == "OTHER_ERROR_TOO_MANY_CHALLENGE_REQUESTED")			return OTHER_ERROR_TOO_MANY_CHALLENGE_REQUESTED;
	else if (tResult == "OTHER_ERROR_NO_MEMORY")							return OTHER_ERROR_NO_MEMORY;
	else if (tResult == "OTHER_ERROR_FATAL")								return OTHER_ERROR_FATAL;
	else if (tResult == "OTHER_ERROR_CANNOT_GET_TSE_LIST")					return OTHER_ERROR_CANNOT_GET_TSE_LIST;

	else if (tResult == "TSE1_ERROR_INVALID_PARAMETER")						return TSE1_ERROR_INVALID_PARAMETER;
	else if (tResult == "TSE1_ERROR_NO_TSE")								return TSE1_ERROR_NO_TSE;
	else if (tResult == "TSE1_ERROR_IO")									return TSE1_ERROR_IO;
	else if (tResult == "TSE1_ERROR_TIMEOUT")								return TSE1_ERROR_TIMEOUT;
	else if (tResult == "TSE1_ERROR_OUTOFMEM")								return TSE1_ERROR_OUTOFMEM;
	else if (tResult == "TSE1_ERROR_INVALID_RESPONSE")						return TSE1_ERROR_INVALID_RESPONSE;
	else if (tResult == "TSE1_ERROR_STORE_FULL_INTERNAL")					return TSE1_ERROR_STORE_FULL_INTERNAL;
	else if (tResult == "TSE1_ERROR_RESPONSE_MISSING")						return TSE1_ERROR_RESPONSE_MISSING;
	else if (tResult == "TSE1_ERROR_EXPORT_NOT_INITIALIZED")				return TSE1_ERROR_EXPORT_NOT_INITIALIZED;
	else if (tResult == "TSE1_ERROR_EXPORT_FAILED")							return TSE1_ERROR_EXPORT_FAILED;
	else if (tResult == "TSE1_ERROR_POWER_CYCLE_DETECTED")					return TSE1_ERROR_POWER_CYCLE_DETECTED;
	else if (tResult == "TSE1_ERROR_FIRMWARE_UPDATE_NOT_APPLIED")			return TSE1_ERROR_FIRMWARE_UPDATE_NOT_APPLIED;
	else if (tResult == "TSE1_ERROR_FROM_TSE_FIRST")						return TSE1_ERROR_FROM_TSE_FIRST;
	else if (tResult == "TSE1_ERROR_UNKNOWN")								return TSE1_ERROR_UNKNOWN;
	else if (tResult == "TSE1_ERROR_NO_TIME_SET")							return TSE1_ERROR_NO_TIME_SET;
	else if (tResult == "TSE1_ERROR_NO_TRANSACTION_IN_PROGRESS")			return TSE1_ERROR_NO_TRANSACTION_IN_PROGRESS;
	else if (tResult == "TSE1_ERROR_INVALID_CMD_SYNTAX")					return TSE1_ERROR_INVALID_CMD_SYNTAX;
	else if (tResult == "TSE1_ERROR_NOT_ENOUGH_DATA_WRITTEN")				return TSE1_ERROR_NOT_ENOUGH_DATA_WRITTEN;
	else if (tResult == "TSE1_ERROR_TSE_INVALID_PARAMETER")					return TSE1_ERROR_TSE_INVALID_PARAMETER;
	else if (tResult == "TSE1_ERROR_TRANSACTION_NOT_STARTED")				return TSE1_ERROR_TRANSACTION_NOT_STARTED;
	else if (tResult == "TSE1_ERROR_MAX_PARALLEL_TRANSACTIONS")				return TSE1_ERROR_MAX_PARALLEL_TRANSACTIONS;
	else if (tResult == "TSE1_ERROR_CERTIFICATE_EXPIRED")					return TSE1_ERROR_CERTIFICATE_EXPIRED;
	else if (tResult == "TSE1_ERROR_NO_LAST_TRANSACTION")					return TSE1_ERROR_NO_LAST_TRANSACTION;
	else if (tResult == "TSE1_ERROR_CMD_NOT_ALLOWED")						return TSE1_ERROR_CMD_NOT_ALLOWED;
	else if (tResult == "TSE1_ERROR_TRANSACTION_SIGNATURES_EXCEEDED")		return TSE1_ERROR_TRANSACTION_SIGNATURES_EXCEEDED;
	else if (tResult == "TSE1_ERROR_NOT_AUTHORIZED")						return TSE1_ERROR_NOT_AUTHORIZED;
	else if (tResult == "TSE1_ERROR_MAX_REGISTERED_CLIENTS_REACHED")		return TSE1_ERROR_MAX_REGISTERED_CLIENTS_REACHED;
	else if (tResult == "TSE1_ERROR_CLIENT_NOT_REGISTERED")					return TSE1_ERROR_CLIENT_NOT_REGISTERED;
	else if (tResult == "TSE1_ERROR_EXPORT_UNACKNOWLEDGED_DATA")			return TSE1_ERROR_EXPORT_UNACKNOWLEDGED_DATA;
	else if (tResult == "TSE1_ERROR_CLIENT_HAS_UNFINISHED_TRANSACTIONS")	return TSE1_ERROR_CLIENT_HAS_UNFINISHED_TRANSACTIONS;
	else if (tResult == "TSE1_ERROR_TSE_HAS_UNFINISHED_TRANSACTIONS")		return TSE1_ERROR_TSE_HAS_UNFINISHED_TRANSACTIONS;
	else if (tResult == "TSE1_ERROR_TSE_NO_RESPONSE_TO_FETCH")				return TSE1_ERROR_TSE_NO_RESPONSE_TO_FETCH;
	else if (tResult == "TSE1_ERROR_NOT_ALLOWED_EXPORT_IN_PROGRESS")		return TSE1_ERROR_NOT_ALLOWED_EXPORT_IN_PROGRESS;
	else if (tResult == "TSE1_ERROR_STORE_FULL")							return TSE1_ERROR_STORE_FULL;
	else if (tResult == "TSE1_ERROR_WRONG_STATE_NEEDS_PUK_CHANGE")			return TSE1_ERROR_WRONG_STATE_NEEDS_PUK_CHANGE;
	else if (tResult == "TSE1_ERROR_WRONG_STATE_NEEDS_PIN_CHANGE")			return TSE1_ERROR_WRONG_STATE_NEEDS_PIN_CHANGE;
	else if (tResult == "TSE1_ERROR_WRONG_STATE_NEEDS_TSE_UNLOCK")			return TSE1_ERROR_WRONG_STATE_NEEDS_TSE_UNLOCK;
	else if (tResult == "TSE1_ERROR_WRONG_STATE_NEEDS_SELF_TEST")			return TSE1_ERROR_WRONG_STATE_NEEDS_SELF_TEST;
	else if (tResult == "TSE1_ERROR_WRONG_STATE_NEEDS_SELF_TEST_PASSED")	return TSE1_ERROR_WRONG_STATE_NEEDS_SELF_TEST_PASSED;
	else if (tResult == "TSE1_ERROR_FWU_INTEGRITY_FAILURE")					return TSE1_ERROR_FWU_INTEGRITY_FAILURE;
	else if (tResult == "TSE1_ERROR_FWU_DECRYPTION_FAILURE")				return TSE1_ERROR_FWU_DECRYPTION_FAILURE;
	else if (tResult == "TSE1_ERROR_FWU_WRONG_FORMAT")						return TSE1_ERROR_FWU_WRONG_FORMAT;
	else if (tResult == "TSE1_ERROR_FWU_INTERNAL_ERROR")					return TSE1_ERROR_FWU_INTERNAL_ERROR;
	else if (tResult == "TSE1_ERROR_FWU_DOWNGRADE_PROHIBITED")				return TSE1_ERROR_FWU_DOWNGRADE_PROHIBITED;
	else if (tResult == "TSE1_ERROR_TSE_ALREADY_INITIALIZED")				return TSE1_ERROR_TSE_ALREADY_INITIALIZED;
	else if (tResult == "TSE1_ERROR_TSE_DECOMMISSIONED")					return TSE1_ERROR_TSE_DECOMMISSIONED;
	else if (tResult == "TSE1_ERROR_TSE_NOT_INITIALIZED")					return TSE1_ERROR_TSE_NOT_INITIALIZED;
	else if (tResult == "TSE1_ERROR_AUTHENTICATION_FAILED")					return TSE1_ERROR_AUTHENTICATION_FAILED;
	else if (tResult == "TSE1_ERROR_AUTHENTICATION_PIN_BLOCKED")			return TSE1_ERROR_AUTHENTICATION_PIN_BLOCKED;
	else if (tResult == "TSE1_ERROR_AUTHENTICATION_USER_NOT_LOGGED_IN")		return TSE1_ERROR_AUTHENTICATION_USER_NOT_LOGGED_IN;
	else if (tResult == "TSE1_ERROR_SELF_TEST_FAILED_FW")					return TSE1_ERROR_SELF_TEST_FAILED_FW;

	else if (tResult == "TSE1_ERROR_SELF_TEST_FAILED_CSP")					return TSE1_ERROR_SELF_TEST_FAILED_CSP;
	else if (tResult == "TSE1_ERROR_SELF_TEST_FAILED_RNG")					return TSE1_ERROR_SELF_TEST_FAILED_RNG;
	else if (tResult == "TSE1_ERROR_FWU_BASE_FW_ERROR")						return TSE1_ERROR_FWU_BASE_FW_ERROR;
	else if (tResult == "TSE1_ERROR_FWU_FWEXT_ERROR")						return TSE1_ERROR_FWU_FWEXT_ERROR;
	else if (tResult == "TSE1_ERROR_FWU_CSP_ERROR")							return TSE1_ERROR_FWU_CSP_ERROR;
	else if (tResult == "TSE1_ERROR_EXPORT_NONE_IN_PROGRESS")				return TSE1_ERROR_EXPORT_NONE_IN_PROGRESS;
	else if (tResult == "TSE1_ERROR_EXPORT_RETRY")							return TSE1_ERROR_EXPORT_RETRY;
	else if (tResult == "TSE1_ERROR_EXPORT_NO_DATA_AVAILABLE")				return TSE1_ERROR_EXPORT_NO_DATA_AVAILABLE;
	else if (tResult == "TSE1_ERROR_CMD_NOT_FOUND")							return TSE1_ERROR_CMD_NOT_FOUND;
	else if (tResult == "TSE1_ERROR_SIG_ERROR")								return TSE1_ERROR_SIG_ERROR;
	else if (tResult == "TSE1_ERROR_FROM_TSE_LAST")							return TSE1_ERROR_FROM_TSE_LAST;
	else if (tResult == "TSE1_ERROR_RAISED_FROM_WORM_CARD")					return TSE1_ERROR_RAISED_FROM_WORM_CARD;

	return OTHER_ERROR;
}


unsigned long LStringToLongInt(const std::string& tStr)
{
	std::stringstream ss;
	long int retVal;
	ss << tStr;
	ss >> retVal;

	return retVal;
}

unsigned short LStringToShortInt(const std::string& tStr)
{
	std::stringstream ss;
	short int retVal;
	ss << tStr;
	ss >> retVal;

	return retVal;
}

void LStringToCharArray(const std::string& tStr, unsigned char * tCstr, unsigned long tBufSize)
{
#if NULL_CHAR
	unsigned long length = tBufSize - 1;   //-1, null character
#else
	unsigned long length = tBufSize;
#endif

	if (tStr.length() < length)
	{
		length = (unsigned long) tStr.length();
	}

	memcpy_s(tCstr, length, tStr.c_str(), length);

#if NULL_CHAR
	tCstr[length] = '\0';
#endif

	return;
}

bool LStringToBool(const std::string& tStr)
{
	if (tStr == "true")
	{
		return true;
	}
	return false;
}
#ifdef STRUCT_TM
void LStringToUtcDateTime(const std::string& tStr, struct tm& tDateTime)
{
	std::stringstream ss;
	struct tm*  tmp = &tDateTime;

	ss << tStr;
	ss >> std::get_time(tmp, "%Y-%m-%dT%H:%M:%SZ");

	time_t timet = _mkgmtime(&tmp);
	//time_t timet = mktime(tmp);

	if (timet == -1) return;

	gmtime_s(tmp, &timet);
	return;
}

std::string LUtcDateTimeToString(const struct tm& tDateTime)
{

	char buffer[sizeof("2019-01-01T23:59:59Z")];
	strftime(buffer, sizeof(buffer), "%FT%TZ", &tDateTime);

	return buffer;
}
#else
void LStringToUtcDateTime(const std::string& tStr, unsigned long& tDateTime)
{
	std::stringstream ss;
	struct tm stm;

	if (TSEUtil::IsDateTime(tStr) == false)
	{
		tDateTime = 0;
		return;
	}

	ss << tStr;
	ss >> std::get_time(&stm, "%Y-%m-%dT%H:%M:%SZ");

	
	time_t timet = _mkgmtime(&stm);
	//time_t timet = mktime(&stm);

	if (timet == -1) {
		tDateTime = 0;
		return;
	}

	tDateTime = (unsigned long) timet;
	return;
}

std::string LUtcDateTimeToString(unsigned long tDateTime)
{
	struct tm  stm;
	time_t timet = tDateTime;
	int result = gmtime_s(&stm, &timet);
	if (result != 0)
	{
		return "";	
	}
	char buffer[sizeof("2019-01-01T23:59:59Z")];
	strftime(buffer, sizeof(buffer), "%FT%TZ", &stm);

	return buffer;
}
#endif

std::string LIntegerToString(unsigned long tInt)
{
	std::stringstream ss;
	ss << tInt;

	return ss.str();
}

std::string LIntegerToString(unsigned short tInt)
{
	std::stringstream ss;
	ss << tInt;

	return ss.str();
}

void LStringToVector(const std::string& tString, std::vector<unsigned long int> &tNum)
{
#ifndef USING_REGEX
	tNum.clear();
	if (tString == "")
		return;

	size_t it = 0;

	std::string strtemp = "";
	for (it = 0; it < tString.size(); it++)
	{
		if (tString.at(it) == ',')
		{
			std::stringstream ss;
			unsigned long int match = 0;
			ss << strtemp;
			ss >> match;
			tNum.push_back(match);
			strtemp = "";
		}
		else
		{
			strtemp += tString.at(it);
			if ((it + 1) >= tString.size())
			{
				std::stringstream ss;
				unsigned long int match = 0;
				ss << strtemp;
				ss >> match;
				tNum.push_back(match);
				strtemp = "";
			}
		}
	}
	return;
#else /*USING_REGEX*/
	std::regex rgx(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)");
	std::sregex_token_iterator reg_iter(tString.begin(), tString.end(), rgx, -1);
	std::sregex_token_iterator end;

	tNum.clear();

	if (tString == "")
		return;

	for (; reg_iter != end; ++reg_iter)
	{
		std::stringstream ss;
		unsigned long int match = 0;
		ss << *reg_iter;
		ss >> match;

		tNum.push_back(match);
	}
#endif /*USING_REGEX*/
}

void LStringToVector(const std::string& tString, std::vector<std::string> &tStr)
{
#ifndef	USING_REGEX
	tStr.clear();
	if (tString == "")
		return;

	size_t it = 0;

	bool openp = false;
	std::string strtemp = "";
	bool btemp = false;
	for (it = 0; it < tString.size(); it++)
	{
		if (it == 0)
		{
			if (tString.at(it) == '"')
			{
				openp = !openp;
				if (openp) 
					continue;
			}
		}
		else
		{
			if ((tString.at(it) == '"') && (tString.at(it - 1) != '\\'))
			{
				openp = !openp;
				if (openp)
					continue;
			}
		}

		if (openp)
		{
			strtemp += tString.at(it);
			btemp = true;
		}
		else
		{
			if (btemp)
			{
				tStr.push_back(strtemp);
				strtemp = "";
				btemp = false;
			}
		}
	}
	return ;
#else /*USING_REGEX*/
	std::regex rgx(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)");
	std::sregex_token_iterator reg_iter(tString.begin(), tString.end(), rgx, -1);
	std::sregex_token_iterator end;

	tStr.clear();
	if (tString == "") 
		return;

	for (; reg_iter != end; ++reg_iter)
	{
		std::string match = reg_iter->str();
		match = match.substr(1, match.size() - 2);
		tStr.push_back(match);
	}
#endif /*USING_REGEX*/
}

void LVectorToCharArray(std::vector<unsigned char> &tChrVec, unsigned char * tChrArr, unsigned long tChrArrLen )
{
	unsigned long cnt = 0;
	for (std::vector<unsigned char>::iterator iter = tChrVec.begin(); iter != tChrVec.end(); ++iter)
	{
		if ((cnt+1) > tChrArrLen) 
			break;
		tChrArr[cnt] = *iter;
		cnt++;
	}
}

/*TSEUtil*/
std::string LEncodeBase64Sha256(const std::vector<unsigned char>& tData) {
	return TSEUtil::EncodeBase64Sha256(tData);
}

std::string LEncodeBase64(const std::vector<unsigned char>& tData) {
	return TSEUtil::EncodeBase64(tData);
}

void LDecodeBase64(const std::string& tString, std::vector<unsigned char>& tDecoded)
{
	TSEUtil::DecodeBase64(tString, tDecoded);
}

std::string LJsonGetObj(const std::string& tJsonStr, const std::string& tObj)
{
	return TseSimpleJsonAndXmlParser::JsonGetObject(tJsonStr, tObj);
}

std::string LJsonGetNonStringValue(const std::string& tJsonStr, const std::string& tKey)
{
	return TseSimpleJsonAndXmlParser::JsonGetNonStringValue(tJsonStr, tKey);
}

std::string LJsonGetValue(const std::string& tJsonStr, const std::string& tKey)
{
	return TseSimpleJsonAndXmlParser::JsonGetValue(tJsonStr, tKey);
}