// Copyright 2020-2021 Seiko Epson Corporation.
// Epson Europe
// EEB/RDC
// 2021/03  ka
// This Application is intended for demonstration purposes only and not for production environment.

#pragma once
#include <string>
#include <vector>

#define NULL_CHAR 0


short int LGetStatusCode(const std::string& tResult);

unsigned long  LStringToLongInt(const std::string& tStr);
unsigned short LStringToShortInt(const std::string& tStr);

void LStringToCharArray(const std::string& tStr, unsigned char * tCstr, unsigned long tLength);
bool LStringToBool(const std::string& tStr);


#ifdef STRUCT_TM
void LStringToUtcDateTime(const std::string& tStr, struct tm& tDateTime);
std::string LUtcDateTimeToString(const struct tm& tDateTime);
#else
void LStringToUtcDateTime(const std::string& tStr, unsigned long& tDateTime);
std::string LUtcDateTimeToString(unsigned long tDateTime);
#endif

std::string LIntegerToString(unsigned long tInt);
std::string LIntegerToString(unsigned short tInt);

void LStringToVector(const std::string& tString, std::vector<unsigned long int> &tNum);
void LStringToVector(const std::string& tString, std::vector<std::string> &tStr);
void LVectorToCharArray(std::vector<unsigned char> &tChrVec, unsigned char * tChrArr, unsigned long tChrArrLen);

/*TSEUtil*/
std::string LEncodeBase64Sha256(const std::vector<unsigned char>& tData);
std::string LEncodeBase64(const std::vector<unsigned char>& tData);
void LDecodeBase64(const std::string& tString, std::vector<unsigned char>& tDecoded);
std::string LJsonGetObj(const std::string& tJsonStr, const std::string& tObj);
std::string LJsonGetNonStringValue(const std::string& tJsonStr, const std::string& tKey);
std::string LJsonGetValue(const std::string& tJsonStr, const std::string& tKey);