// Copyright 2020 Seiko Epson Corporation.
// Epson Europe
// EEB/RDC
// 2020/12  ka
// This Application is intended for demonstration purposes only and not for production environment.

#pragma once

#include <iomanip> 
#include "../Include/EpsonTseLibCMulti.h"
#include "../../Core/TSELogger.h"


#define CALLER_NAME_LENGTH 64
#define TSEEALLOCMEMORY(x) TSEMemoryAllocate((x), (__func__))

typedef struct _TseMemoryList {
	void * mAddress;
	unsigned long mSize;
	unsigned char mCaller[CALLER_NAME_LENGTH];
	struct _TseMemoryList  * mNext;
	struct _TseMemoryList  * mPrev;
}TseMemoryList;

void* TSEMemoryAllocate(unsigned long tSize, std::string tCaller);
void TSEMemoryDeallocate(void * tAddress);
void TSEMemoryDeallocateAll();
void TSEMemoryDeallocateTseInfoObject( /*out*/  EPSON_TSE_INFO * tTseInfo);

void  TSEMemoryPrintAllocated(TSELogger& tLog);
