// Copyright 2020 Seiko Epson Corporation.
// Epson Europe
// EEB/RDC
// 2020/04  ka
// This program is intended for demonstration purposes only and not for production environment.

#ifndef __EPSONTSELIB_STATUSCODES_H__
#define __EPSONTSELIB_STATUSCODES_H__

#define ERROR_DESC_EN												(0x00)
#define ERROR_DESC_DE												(0x01)

/*Status Error codes*/
#define EXECUTION_OK												(0000)
#define EXECUTION_COMPLETED_BUT_WITH_ERROR_ALLOCATING_FOR_RESULT	(0001)
#define EXECUTION_COMPLETED_BUT_WITH_ERROR_DECODING_RESULT			(0002)
#define EXECUTION_COMPLETED_BUT_WITH_UNFINALIZED_EXPORT				(0003)

#define JSON_ERROR_NOT_ENOUGH_CONTENTS								(-1000)
#define JSON_ERROR_UNEXPECTED_PARAM_TYPE							(-1001)
#define JSON_ERROR_OVER_DATA_SIZE									(-1002)
#define JSON_ERROR_INVALID_PARAMETER_RANGE							(-1003)
#define JSON_ERROR_INVALID_PARAMETER								(-1004)
#define JSON_ERROR_INVALID_TIME_FORMAT								(-1005)
#define JSON_ERROR_UNEXPECTED_STORAGE_TYPE							(-1006)
#define JSON_ERROR_UNEXPECTED_STORAGE_VENDOR						(-1007)
#define JSON_ERROR_UNEXPECTED_FUNCTION								(-1008)
#define JSON_ERROR_UNEXPECTED_COMPRESSION_TYPE						(-1009)
#define JSON_ERROR_WRONG_JSON_FORMAT								(-1010)

#define OTHER_ERROR_UNKNOWN_STORAGE									(-2001)
#define OTHER_ERROR_NO_STORAGE_FOUND								(-2002)
#define OTHER_ERROR_UPDATE_SYSTIME_FAIL								(-2003)
#define OTHER_ERROR_INVALID_ADMIN_USER_ID							(-2004)
#define OTHER_ERROR_HOST_AUTHENTICATION_FAILED						(-2005)
#define OTHER_ERROR_UNAUTHENTICATED_TIME_ADMIN_USER					(-2006)
#define OTHER_ERROR_UNAUTHENTICATED_ADMIN_USER						(-2007)
#define OTHER_ERROR_UNAUTHENTICATED_USER							(-2008)
#define OTHER_ERROR_UNAUTHENTICATED_HOST							(-2009)
#define OTHER_ERROR_CURRENTLY_EXPORTING								(-2010)
#define OTHER_ERROR_NO_EXPORT_STARTED								(-2011)
#define OTHER_ERROR_CURRENTLY_EXPORTING_USER						(-2012)
#define OTHER_ERROR_NO_TIME_SET_BEFORE_EXPORT						(-2013)
#define OTHER_ERROR_ALREADY_ALL_DATA_EXPORTED						(-2014)
#define OTHER_ERROR_ALL_DATA_NOT_EXPORTED_YET						(-2015)
#define OTHER_ERROR_TSE_ALREADY_SET_UP								(-2016)
#define OTHER_ERROR_SECRETKEY_REGISTRATION_FAILED					(-2017)
#define OTHER_ERROR_PARAMETER_MISMATCH								(-2018)
#define OTHER_ERROR_TOO_MANY_TIME_ADMIN_USER_LOGGED_IN				(-2019)
#define OTHER_ERROR_TOO_MANY_CHALLENGE_REQUESTED					(-2020)
#define OTHER_ERROR_NO_MEMORY										(-2021)
#define OTHER_ERROR_FATAL											(-2022)
#define OTHER_ERROR_CANNOT_GET_TSE_LIST								(-2023)

#define TSE1_ERROR_INVALID_PARAMETER								(-3001)
#define TSE1_ERROR_NO_TSE											(-3002)
#define TSE1_ERROR_IO												(-3003)
#define TSE1_ERROR_TIMEOUT											(-3004)
#define TSE1_ERROR_OUTOFMEM											(-3005)
#define TSE1_ERROR_INVALID_RESPONSE									(-3006)
#define TSE1_ERROR_STORE_FULL_INTERNAL								(-3007)
#define TSE1_ERROR_RESPONSE_MISSING									(-3008)
#define TSE1_ERROR_EXPORT_NOT_INITIALIZED							(-3009)
#define TSE1_ERROR_EXPORT_FAILED									(-3010)
#define TSE1_ERROR_POWER_CYCLE_DETECTED								(-3011)
#define TSE1_ERROR_FIRMWARE_UPDATE_NOT_APPLIED						(-3012)
#define TSE1_ERROR_FROM_TSE_FIRST									(-3013)
#define TSE1_ERROR_UNKNOWN											(-3014)
#define TSE1_ERROR_NO_TIME_SET										(-3015)
#define TSE1_ERROR_NO_TRANSACTION_IN_PROGRESS						(-3016)
#define TSE1_ERROR_INVALID_CMD_SYNTAX								(-3017)
#define TSE1_ERROR_NOT_ENOUGH_DATA_WRITTEN							(-3018)
#define TSE1_ERROR_TSE_INVALID_PARAMETER							(-3019)
#define TSE1_ERROR_TRANSACTION_NOT_STARTED							(-3020)
#define TSE1_ERROR_MAX_PARALLEL_TRANSACTIONS						(-3021)
#define TSE1_ERROR_CERTIFICATE_EXPIRED								(-3022)
#define TSE1_ERROR_NO_LAST_TRANSACTION								(-3023)
#define TSE1_ERROR_CMD_NOT_ALLOWED									(-3024)
#define TSE1_ERROR_TRANSACTION_SIGNATURES_EXCEEDED					(-3025)
#define TSE1_ERROR_NOT_AUTHORIZED									(-3026)
#define TSE1_ERROR_MAX_REGISTERED_CLIENTS_REACHED					(-3027)
#define TSE1_ERROR_CLIENT_NOT_REGISTERED							(-3028)
#define TSE1_ERROR_EXPORT_UNACKNOWLEDGED_DATA						(-3029)
#define TSE1_ERROR_CLIENT_HAS_UNFINISHED_TRANSACTIONS				(-3030)
#define TSE1_ERROR_TSE_HAS_UNFINISHED_TRANSACTIONS					(-3031)
#define TSE1_ERROR_TSE_NO_RESPONSE_TO_FETCH							(-3032)
#define TSE1_ERROR_NOT_ALLOWED_EXPORT_IN_PROGRESS					(-3033)
#define TSE1_ERROR_STORE_FULL										(-3034)
#define TSE1_ERROR_WRONG_STATE_NEEDS_PUK_CHANGE						(-3035)
#define TSE1_ERROR_WRONG_STATE_NEEDS_PIN_CHANGE						(-3036)
#define TSE1_ERROR_WRONG_STATE_NEEDS_TSE_UNLOCK						(-3037)
#define TSE1_ERROR_WRONG_STATE_NEEDS_SELF_TEST						(-3038)
#define TSE1_ERROR_WRONG_STATE_NEEDS_SELF_TEST_PASSED				(-3039)
#define TSE1_ERROR_FWU_INTEGRITY_FAILURE							(-3040)
#define TSE1_ERROR_FWU_DECRYPTION_FAILURE							(-3041)
#define TSE1_ERROR_FWU_WRONG_FORMAT									(-3042)
#define TSE1_ERROR_FWU_INTERNAL_ERROR								(-3043)
#define TSE1_ERROR_FWU_DOWNGRADE_PROHIBITED							(-3044)
#define TSE1_ERROR_TSE_ALREADY_INITIALIZED							(-3045)
#define TSE1_ERROR_TSE_DECOMMISSIONED								(-3046)
#define TSE1_ERROR_TSE_NOT_INITIALIZED								(-3047)
#define TSE1_ERROR_AUTHENTICATION_FAILED							(-3048)
#define TSE1_ERROR_AUTHENTICATION_PIN_BLOCKED						(-3049)
#define TSE1_ERROR_AUTHENTICATION_USER_NOT_LOGGED_IN				(-3050)
#define TSE1_ERROR_SELF_TEST_FAILED_FW								(-3051)
#define TSE1_ERROR_SELF_TEST_FAILED_CSP								(-3052)
#define TSE1_ERROR_SELF_TEST_FAILED_RNG								(-3053)
#define TSE1_ERROR_FWU_BASE_FW_ERROR								(-3054)
#define TSE1_ERROR_FWU_FWEXT_ERROR									(-3055)
#define TSE1_ERROR_FWU_CSP_ERROR									(-3056)
#define TSE1_ERROR_EXPORT_NONE_IN_PROGRESS							(-3057)
#define TSE1_ERROR_EXPORT_RETRY										(-3058)
#define TSE1_ERROR_EXPORT_NO_DATA_AVAILABLE							(-3059)
#define TSE1_ERROR_CMD_NOT_FOUND									(-3060)
#define TSE1_ERROR_SIG_ERROR										(-3061)
#define TSE1_ERROR_FROM_TSE_LAST									(-3062)
#define TSE1_ERROR_RAISED_FROM_WORM_CARD							(-3063)

#define DEVICE_NO_CONNECTION										(-9001)
#define DEVICE_CONNECTION_ERROR										(-9002)
#define OTHER_ERROR_INVALID_POINTER									(-9003)
#define OTHER_ERROR_ENCODING_FAILED									(-9004)
#define OTHER_ERROR													(-9999)

#endif /*__EPSONTSELIB_STATUSCODES_H__*/