// Copyright 2019-2020 Seiko Epson Corporation.
// Epson Europe
// EEB/RDC
// 2020/07  ka
// This Application is intended for demonstration purposes only and not for production environment.

#pragma once
#include <winsock2.h>
#include <string>
#include <vector>

class AccessSocket
{
public:
	AccessSocket(const char * tIpAddr, const char * tPort, bool isEposDevXml = false);
	~AccessSocket();
	void Connect();
	void SocketSend(const std::vector<BYTE>& tBuffer);
	void SocketRecv(std::vector<BYTE>& tBuffer, const unsigned long& tMaxSize, const int& tTimeout);

	int InetPtonWr(int tAf, const char *tSrc, void *tDst);
	void EnableForceSend(const char * tIpAddr);
private:
	std::string mIpAddr;
	std::string mPort;
	bool mIsEposDevXml;
	SOCKET mSocket;
	bool SocketIsConnected();

};