// Copyright 2020 Seiko Epson Corporation.
// Epson Europe
// EEB/RDC
// 2020/04  ka
// This Application is intended for demonstration purposes only and not for production environment.

#include "stdafx.h"
#include <sstream>
#include "../../Core/TSEPrintLog.h"
#include "TSEMemoryMonitor.h"

static TseMemoryList * g_tse_mem_head = NULL;
static TseMemoryList * g_tse_mem_tail = NULL;

void  TSEMemoryPrintAllocated()
{
	TseMemoryList * tmp_ptr = g_tse_mem_head;
	std::stringstream print_log;

	if (tmp_ptr == NULL)
	{
		print_log << std::endl << "No Allocated Memory.";
	}
	else
	{
		while (tmp_ptr != NULL)
		{
			print_log << std::endl << "Fn=" << tmp_ptr->mCaller << "\tAddress=0x" << tmp_ptr->mAddress << "\tSize=" << tmp_ptr->mSize;
			tmp_ptr = tmp_ptr->mNext;
		}
	}
	TSEPRINTLOG(LIBLOG_LEVEL_VERBOSE, ("%s", print_log.str().c_str()));
	return;
}


void * TSEMemoryAllocate (unsigned long tSize, std::string tCaller = "")
{
	void * alloc = NULL;

	alloc = malloc(tSize);
	if (alloc == NULL) {
		return NULL;
	}

	unsigned long caller_size = (tCaller.length() > (CALLER_NAME_LENGTH - 1)) ? (CALLER_NAME_LENGTH-1) : (unsigned long) tCaller.length();

	if (g_tse_mem_head == NULL)
	{
		g_tse_mem_head = (TseMemoryList *)malloc(sizeof(TseMemoryList));

		if (g_tse_mem_head == NULL)
		{
			free(alloc);
			return NULL;
		}

		g_tse_mem_head->mAddress = alloc;
		g_tse_mem_head->mSize = tSize;
		g_tse_mem_head->mPrev = NULL;
		g_tse_mem_head->mNext = NULL;

		memcpy_s(g_tse_mem_head->mCaller, caller_size, tCaller.c_str(), caller_size);
		g_tse_mem_head->mCaller[caller_size] = '\0';

		g_tse_mem_tail = g_tse_mem_head;
	}
	else
	{
		g_tse_mem_tail->mNext = (TseMemoryList *)malloc(sizeof(TseMemoryList));

		if (g_tse_mem_tail->mNext == NULL)
		{
			free(alloc);
			return NULL;
		}

		g_tse_mem_tail->mNext->mAddress = alloc;
		g_tse_mem_tail->mNext->mSize = tSize;
		g_tse_mem_tail->mNext->mPrev = g_tse_mem_tail;
		g_tse_mem_tail->mNext->mNext = NULL;

		memcpy_s(g_tse_mem_tail->mNext->mCaller, caller_size, tCaller.c_str(), caller_size);
		g_tse_mem_tail->mNext->mCaller[caller_size] = '\0';

		g_tse_mem_tail = g_tse_mem_tail->mNext;
	}

	return alloc;
}

void TSEMemoryDeallocate(void * tAddress)
{
	if (tAddress == NULL) return;
	if (g_tse_mem_head == NULL) return;

	TseMemoryList * tmp_ptr = g_tse_mem_head;

	while (tmp_ptr != NULL)
	{
		if (tmp_ptr->mAddress == tAddress)
		{
			if (tmp_ptr->mNext != NULL)
			{
				tmp_ptr->mNext->mPrev = tmp_ptr->mPrev;
			}

			if (tmp_ptr->mPrev != NULL)
			{
				tmp_ptr->mPrev->mNext = tmp_ptr->mNext;
			}

			if (tmp_ptr == g_tse_mem_head)
			{
				g_tse_mem_head = tmp_ptr->mNext;
			}

			free(tAddress);
			free(tmp_ptr);
			break;
		}
		else
		{
			tmp_ptr = tmp_ptr->mNext;
		}
	}

	return;
}


void TSEMemoryDeallocateAll()
{
	if (g_tse_mem_head == NULL) return;

	TseMemoryList * tmp_ptr = g_tse_mem_tail;

	while (tmp_ptr != NULL)
	{
		g_tse_mem_tail = tmp_ptr->mPrev;
		free(tmp_ptr->mAddress);
		free(tmp_ptr);
		tmp_ptr = g_tse_mem_tail;
	}
	g_tse_mem_head = g_tse_mem_tail = NULL;

	return;
}


void TSEMemoryDeallocateTseInfoObject(
	/*out*/  EPSON_TSE_INFO * tTseInfo)
{
	TSEMemoryDeallocate(tTseInfo->serialNumber);
	TSEMemoryDeallocate(tTseInfo->tsePublicKey);
	TSEMemoryDeallocate(tTseInfo->rawTseInfo);

	tTseInfo->serialNumber = NULL;
	tTseInfo->tsePublicKey = NULL;
	tTseInfo->rawTseInfo = NULL;

	return;
}