// Copyright 2020-2021 Seiko Epson Corporation.
// Epson Europe
// EEB/RDC
// 2021/03 ka
// This Application is intended for demonstration purposes only and not for production environment.

#pragma once

#include "../../Core/TSEOptions.h"
#include <list>
#include <windows.h>

#define AS_ADMIN		0x00
#define AS_TIMEADMIN	0x01

class CuiLibCTester
{
public:
	CuiLibCTester();
	~CuiLibCTester();
	bool ShowMenu();
	bool SetErrorDescLanguage(short int tLanguage);
	bool ConnectToTse(const TSEOptions& tTseOpt);
	bool DisconnectFromTse();
	bool CuiGetTseId(const std::string &tIpAddress, std::string& tTseId);
private:
	HANDLE			mConsole;
	bool			mIsTseInitialized;
	bool			mIsAdminLogin;
	std::string		mCurrentUserId;
	std::string		mLastExportFile;
	short int		mErrorDescLang;
	std::list<std::string> mClientIdLogInList;

	short int CuiGetStorageInfo();
	short int CuiGetStorageSmartInfo();
	short int CuiRunTseSelfTest();
	short int CuiSetup();
	short int CuiFactoryReset();
	short int CuiGetLogMsgCertificate();
	short int CuiExportSerialNumber();
	short int CuiGetMaxNumberOfClients();
	short int CuiGetCurrentNumberOfClients();
	short int CuiGetMaxNumberOfTrx();
	short int CuiGetCurrentNumberOfTrx();
	short int CuiGetLastTrxResponse();
	short int CuiGetStartedTrxList();

	short int CuiAdmin();
	short int CuiAdminLogin();
	short int CuiAdminLogout();
	short int CuiUpdateTimeFirstTime();
	short int CuiUpdateTime();
	short int CuiUpdateTimeManually();
	short int CuiAdminSetTimeout();
	short int CuiAdminGetTimeout();

	short int CuiAdminEnableExportIfCspTestFails();
	short int CuiAdminDisableExportIfCspTestFails();
	short int CuiAdminSetUpForPrinter();

	short int CuiAdminGetExportDataArchive();
	short int CuiAdminGetExportDataFilterByTrx();
	short int CuiAdminGetExportDataFilterByTrxNoInterval();
	short int CuiAdminGetExportDataFilterByPeriod();
	short int CuiAdminFinalizeExport();
	short int CuiAdminCancelExportData();

	short int CuiAdminRegisterSecretKey();
	short int CuiAdminDisableSecureElement();
	short int CuiChangeUserPin();
	short int CuiAdminRegisterClient();
	short int CuiAdminDeregisterClient();
	short int CuiAdminUnlockTse();
	short int CuiAdminLockTse();

	short int CuiAdminGetAuthenticatedUserList();
	short int CuiAdminGetRegisteredClientList();

	short int CuiTimeAdmin();
	short int CuiTimeAdminLogin();
	short int CuiTimeAdminLogout();
	short int CuiTimeAdminStartTransaction();
	short int CuiTimeAdminUpdateTransaction();
	short int CuiTimeAdminFinishTransaction();

	short int CuiHost();
	short int CuiHostUnblockAdmin();
	short int CuiHostUnblockTimeAdmin();
	short int CuiHostChangePuk();

	bool IsAdminLogin();
	bool IsTimeAdminLogin(); 
	bool GetHexString(std::string hexString, std::vector<unsigned char> &binData);
};

//EOF