// Copyright 2020 Seiko Epson Corporation.
// Epson Europe
// EEB/RDC
// 2020/12  ka
// This Application is intended for demonstration purposes only and not for production environment.

#include "stdafx.h"
#include <iostream>
#include <sstream>
#include <string>
#include "EpsonTseLibCTester.h"
#include "../../Core/AccessMethod.h"
#include "../../Core/TSEOptions.h"
#include "../../Core/TSEUtil.h"
#include "CuiLibCTester.h"

#include "LoadEpsonTseDll.h"
#include "TSELogOptions.h"

#ifdef __TSE_USING_STATIC_LIB__
#ifdef _DEBUG
#ifdef _WIN64
#pragma comment (lib, "../x64/Debug_StaticLib/EpsonTseLibC64.lib")
#else
#pragma comment (lib, "../Debug_StaticLib/EpsonTseLibC.lib")
#endif
#else /*_DEBUG*/
#ifdef _WIN64
#pragma comment (lib, "../x64/Release_StaticLib/EpsonTseLibC64.lib")
#else
#pragma comment (lib, "../Release_StaticLib/EpsonTseLibC.lib")
#endif
#endif /*_DEBUG*/
#else /*__TSE_USING_STATIC_LIB__*/
#ifdef _WIN64
#define EPSON_TSE_LIB_C "./EpsonTseLibC64.dll"
#else
#define EPSON_TSE_LIB_C "./EpsonTseLibC.dll"
#endif
#endif /*__TSE_USING_STATIC_LIB__*/

EpsonTse_GetTseDeviceList				E_GetTseDeviceList;
EpsonTse_TSEConnect						E_TSEConnect;
EpsonTse_TSEDisconnect					E_TSEDisconnect;
EpsonTse_TSEOpenDevice					E_TSEOpenDevice;
EpsonTse_TSECloseDevice					E_TSECloseDevice;
EpsonTse_Setup							E_Setup;
EpsonTse_RunTSESelfTest					E_RunTSESelfTest;
EpsonTse_FactoryReset					E_FactoryReset;
EpsonTse_GetRawStorageInfo				E_GetRawStorageInfo;
EpsonTse_GetStorageInfo					E_GetStorageInfo;
EpsonTse_GetRawStorageSmartInfo			E_GetRawStorageSmartInfo;
EpsonTse_GetStorageSmartInfo			E_GetStorageSmartInfo;
EpsonTse_GetStartedTransactionList		E_GetStartedTransactionList;
EpsonTse_GetLastTransactionResponse		E_GetLastTransactionResponse;
EpsonTse_GetMaxNumberOfClients			E_GetMaxNumberOfClients;
EpsonTse_GetCurrentNumberOfClients		E_GetCurrentNumberOfClients;
EpsonTse_GetMaxNumberOfTransactions		E_GetMaxNumberOfTransactions;
EpsonTse_GetCurrentNumberOfTransactions E_GetCurrentNumberOfTransactions;
EpsonTse_ExportCertificate				E_ExportCertificate;
EpsonTse_ExportSerialNumber				E_ExportSerialNumber;
EpsonTse_AuthenticateUser				E_AuthenticateUser;
EpsonTse_LogOut							E_LogOut;
EpsonTse_ChangePin						E_ChangePin;
EpsonTse_UpdateTime						E_UpdateTime;
EpsonTse_DisableSecureElement			E_DisableSecureElement;
EpsonTse_RegisterTSEToHost				E_RegisterTSEToHost;
EpsonTse_RegisterSecretKey				E_RegisterSecretKey;
EpsonTse_RegisterClient					E_RegisterClient;
EpsonTse_DeregisterClient				E_DeregisterClient;
EpsonTse_LockTse						E_LockTse;
EpsonTse_UnlockTse						E_UnlockTse;
EpsonTse_EnableExportIfCspTestFails		E_EnableExportIfCspTestFails;
EpsonTse_DisableExportIfCspTestFails	E_DisableExportIfCspTestFails;
EpsonTse_SetTimeOutInterval				E_SetTimeOutInterval;
EpsonTse_GetTimeOutInterval				E_GetTimeOutInterval;
EpsonTse_GetAuthenticatedUserList		E_GetAuthenticatedUserList;
EpsonTse_GetRegisteredClientList		E_GetRegisteredClientList;
EpsonTse_StartTransaction				E_StartTransaction;
EpsonTse_UpdateTransaction				E_UpdateTransaction;
EpsonTse_FinishTransaction				E_FinishTransaction;
EpsonTse_ExportDataFilteredByTransactionNumberAndClientId			E_ExportDataFilteredByTransactionNumberAndClientId;
EpsonTse_ExportDataFilteredByTransactionNumber						E_ExportDataFilteredByTransactionNumber;
EpsonTse_ExportDataFilteredByTransactionNumberIntervalAndClientId	E_ExportDataFilteredByTransactionNumberIntervalAndClientId;
EpsonTse_ExportDataFilteredByTransactionNumberInterval				E_ExportDataFilteredByTransactionNumberInterval;
EpsonTse_ExportDataFilteredByPeriodOfTimeAndClientId				E_ExportDataFilteredByPeriodOfTimeAndClientId;
EpsonTse_ExportDataFilteredByPeriodOfTime							E_ExportDataFilteredByPeriodOfTime;
EpsonTse_ExportData						E_ExportData;
EpsonTse_FinalizeExport					E_FinalizeExport;
EpsonTse_CancelExport					E_CancelExport;
EpsonTse_ChangePuk						E_ChangePuk;
EpsonTse_UnblockUser					E_UnblockUser;
EpsonTse_TSEMemDealloc					E_TSEMemDealloc;
EpsonTse_TSEMemDeallocTseInfoObject		E_TSEMemDeallocTseInfoObject;
EpsonTse_TSESetLog						E_TSESetLog;
EpsonTse_TSEGetErrorDescription			E_TSEGetErrorDescription;

#ifdef __TSE_USING_STATIC_LIB__
bool LoadDLL_EpsonTseLibC()
{
	E_GetTseDeviceList = GetTseDeviceList;
	if (E_GetTseDeviceList == NULL)
	{
		return FALSE;
	}

	E_TSEConnect = TSEConnect;
	if (E_TSEConnect == NULL)
	{
		return FALSE;
	}

	E_TSEDisconnect = TSEDisconnect;
	if (E_TSEDisconnect == NULL)
	{
		return FALSE;
	}

	E_TSEOpenDevice = TSEOpenDevice;
	if (E_TSEOpenDevice == NULL)
	{
		return FALSE;
	}

	E_TSECloseDevice = TSECloseDevice;
	if (E_TSECloseDevice == NULL)
	{
		return FALSE;
	}

	E_Setup = Setup;
	if (E_Setup == NULL) {
		return FALSE;
	}

	E_RunTSESelfTest = RunTSESelfTest;
	if (E_RunTSESelfTest == NULL)
	{
		return FALSE;
	}

	E_FactoryReset = FactoryReset;
	if (E_FactoryReset == NULL)
	{
		return FALSE;
	}

	E_GetRawStorageInfo = GetRawStorageInfo;
	if (E_GetRawStorageInfo == NULL)
	{
		return FALSE;
	}

	E_GetStorageInfo = GetStorageInfo;
	if (E_GetStorageInfo == NULL)
	{
		return FALSE;
	}

	E_GetRawStorageSmartInfo = GetRawStorageSmartInfo;
	if (E_GetRawStorageSmartInfo == NULL)
	{
		return FALSE;
	}

	E_GetStorageSmartInfo = GetStorageSmartInfo;
	if (E_GetStorageSmartInfo == NULL)
	{
		return FALSE;
	}

	E_GetStartedTransactionList = GetStartedTransactionList;
	if (E_GetStartedTransactionList == NULL)
	{
		return FALSE;
	}

	E_GetLastTransactionResponse = GetLastTransactionResponse;
	if (E_GetLastTransactionResponse == NULL)
	{
		return FALSE;
	}

	E_GetMaxNumberOfClients = GetMaxNumberOfClients;
	if (E_GetMaxNumberOfClients == NULL)
	{
		return FALSE;
	}

	E_GetCurrentNumberOfClients = GetCurrentNumberOfClients;
	if (E_GetCurrentNumberOfClients == NULL)
	{
		return FALSE;
	}

	E_GetMaxNumberOfTransactions = GetMaxNumberOfTransactions;
	if (E_GetMaxNumberOfTransactions == NULL)
	{
		return FALSE;
	}

	E_GetCurrentNumberOfTransactions = GetCurrentNumberOfTransactions;
	if (E_GetCurrentNumberOfTransactions == NULL)
	{
		return FALSE;
	}

	E_ExportCertificate = ExportCertificate;
	if (E_ExportCertificate == NULL)
	{
		return FALSE;
	}

	E_ExportSerialNumber = ExportSerialNumber;
	if (E_ExportSerialNumber == NULL)
	{
		return FALSE;
	}

	E_AuthenticateUser = AuthenticateUser;
	if (E_AuthenticateUser == NULL)
	{
		return FALSE;
	}

	E_LogOut = LogOut;
	if (E_LogOut == NULL)
	{
		return FALSE;
	}

	E_ChangePin = ChangePin;
	if (E_ChangePin == NULL)
	{
		return FALSE;
	}

	E_UpdateTime = UpdateTime;
	if (E_UpdateTime == NULL)
	{
		return FALSE;
	}

	E_DisableSecureElement = DisableSecureElement;
	if (E_DisableSecureElement == NULL)
	{
		return FALSE;
	}

	E_RegisterTSEToHost = RegisterTSEToHost;
	if (E_RegisterTSEToHost == NULL)
	{
		return FALSE;
	}

	E_RegisterSecretKey = RegisterSecretKey;
	if (E_RegisterSecretKey == NULL)
	{
		return FALSE;
	}

	E_RegisterClient = RegisterClient;
	if (E_RegisterClient == NULL)
	{
		return FALSE;
	}

	E_DeregisterClient = DeregisterClient;
	if (E_DeregisterClient == NULL)
	{
		return FALSE;
	}

	E_LockTse = LockTse;
	if (E_LockTse == NULL)
	{
		return FALSE;
	}

	E_UnlockTse = UnlockTse;
	if (E_UnlockTse == NULL)
	{
		return FALSE;
	}

	E_EnableExportIfCspTestFails = EnableExportIfCspTestFails;
	if (E_EnableExportIfCspTestFails == NULL)
	{
		return FALSE;
	}

	E_DisableExportIfCspTestFails = DisableExportIfCspTestFails;
	if (E_DisableExportIfCspTestFails == NULL)
	{
		return FALSE;
	}

	E_SetTimeOutInterval = SetTimeOutInterval;
	if (E_SetTimeOutInterval == NULL)
	{
		return FALSE;
	}

	E_GetTimeOutInterval = GetTimeOutInterval;
	if (E_GetTimeOutInterval == NULL)
	{
		return FALSE;
	}

	E_GetAuthenticatedUserList = GetAuthenticatedUserList;
	if (E_GetAuthenticatedUserList == NULL)
	{
		return FALSE;
	}

	E_GetRegisteredClientList = GetRegisteredClientList;
	if (E_GetRegisteredClientList == NULL)
	{
		return FALSE;
	}

	E_StartTransaction = StartTransaction;
	if (E_StartTransaction == NULL)
	{
		return FALSE;
	}

	E_UpdateTransaction = UpdateTransaction;
	if (E_UpdateTransaction == NULL)
	{
		return FALSE;
	}

	E_FinishTransaction = FinishTransaction;
	if (E_FinishTransaction == NULL)
	{
		return FALSE;
	}

	E_ExportDataFilteredByTransactionNumberAndClientId = ExportDataFilteredByTransactionNumberAndClientId;
	if (E_ExportDataFilteredByTransactionNumberAndClientId == NULL)
	{
		return FALSE;
	}

	E_ExportDataFilteredByTransactionNumber = ExportDataFilteredByTransactionNumber;
	if (E_ExportDataFilteredByTransactionNumber == NULL)
	{
		return FALSE;
	}

	E_ExportDataFilteredByTransactionNumberIntervalAndClientId = ExportDataFilteredByTransactionNumberIntervalAndClientId;
	if (E_ExportDataFilteredByTransactionNumberIntervalAndClientId == NULL)
	{
		return FALSE;
	}

	E_ExportDataFilteredByTransactionNumberInterval = ExportDataFilteredByTransactionNumberInterval;
	if (E_ExportDataFilteredByTransactionNumberInterval == NULL)
	{
		return FALSE;
	}

	E_ExportDataFilteredByPeriodOfTimeAndClientId = ExportDataFilteredByPeriodOfTimeAndClientId;
	if (E_ExportDataFilteredByPeriodOfTimeAndClientId == NULL)
	{
		return FALSE;
	}

	E_ExportDataFilteredByPeriodOfTime =  ExportDataFilteredByPeriodOfTime;
	if (E_ExportDataFilteredByPeriodOfTime == NULL)
	{
		return FALSE;
	}

	E_ExportData = ExportData;
	if (E_ExportData == NULL)
	{
		return FALSE;
	}

	E_FinalizeExport = FinalizeExport;
	if (E_FinalizeExport == NULL)
	{
		return FALSE;
	}

	E_CancelExport = CancelExport;
	if (E_CancelExport == NULL)
	{
		return FALSE;
	}

	E_UnblockUser = UnblockUser;
	if (E_UnblockUser == NULL)
	{
		return FALSE;
	}

	E_ChangePuk = ChangePuk;
	if (E_ChangePuk == NULL)
	{
		return FALSE;
	}

	E_TSEMemDealloc = TSEMemDealloc;
	if (E_TSEMemDealloc == NULL)
	{
		return FALSE;
	}

	E_TSEMemDeallocTseInfoObject = TSEMemDeallocTseInfoObject;
	if (E_TSEMemDeallocTseInfoObject == NULL)
	{
		return FALSE;
	}

	E_TSESetLog = TSESetLog;
	if (E_TSESetLog == NULL)
	{
		return FALSE;
	}

	E_TSEGetErrorDescription = TSEGetErrorDescription;
	if (E_TSEGetErrorDescription == NULL)
	{
		return FALSE;
	}

	return TRUE;
}
#else /*__TSE_USING_STATIC_LIB__*/
bool LoadDLL_EpsonTseLibC()
{
	HINSTANCE hts = LoadLibrary(EPSON_TSE_LIB_C);
	if (hts == NULL)
	{
		return FALSE;
	}

	E_GetTseDeviceList = (EpsonTse_GetTseDeviceList)GetProcAddress(hts, "GetTseDeviceList");
	if (E_GetTseDeviceList == NULL)
	{
		return FALSE;
	}

	E_TSEConnect = (EpsonTse_TSEConnect)GetProcAddress(hts, "TSEConnect");
	if (E_TSEConnect == NULL)
	{
		return FALSE;
	}

	E_TSEDisconnect = (EpsonTse_TSEDisconnect)GetProcAddress(hts, "TSEDisconnect");
	if (E_TSEDisconnect == NULL)
	{
		return FALSE;
	}

	E_TSEOpenDevice = (EpsonTse_TSEOpenDevice)GetProcAddress(hts, "TSEOpenDevice");
	if (E_TSEOpenDevice == NULL)
	{
		return FALSE;
	}

	E_TSECloseDevice = (EpsonTse_TSECloseDevice)GetProcAddress(hts, "TSECloseDevice");
	if (E_TSECloseDevice == NULL)
	{
		return FALSE;
	}

	E_Setup = (EpsonTse_Setup)GetProcAddress(hts, "Setup");
	if (E_Setup == NULL) {
		return FALSE;
	}

	E_RunTSESelfTest = (EpsonTse_RunTSESelfTest)GetProcAddress(hts, "RunTSESelfTest");
	if (E_RunTSESelfTest == NULL)
	{
		return FALSE;
	}

	E_FactoryReset = (EpsonTse_FactoryReset)GetProcAddress(hts, "FactoryReset");
	if (E_FactoryReset == NULL)
	{
		return FALSE;
	}

	E_GetRawStorageInfo = (EpsonTse_GetRawStorageInfo)GetProcAddress(hts, "GetRawStorageInfo");
	if (E_GetRawStorageInfo == NULL)
	{
		return FALSE;
	}

	E_GetStorageInfo = (EpsonTse_GetStorageInfo)GetProcAddress(hts, "GetStorageInfo");
	if (E_GetStorageInfo == NULL)
	{
		return FALSE;
	}

	E_GetRawStorageSmartInfo = (EpsonTse_GetRawStorageSmartInfo)GetProcAddress(hts, "GetRawStorageSmartInfo");
	if (E_GetRawStorageSmartInfo == NULL)
	{
		return FALSE;
	}

	E_GetStorageSmartInfo = (EpsonTse_GetStorageSmartInfo)GetProcAddress(hts, "GetStorageSmartInfo");
	if (E_GetStorageSmartInfo == NULL)
	{
		return FALSE;
	}

	E_GetStartedTransactionList = (EpsonTse_GetStartedTransactionList)GetProcAddress(hts, "GetStartedTransactionList");
	if (E_GetStartedTransactionList == NULL)
	{
		return FALSE;
	}

	E_GetLastTransactionResponse = (EpsonTse_GetLastTransactionResponse)GetProcAddress(hts, "GetLastTransactionResponse");
	if (E_GetLastTransactionResponse == NULL)
	{
		return FALSE;
	}

	E_GetMaxNumberOfClients = (EpsonTse_GetMaxNumberOfClients)GetProcAddress(hts, "GetMaxNumberOfClients");
	if (E_GetMaxNumberOfClients == NULL)
	{
		return FALSE;
	}

	E_GetCurrentNumberOfClients = (EpsonTse_GetCurrentNumberOfClients)GetProcAddress(hts, "GetCurrentNumberOfClients");
	if (E_GetCurrentNumberOfClients == NULL)
	{
		return FALSE;
	}

	E_GetMaxNumberOfTransactions = (EpsonTse_GetMaxNumberOfTransactions)GetProcAddress(hts, "GetMaxNumberOfTransactions");
	if (E_GetMaxNumberOfTransactions == NULL)
	{
		return FALSE;
	}

	E_GetCurrentNumberOfTransactions = (EpsonTse_GetCurrentNumberOfTransactions)GetProcAddress(hts, "GetCurrentNumberOfTransactions");
	if (E_GetCurrentNumberOfTransactions == NULL)
	{
		return FALSE;
	}

	E_ExportCertificate = (EpsonTse_ExportCertificate)GetProcAddress(hts, "ExportCertificate");
	if (E_ExportCertificate == NULL)
	{
		return FALSE;
	}

	E_ExportSerialNumber = (EpsonTse_ExportSerialNumber)GetProcAddress(hts, "ExportSerialNumber");
	if (E_ExportSerialNumber == NULL)
	{
		return FALSE;
	}

	E_AuthenticateUser = (EpsonTse_AuthenticateUser)GetProcAddress(hts, "AuthenticateUser");
	if (E_AuthenticateUser == NULL)
	{
		return FALSE;
	}

	E_LogOut = (EpsonTse_LogOut)GetProcAddress(hts, "LogOut");
	if (E_LogOut == NULL)
	{
		return FALSE;
	}

	E_ChangePin = (EpsonTse_ChangePin)GetProcAddress(hts, "ChangePin");
	if (E_ChangePin == NULL)
	{
		return FALSE;
	}

	E_UpdateTime = (EpsonTse_UpdateTime)GetProcAddress(hts, "UpdateTime");
	if (E_UpdateTime == NULL)
	{
		return FALSE;
	}

	E_DisableSecureElement = (EpsonTse_DisableSecureElement)GetProcAddress(hts, "DisableSecureElement");
	if (E_DisableSecureElement == NULL)
	{
		return FALSE;
	}

	E_RegisterTSEToHost = (EpsonTse_RegisterTSEToHost)GetProcAddress(hts, "RegisterTSEToHost");
	if (E_RegisterTSEToHost == NULL)
	{
		return FALSE;
	}

	E_RegisterSecretKey = (EpsonTse_RegisterSecretKey)GetProcAddress(hts, "RegisterSecretKey");
	if (E_RegisterSecretKey == NULL)
	{
		return FALSE;
	}

	E_RegisterClient = (EpsonTse_RegisterClient)GetProcAddress(hts, "RegisterClient");
	if (E_RegisterClient == NULL)
	{
		return FALSE;
	}

	E_DeregisterClient = (EpsonTse_DeregisterClient)GetProcAddress(hts, "DeregisterClient");
	if (E_DeregisterClient == NULL)
	{
		return FALSE;
	}

	E_LockTse = (EpsonTse_LockTse)GetProcAddress(hts, "LockTse");
	if (E_LockTse == NULL)
	{
		return FALSE;
	}

	E_UnlockTse = (EpsonTse_UnlockTse)GetProcAddress(hts, "UnlockTse");
	if (E_UnlockTse == NULL)
	{
		return FALSE;
	}

	E_EnableExportIfCspTestFails = (EpsonTse_EnableExportIfCspTestFails)GetProcAddress(hts, "EnableExportIfCspTestFails");
	if (E_EnableExportIfCspTestFails == NULL)
	{
		return FALSE;
	}

	E_DisableExportIfCspTestFails = (EpsonTse_DisableExportIfCspTestFails)GetProcAddress(hts, "DisableExportIfCspTestFails");
	if (E_DisableExportIfCspTestFails == NULL)
	{
		return FALSE;
	}

	E_SetTimeOutInterval = (EpsonTse_SetTimeOutInterval)GetProcAddress(hts, "SetTimeOutInterval");
	if (E_SetTimeOutInterval == NULL)
	{
		return FALSE;
	}

	E_GetTimeOutInterval = (EpsonTse_GetTimeOutInterval)GetProcAddress(hts, "GetTimeOutInterval");
	if (E_GetTimeOutInterval == NULL)
	{
		return FALSE;
	}

	E_GetAuthenticatedUserList = (EpsonTse_GetAuthenticatedUserList)GetProcAddress(hts, "GetAuthenticatedUserList");
	if (E_GetAuthenticatedUserList == NULL)
	{
		return FALSE;
	}

	E_GetRegisteredClientList = (EpsonTse_GetRegisteredClientList)GetProcAddress(hts, "GetRegisteredClientList");
	if (E_GetRegisteredClientList == NULL)
	{
		return FALSE;
	}

	E_StartTransaction = (EpsonTse_StartTransaction)GetProcAddress(hts, "StartTransaction");
	if (E_StartTransaction == NULL)
	{
		return FALSE;
	}

	E_UpdateTransaction = (EpsonTse_UpdateTransaction)GetProcAddress(hts, "UpdateTransaction");
	if (E_UpdateTransaction == NULL)
	{
		return FALSE;
	}

	E_FinishTransaction = (EpsonTse_FinishTransaction)GetProcAddress(hts, "FinishTransaction");
	if (E_FinishTransaction == NULL)
	{
		return FALSE;
	}

	E_ExportDataFilteredByTransactionNumberAndClientId =
		(EpsonTse_ExportDataFilteredByTransactionNumberAndClientId)GetProcAddress(hts, "ExportDataFilteredByTransactionNumberAndClientId");
	if (E_ExportDataFilteredByTransactionNumberAndClientId == NULL)
	{
		return FALSE;
	}

	E_ExportDataFilteredByTransactionNumber =
		(EpsonTse_ExportDataFilteredByTransactionNumber)GetProcAddress(hts, "ExportDataFilteredByTransactionNumber");
	if (E_ExportDataFilteredByTransactionNumber == NULL)
	{
		return FALSE;
	}

	E_ExportDataFilteredByTransactionNumberIntervalAndClientId =
		(EpsonTse_ExportDataFilteredByTransactionNumberIntervalAndClientId)GetProcAddress(hts, "ExportDataFilteredByTransactionNumberIntervalAndClientId");
	if (E_ExportDataFilteredByTransactionNumberIntervalAndClientId == NULL)
	{
		return FALSE;
	}

	E_ExportDataFilteredByTransactionNumberInterval =
		(EpsonTse_ExportDataFilteredByTransactionNumberInterval)GetProcAddress(hts, "ExportDataFilteredByTransactionNumberInterval");
	if (E_ExportDataFilteredByTransactionNumberInterval == NULL)
	{
		return FALSE;
	}

	E_ExportDataFilteredByPeriodOfTimeAndClientId =
		(EpsonTse_ExportDataFilteredByPeriodOfTimeAndClientId)GetProcAddress(hts, "ExportDataFilteredByPeriodOfTimeAndClientId");
	if (E_ExportDataFilteredByPeriodOfTimeAndClientId == NULL)
	{
		return FALSE;
	}

	E_ExportDataFilteredByPeriodOfTime =
		(EpsonTse_ExportDataFilteredByPeriodOfTime)GetProcAddress(hts, "ExportDataFilteredByPeriodOfTime");
	if (E_ExportDataFilteredByPeriodOfTime == NULL)
	{
		return FALSE;
	}

	E_ExportData = (EpsonTse_ExportData)GetProcAddress(hts, "ExportData");
	if (E_ExportData == NULL)
	{
		return FALSE;
	}

	E_FinalizeExport = (EpsonTse_FinalizeExport)GetProcAddress(hts, "FinalizeExport");
	if (E_FinalizeExport == NULL)
	{
		return FALSE;
	}

	E_CancelExport = (EpsonTse_CancelExport)GetProcAddress(hts, "CancelExport");
	if (E_CancelExport == NULL)
	{
		return FALSE;
	}

	E_UnblockUser = (EpsonTse_UnblockUser)GetProcAddress(hts, "UnblockUser");
	if (E_UnblockUser == NULL)
	{
		return FALSE;
	}

	E_ChangePuk = (EpsonTse_ChangePuk)GetProcAddress(hts, "ChangePuk");
	if (E_ChangePuk == NULL)
	{
		return FALSE;
	}

	E_TSEMemDealloc = (EpsonTse_TSEMemDealloc)GetProcAddress(hts, "TSEMemDealloc");
	if (E_TSEMemDealloc == NULL)
	{
		return FALSE;
	}

	E_TSEMemDeallocTseInfoObject = (EpsonTse_TSEMemDeallocTseInfoObject)GetProcAddress(hts, "TSEMemDeallocTseInfoObject");
	if (E_TSEMemDeallocTseInfoObject == NULL)
	{
		return FALSE;
	}

	E_TSESetLog = (EpsonTse_TSESetLog)GetProcAddress(hts, "TSESetLog");
	if (E_TSESetLog == NULL)
	{
		return FALSE;
	}

	E_TSEGetErrorDescription = (EpsonTse_TSEGetErrorDescription)GetProcAddress(hts, "TSEGetErrorDescription");
	if (E_TSEGetErrorDescription == NULL)
	{
		return FALSE;
	}

	return TRUE;
}
#endif /*__TSE_USING_STATIC_LIB__*/

void PrintUsage(char * TExeName)
{
	std::cout << "Usage:" << std::endl;
	std::cout << "      " << TExeName << "  <required> <optional>" << std::endl;
	std::cout << std::endl;
	std::cout << "[Required]" << std::endl;
	std::cout << "  -mX: X=<Access Method>. Default is -m" << ACCESS_BY_SERIAL_ESCPOS << "." << std::endl;
	std::cout << "    " << ACCESS_BY_SERIAL_ESCPOS << " :ACCESS_BY_SERIAL_ESCPOS" << std::endl;
	std::cout << "    " << ACCESS_BY_NETWORK_ESCPOS << " :ACCESS_BY_NETWORK_ESCPOS" << std::endl;
	std::cout << "    " << ACCESS_BY_EPOS_DEVICE << " :ACCESS_BY_EPOS_DEVICE_XML" << std::endl;
#ifdef EPSON_TSE_PCS_SUPPORT
	std::cout << "    " << ACCESS_BY_PCS_ESCPOS << " :ACCESS_BY_PCS_ESCPOS" << std::endl;
#endif /*EPSON_TSE_PCS_SUPPORT*/
	std::cout << "  -iX: X=<Port Identifier> (COM port/IP Address) e.g. -iCOM1, -i192.168.1.132" << std::endl;
	std::cout << std::endl;
	std::cout << "[Optional]" << std::endl;
	std::cout << "  -tX: X=<TSE Handle>. Default is \"local_TSE\"" << std::endl;
	std::cout << "[Optional - for setting logs]" << std::endl;
	std::cout << "  -wX: X=<Log level>." << std::endl;
	std::cout << "    0: Disabled, 1: Error, 2: Warning, 3: Info," << std::endl;
	std::cout << "    4: Trace, 5: Verbose" << std::endl;
	std::cout << "  -x1: Enable logging on DebugViewer." << std::endl;
	std::cout << "  -y1: Enable logging on File." << std::endl;
	std::cout << "  -z1: Enable logging on Standard Output." << std::endl;
	std::cout << std::endl;
	std::cout << "e.g.: " << TExeName << "  -m0   -iCOM1	           " << std::endl;
	std::cout << "      " << TExeName << "  -m1   -i192.168.192.168    " << std::endl;
	std::cout << "      " << TExeName << "  -m2   -i192.168.192.168    -tTSE1_xxxx" << std::endl;
#ifdef EPSON_TSE_PCS_SUPPORT
	std::cout << "      " << TExeName << "  -m3   -iESDPRT001" << std::endl;
#endif /*EPSON_TSE_PCS_SUPPORT*/
	std::cout << "[To get the list of TSE devices connected to a server]" << std::endl;
	std::cout << "      " << TExeName << "  -m2   -i<server's ip address>" << std::endl;
}

void ShowOptions(const TSEOptions& tTseOpt, const std::string& tIgnoredParam)
{
#ifdef EPSON_TSE_PCS_SUPPORT
	std::string method[4];
	method[ACCESS_BY_SERIAL_ESCPOS] = "ACCESS_BY_SERIAL_ESCPOS";
	method[ACCESS_BY_NETWORK_ESCPOS] = "ACCESS_BY_NETWORK_ESCPOS";
	method[ACCESS_BY_EPOS_DEVICE] = "ACCESS_BY_EPOS_DEVICE";
	method[ACCESS_BY_PCS_ESCPOS] = "ACCESS_BY_PCS_ESCPOS";
#else /*EPSON_TSE_PCS_SUPPORT*/
	std::string method[3];
	method[ACCESS_BY_SERIAL_ESCPOS] = "ACCESS_BY_SERIAL_ESCPOS";
	method[ACCESS_BY_NETWORK_ESCPOS] = "ACCESS_BY_NETWORK_ESCPOS";
	method[ACCESS_BY_EPOS_DEVICE] = "ACCESS_BY_EPOS_DEVICE";
#endif /*EPSON_TSE_PCS_SUPPORT*/

	std::stringstream sLogAll;
	sLogAll << "VERSION: " << EPSONTSELIBCTESTER_VERSION_S << std::endl;
	sLogAll << "[PARAMETERS SELECTED]" << std::endl;
	sLogAll << "Method: " << method[tTseOpt.mMethod] << std::endl;
	sLogAll << "Device ID: " << tTseOpt.mIdentifier << std::endl;
	sLogAll << "TSE Handle: " << tTseOpt.mTseHandler << std::endl << std::endl;

	if (tIgnoredParam != "")
	{
		sLogAll << "[IGNORED PARAMETERS]" << std::endl;
		sLogAll << tIgnoredParam;
	}
}

bool GetOptions(int tOptCount, char **tOptArg, TSEOptions& tTseOpt, TSELogOptions& tTseLog, short int &tLang, std::string& tIgnoredParam)
{
	std::stringstream ignoredParam;
	if (tOptCount < 3)
	{
		return false;
	}

	for (int i = 1; i < tOptCount; i++)
	{
		if (tOptArg[i][0] != '-')
		{
			ignoredParam << tOptArg[i] << " is not a valid parameter." << std::endl;
			continue;
		}

		if (strlen(tOptArg[i]) <= 2)
		{
			ignoredParam << tOptArg[i] << " is not a valid parameter." << std::endl;
			continue;
		}

		switch (tOptArg[i][1])
		{
			case 'm':
			{
				unsigned short nMethod = tOptArg[i][2] - '0';
				if ((nMethod != ACCESS_BY_SERIAL_ESCPOS) &&
					(nMethod != ACCESS_BY_NETWORK_ESCPOS) &&
#ifdef EPSON_TSE_PCS_SUPPORT
					(nMethod != ACCESS_BY_PCS_ESCPOS) &&
#endif /*EPSON_TSE_PCS_SUPPORT*/
					(nMethod != ACCESS_BY_EPOS_DEVICE)) 
				{
					return false;
				}
				tTseOpt.mMethod = nMethod;
				break;
			}
			case 'i': tTseOpt.mIdentifier = (char *)(tOptArg[i] + 2);  break;
			case 't': tTseOpt.mTseHandler = (char *)(tOptArg[i] + 2);  break;
			case 'l': tLang = ((tOptArg[i][2] == '1') ? 1 : 0);  break;
			
			case 'w': tTseLog.mLogLevel = tOptArg[i][2] - '0';  break;
			case 'x': tTseLog.mLogMethod |= ((tOptArg[i][2] == '1') ? (1<<0) : 0);  break;
			case 'y': tTseLog.mLogMethod |= ((tOptArg[i][2] == '1') ? (1<<1) : 0);  break;
			case 'z': tTseLog.mLogMethod |= ((tOptArg[i][2] == '1') ? (1<<2) : 0);  break;
			
			default:
			{
				ignoredParam << tOptArg[i] << " is not a valid parameter." << std::endl;
			}
		}
	}

	if (tTseOpt.mIdentifier == "") return false;

	tIgnoredParam = ignoredParam.str();
	return true;
}

int __cdecl main(int argc, char **argv)
{
	TSEOptions tseOpt;
	TSELogOptions tseLog;
	std::string ignoredParam = "";
	bool isShowMenu = true;
	short int errorLang = 0;

	if (GetOptions(argc, argv, tseOpt, tseLog, errorLang, ignoredParam) == false)
	{
		PrintUsage(argv[0]);
		return -1;
	}

	ShowOptions(tseOpt, ignoredParam);

	if (LoadDLL_EpsonTseLibC() == FALSE)
	{
		std::cout << "Could not load library file" << std::endl;
		return -1;
	}

	E_TSESetLog(tseLog.mLogLevel, tseLog.mLogMethod);

	while (isShowMenu)
	{
		CuiLibCTester tseCui;
		tseCui.SetErrorDescLanguage(errorLang);
		if ((tseOpt.mTseHandler == "") && (tseOpt.mMethod == ACCESS_BY_EPOS_DEVICE))
		{
			if (tseCui.CuiGetTseId(tseOpt.mIdentifier, tseOpt.mTseHandler) != true)
			{
				break;
			}

			if (tseOpt.mTseHandler == "bye")
			{
				break;
			}
		}
		else
		{
			if (tseOpt.mTseHandler == "")
			{
				tseOpt.mTseHandler = "local_TSE";
			}
			if (tseCui.ConnectToTse(tseOpt) != true)
			{
				break;
			}
			isShowMenu = tseCui.ShowMenu();
			tseCui.DisconnectFromTse();
		}
	}
	return 0;
}

//EOF
