// Copyright 2020 Seiko Epson Corporation.
// Epson Europe
// EEB/RDC
// 2020/09  ka
// This Application is intended for demonstration purposes only and not for production environment.

#pragma once
#include <windows.h>
#include "../Include/EpsonTseLibC.h"

#ifdef __TSE_USING_STDCALL_DLL__
#define TSEAPI __stdcall
#else
#define TSEAPI __cdecl
#endif

typedef short int (TSEAPI*  EpsonTse_GetTseDeviceList)(
	/*in*/  unsigned char		*ipAddress,
	/*in*/  unsigned long int	ipAddressLength,
	/*out*/ unsigned char		**tseDeviceList,
	/*out*/ unsigned long int	*tseDeviceListSize);

typedef short int (TSEAPI*  EpsonTse_TSEConnect)(
	/*in*/  unsigned short		method,
	/*in*/  unsigned char		*portId,
	/*in*/  unsigned long int	portIdLength,
	/*in*/  unsigned char		*tseId,
	/*in*/  unsigned long int	tseIdLength);

typedef short int (TSEAPI*  EpsonTse_TSEDisconnect)();

typedef short int (TSEAPI*  EpsonTse_TSEOpenDevice)();

typedef short int (TSEAPI*  EpsonTse_TSECloseDevice)();

typedef short int (TSEAPI*  EpsonTse_Setup)(
	/*in*/  unsigned char		*adminPin,
	/*in*/  unsigned long int	adminPinLength,
	/*in*/  unsigned char		*clientIdPin,
	/*in*/  unsigned long int	clientIdPinLength,
	/*in*/  unsigned char		*puk,
	/*in*/  unsigned long int	pukLength);

typedef short int (TSEAPI*  EpsonTse_FactoryReset)();

typedef short int (TSEAPI*  EpsonTse_GetRawStorageInfo)(
	/*out*/ unsigned char		**rawTseInfo,
	/*out*/ unsigned long int	*rawTseInfoLength);

typedef short int (TSEAPI*  EpsonTse_GetStorageInfo)(
	/*out*/ EPSON_TSE_INFO		*tseInfo);

typedef short int (TSEAPI*  EpsonTse_GetRawStorageSmartInfo)(
	/*out*/ unsigned char		**rawSmartInfo,
	/*out*/ unsigned long int	*rawSmartInfoLength);

typedef short int (TSEAPI*  EpsonTse_GetStorageSmartInfo)(
	/*out*/ EPSON_TSE_SMART_INFO *smartInfo);

typedef short int (TSEAPI*  EpsonTse_RunTSESelfTest)();

typedef short int (TSEAPI*  EpsonTse_GetStartedTransactionList)(
	/*in*/  unsigned char		*clientId,
	/*in*/  unsigned long int	clientIdLength,
	/*out*/ unsigned long int	**startedTransactionList,
	/*out*/ unsigned long int	*startedTransactionListLength);

typedef short int (TSEAPI*  EpsonTse_GetLastTransactionResponse)(
	/*in*/  unsigned char		*clientId,
	/*in*/  unsigned long int	clientIdLength,
	/*out*/ unsigned long int	*transactionNumber,
	/*out*/ unsigned long int	*logTime,
	/*out*/ unsigned long int	*signatureCounter,
	/*out*/ unsigned char		**signatureValue,
	/*out*/ unsigned long int	*signatureValueLength,
	/*out*/ unsigned char		**serialNumber,
	/*out*/ unsigned long int	*serialNumberLength);

typedef short int (TSEAPI*  EpsonTse_GetMaxNumberOfClients)(
	/*out*/ unsigned long int	*maxNumberClients);

typedef short int (TSEAPI*  EpsonTse_GetCurrentNumberOfClients)(
	/*out*/ unsigned long int	*currentNumberClients);

typedef short int (TSEAPI*  EpsonTse_GetMaxNumberOfTransactions)(
	/*out*/ unsigned long int	*maxNumberTransactions);

typedef short int (TSEAPI*  EpsonTse_GetCurrentNumberOfTransactions)(
	/*out*/ unsigned long int	*currentNumberTransactions);

typedef short int (TSEAPI*  EpsonTse_ExportCertificate)(
	/*out*/ unsigned char		**certificate,
	/*out*/ unsigned long int	*certificateLength);

typedef short int (TSEAPI*  EpsonTse_ExportSerialNumber)(
	/*out*/ unsigned char		**serialNumber,
	/*out*/ unsigned long int	*serialNumberLength);

typedef short int (TSEAPI*  EpsonTse_AuthenticateUser)(
	/*in*/  unsigned char		*userId,
	/*in*/  unsigned long int	userIdLength,
	/*in*/  unsigned char		*pin,
	/*in*/  unsigned long int	pinLength,
	/*in*/  unsigned char		*secretKey,
	/*in*/  unsigned long int	secretKeyLength,
	/*out*/  short int			*remainingRetries);

typedef short int (TSEAPI*  EpsonTse_LogOut)(
	/*in*/  unsigned char		*userId,
	/*in*/  unsigned long int	userIdLength);

typedef short int (TSEAPI*  EpsonTse_ChangePin)(
	/*in*/  unsigned char		*userId,
	/*in*/  unsigned long int	userIdLength,
	/*in*/  unsigned char		*oldPin,
	/*in*/  unsigned long int	oldPinLength,
	/*in*/  unsigned char		*newPin,
	/*in*/  unsigned long int	newPinLength,
	/*out*/ short int			*remainingRetries);

typedef short int (TSEAPI*  EpsonTse_UpdateTime)(
	/*in*/  unsigned char		*userId,
	/*in*/  unsigned long int	userIdLength,
	/*in*/  unsigned long int	newDateTime,
	/*in*/  bool				updateForFirstTime);

typedef short int (TSEAPI*  EpsonTse_DisableSecureElement)();

typedef short int (TSEAPI*  EpsonTse_RegisterTSEToHost)();

typedef short int (TSEAPI*  EpsonTse_RegisterSecretKey)(
	/*in*/  unsigned char		*secretKey,
	/*in*/  unsigned long int	secretKeyLength);

typedef short int (TSEAPI*  EpsonTse_RegisterClient)(
	/*in*/  unsigned char		*newClientId,
	/*in*/  unsigned long int	newClientIdLength);

typedef short int (TSEAPI*  EpsonTse_DeregisterClient)(
	/*in*/  unsigned char		*clientId,
	/*in*/  unsigned long int	clientIdLength);

typedef short int (TSEAPI*  EpsonTse_LockTse)();

typedef short int (TSEAPI*  EpsonTse_UnlockTse)();

typedef short int (TSEAPI*  EpsonTse_EnableExportIfCspTestFails)();

typedef short int (TSEAPI*  EpsonTse_DisableExportIfCspTestFails)();

typedef short int (TSEAPI*  EpsonTse_SetTimeOutInterval)(
	/*in*/  unsigned long int	timeoutIntervalForAdmin,
	/*in*/  unsigned long int	timeoutIntervalForTimeAdmin,
	/*in*/  unsigned long int	timeoutIntervalForExport);

typedef short int (TSEAPI*  EpsonTse_GetTimeOutInterval)(
	/*out*/ unsigned long int	*timeoutIntervalForAdmin,
	/*out*/ unsigned long int	*timeoutIntervalForTimeAdmin,
	/*out*/ unsigned long int	*timeoutIntervalForExport);

typedef short int (TSEAPI*  EpsonTse_GetAuthenticatedUserList)(
	/*in*/  unsigned char		*userRole,
	/*in*/  unsigned long int	userRoleLength,
	/*out*/ unsigned char		**AuthenticatedUserList,
	/*out*/ unsigned long int	*AuthenticatedUserListLength);

typedef short int (TSEAPI*  EpsonTse_GetRegisteredClientList)(
	/*out*/ unsigned char		**registeredClientList,
	/*out*/ unsigned long int	*registeredClientListLength);

typedef short int (TSEAPI*  EpsonTse_StartTransaction)(
	/*in*/  unsigned char		*clientId,
	/*in*/  unsigned long int	clientIdLength,
	/*in*/  unsigned char		*processData,
	/*in*/  unsigned long int	processDataLength,
	/*in*/  unsigned char		*processType,
	/*in*/  unsigned long int	processTypeLength,
	/*in*/  unsigned char		*additionalData,
	/*in*/  unsigned long int	additionalDataLength,
	/*out*/ unsigned long int	*transactionNumber,
	/*out*/ unsigned long int	*logTime,
	/*out*/ unsigned char		**serialNumber,
	/*out*/ unsigned long int	*serialNumberLength,
	/*out*/ unsigned long int	*signatureCounter,
	/*out*/ unsigned char		**signatureValue,
	/*out*/ unsigned long int	*signatureValueLength);

typedef short int (TSEAPI*  EpsonTse_UpdateTransaction)(
	/*in*/  unsigned char		*clientId,
	/*in*/  unsigned long int	clientIdLength,
	/*in*/  unsigned long int	transactionNumber,
	/*in*/  unsigned char		*processData,
	/*in*/  unsigned long int	processDataLength,
	/*in*/  unsigned char		*processType,
	/*in*/  unsigned long int	processTypeLength,
	/*out*/ unsigned long int	*logTime,
	/*out*/ unsigned char		**signatureValue,
	/*out*/ unsigned long int	*signatureValueLength,
	/*out*/ unsigned long int	*signatureCounter);

typedef short int (TSEAPI*  EpsonTse_FinishTransaction)(
	/*in*/  unsigned char		*clientId,
	/*in*/  unsigned long int	clientIdLength,
	/*in*/  unsigned long int	transactionNumber,
	/*in*/  unsigned char		*processData,
	/*in*/  unsigned long int	processDataLength,
	/*in*/  unsigned char		*processType,
	/*in*/  unsigned long int	processTypeLength,
	/*in*/  unsigned char		*additionalData,
	/*in*/  unsigned long int	additionalDataLength,
	/*out*/ unsigned long int	*logTime,
	/*out*/ unsigned char		**signatureValue,
	/*out*/ unsigned long int	*signatureValueLength,
	/*out*/ unsigned long int	*signatureCounter);

typedef short int (TSEAPI*  EpsonTse_ExportDataFilteredByTransactionNumberAndClientId)(
	/*in*/  unsigned long int	transactionNumber,
	/*in*/  unsigned char		*clientId,
	/*in*/  unsigned long int	clientIdLength,
	/*out*/ unsigned char		**exportedData,
	/*out*/ unsigned long int	*exportedDataLength);

typedef short int (TSEAPI*  EpsonTse_ExportDataFilteredByTransactionNumber)(
	/*in*/  unsigned long int	transactionNumber,
	/*out*/ unsigned char		**exportedData,
	/*out*/ unsigned long int	*exportedDataLength);

typedef short int (TSEAPI*  EpsonTse_ExportDataFilteredByTransactionNumberIntervalAndClientId)(
	/*in*/  unsigned long int	startTransactionNumber,
	/*in*/  unsigned long int	endTransactionNumber,
	/*in*/  unsigned char		*clientId,
	/*in*/  unsigned long int	clientIdLength,
	/*out*/ unsigned char		**exportedData,
	/*out*/ unsigned long int	*exportedDataLength);

typedef short int (TSEAPI*  EpsonTse_ExportDataFilteredByTransactionNumberInterval)(
	/*in*/  unsigned long int	startTransactionNumber,
	/*in*/  unsigned long int	endTransactionNumber,
	/*out*/ unsigned char		**exportedData,
	/*out*/ unsigned long int	*exportedDataLength);

typedef short int (TSEAPI*  EpsonTse_ExportDataFilteredByPeriodOfTimeAndClientId)(
	/*in*/  unsigned long int	startDate,
	/*in*/  unsigned long int	endDate,
	/*in*/  unsigned char		*clientId,
	/*in*/  unsigned long int	clientIdLength,
	/*out*/ unsigned char		**exportedData,
	/*out*/ unsigned long int	*exportedDataLength);

typedef short int (TSEAPI*  EpsonTse_ExportDataFilteredByPeriodOfTime)(
	/*in*/  unsigned long int	startDate,
	/*in*/  unsigned long int	endDate,
	/*out*/ unsigned char		**exportedData,
	/*out*/ unsigned long int	*exportedDataLength);

typedef short int (TSEAPI*  EpsonTse_ExportData)(
	/*out*/ unsigned char		**exportedData,
	/*out*/ unsigned long int	*exportedDataLength);

typedef short int (TSEAPI*  EpsonTse_FinalizeExport)(
	/*in*/  bool				deleteStoredData);

typedef short int (TSEAPI*  EpsonTse_CancelExport)();

typedef short int (TSEAPI*  EpsonTse_ChangePuk)(
	/*in*/  unsigned char		*oldPuk,
	/*in*/  unsigned long int	oldPukLength,
	/*in*/  unsigned char		*newPuk,
	/*in*/  unsigned long int	newPukLength,
	/*in*/  unsigned char		*secretKey,
	/*in*/  unsigned long int	secretKeyLength,
	/*out*/ short int			*remainingRetries);

typedef short int (TSEAPI*  EpsonTse_UnblockUser)(
	/*in*/  unsigned char		*userId,
	/*in*/  unsigned long int	userIdLength,
	/*in*/  unsigned char		*puk,
	/*in*/  unsigned long int	pukLength,
	/*in*/  unsigned char		*newPin,
	/*in*/  unsigned long int	newPinLength,
	/*in*/  unsigned char		*secretKey,
	/*in*/  unsigned long int	secretKeyLength,
	/*out*/  short int			*remainingRetries);

typedef void (TSEAPI*  EpsonTse_TSEMemDealloc)(
	/*out*/ void				*memoryAddress);

typedef void (TSEAPI*  EpsonTse_TSEMemDeallocTseInfoObject)(
	/*out*/ EPSON_TSE_INFO		*tseInfo);

typedef void (TSEAPI*  EpsonTse_TSESetLog)(
	/*in*/  unsigned short int	logLevel,
	/*in*/  unsigned short int	logMethod);

typedef void (TSEAPI*  EpsonTse_TSEGetErrorDescription)(
	/*in*/  short int			errorCode,
	/*in*/  short int			language,
	/*out*/ unsigned char		errorDescription[100]);

/*EOF*/