// Copyright 2019-2020 Seiko Epson Corporation.
// Epson Europe
// EEB/RDC
// 2020/11  ka
// This Application is intended for demonstration purposes only and not for production environment.

#pragma once
#include <string>
#include <fstream>
#include <vector>
#include "AccessMethod.h"

#define DEFAULT_PRINT_LOG		true

class TSEAccess
{
public:
	virtual ~TSEAccess() {};
	virtual bool EnableTseAccess() = 0;
	virtual void SendJsonStringToTse(const std::string& tJsonStr, std::string& tResponse) = 0;
	virtual bool DisableTseAccess() = 0;
	virtual void SetTseDeviceId(const std::string &tTseDevId);
	unsigned long GetTotalTime();
	unsigned long GetLastRcvTime();

protected:
	std::string mDeviceId;	
	std::string mTseDevId;
	unsigned long mTotalTime;
	unsigned long mTotalRcvTime;

	void SendMsg(const std::vector<unsigned char>& tBuffer);
	void RecvMsg(std::vector<unsigned char>& tBuffer, const unsigned long& tMaxSize, const unsigned long& tTimeout, unsigned long& tTimeSpent);

	virtual void SendTo(const std::vector<unsigned char>& tBuffer) = 0;
	virtual void RecvFrom(std::vector<unsigned char>& tBuffer, const unsigned long& tMaxSize, const unsigned long& tTimeout) = 0;

};

//EOF