// Copyright 2020 Seiko Epson Corporation.
// Epson Europe
// EEB/RDC
// 2020/07  ka
// This Application is intended for demonstration purposes only and not for production environment.

#include "stdafx.h"
#include <fstream>
#include <sstream>
#include "TSEConfig.h"
#include "TSEUtil.h"

#define TSECLIBDATAPATH				"\\EPSON\\TSE\\CLIB\\"
#define TSECONFIGFILENAME			"EpsonTseLibConf.conf"

TSEConfig::TSEConfig()
{
	std::string progdatapath = TSEUtil::GetProgramDataPath();
	if (progdatapath == "")
	{
		mIsConfigExist = false;
	}
	else
	{
		struct stat info;
		mConfigFile = progdatapath + TSECLIBDATAPATH + TSECONFIGFILENAME;

		mIsConfigExist = false;

		if (stat(mConfigFile.c_str(), &info) == 0)
		{
			if (info.st_mode & _S_IFREG)
			{
				mIsConfigExist = true; /*Config file exists*/
			}
		}
	}

	mInitConnectRetry = 0;
	mLogFileSize = 0;
	mEposDeviceXmlPort = "";
	if (mIsConfigExist == true)
	{
		std::ifstream confFile(mConfigFile);
		if (!confFile.good())
		{
			mIsConfigExist = false;
			return;
		}
		std::string line;
		while (std::getline(confFile, line))
		{
			if (line == "")
			{
				continue;
			}

			std::string delimiter = "=";
			std::string confParam = "";
			std::string confValue = "";

			confParam = line.substr(0, line.find(delimiter));
			confValue = line.substr(line.find(delimiter) + 1, line.length());

			if (confParam == "INIT_CONNECTION_ATTEMPT")
			{
				if (TSEUtil::IsNumber(confValue))
				{
					mInitConnectRetry = std::stoi(confValue);
					if (mInitConnectRetry > 10)
					{
						mInitConnectRetry = 0;
					}
				}

			}
			else if (confParam == "LOGFILE_CHECKSIZE")
			{
				if (TSEUtil::IsNumber(confValue))
				{
					mLogFileSize = std::stoi(confValue);
					if (mLogFileSize < 1000)
					{
						mLogFileSize = 0;
					}
				}
			}
			else if (confParam == "EPOS_DEVICE_XML_PORT")
			{
				if (TSEUtil::IsNumber(confValue))
				{
					mEposDeviceXmlPort = confValue;
				}
			}
			else{/*nothing*/}
		} //while
		confFile.close();
	}
}

bool TSEConfig::GetInitConnectRetry(unsigned short &tNum)
{
	if ((mIsConfigExist == false) || (mInitConnectRetry == 0))
	{
		tNum = 0;
		return false;
	}

	tNum = mInitConnectRetry;
	return true;
}

bool TSEConfig::GetLogFileSize(unsigned long &tNum)
{
	if ((mIsConfigExist == false) || (mLogFileSize == 0))
	{
		tNum = 0;
		return false;
	}

	tNum = mLogFileSize;
	return true;
}

bool TSEConfig::GetEposDeviceXmlPort(std::string &tPort)
{
	if ((mIsConfigExist == false) || (mEposDeviceXmlPort == ""))
	{
		return false;
	}

	tPort = mEposDeviceXmlPort;
	return true;
}