// Copyright 2020 Seiko Epson Corporation.
// Epson Europe
// EEB/RDC
// 2020/09  ka
// This Application is intended for demonstration purposes only and not for production environment.

#include "stdafx.h"
#include <windows.h>
#include "TSEPrintLog.h"
#include "TSEUtil.h"

#include <stdio.h>
#include <stdarg.h>
#include <string>
#include <sstream>
#include <fstream>
#include <iostream>


#define TSEDEBUGBUFFER				200000
#define TSELOGNAME					"[EPSONTSELIBC]"
#define TSELOGFILEPATH				"\\EPSON\\TSE\\Logs\\"
#define TSELOGFILENAME				"EpsonTseLibC.log"

static bool gIsLogSet = false;
static LiblogLevel gLogLevel;
static std::string gLogProcName;
static uint8_t gLogMethod;
static std::string gLogFilename;

static std::string GetDate()
{
	time_t rawtime;
	struct tm timeinfo;
	char buffer[80];

	time(&rawtime);
	localtime_s(&timeinfo, &rawtime);

	strftime(buffer, sizeof(buffer), "%Y-%m-%d %H:%M:%S", &timeinfo);
	return std::string(buffer);
}

static std::string GetDateTime()
{
	time_t rawtime;
	struct tm timeinfo;
	char buffer[80];

	time(&rawtime);
	localtime_s(&timeinfo, &rawtime);

	strftime(buffer, sizeof(buffer), "%Y-%m-%d.%H-%M-%S", &timeinfo);
	return std::string(buffer);
}

void TSEPrintLog::SetLog(std::string& tProcName, LiblogLevel tLogLevel, uint8_t tLogMethod, std::string& tLogFile)
{

	if ((tLogLevel < LIBLOG_LEVEL_DISABLE) || (tLogLevel > LIBLOG_LEVEL_MAX))
	{
		gLogLevel = LIBLOG_LEVEL_DISABLE;
	}
	else
	{
		gLogLevel = tLogLevel;
	}

	gLogMethod = tLogMethod;
	if (tLogFile == "")
	{
		std::string progdatapath = TSEUtil::GetProgramDataPath();
		if (progdatapath == "")
		{
			gLogMethod = tLogMethod & (~((uint8_t)TSELOGONFILE));// remove logging on file
			gLogFilename = "";
		}
		else
		{
			gLogFilename = progdatapath + TSELOGFILEPATH + TSELOGFILENAME;
			if (TSEUtil::CreateTseDirectory(gLogFilename) == false)
			{
				gLogMethod = tLogMethod & (~((uint8_t)TSELOGONFILE));// remove logging on file
			}
		}
	}
	else
	{
		gLogFilename = tLogFile;
		if (TSEUtil::CreateTseDirectory(gLogFilename) == false)
		{
			gLogMethod = tLogMethod & (~((uint8_t)TSELOGONFILE));// remove logging on file
		}
	}

	gLogProcName = tProcName;
	gIsLogSet = true;

	return;
}

void TSEPrintLog::ManageLogFile(unsigned long tTrgtLogFileSize)
{
	if (gLogMethod & TSELOGONFILE)
	{
		std::ifstream ifs(gLogFilename, std::ios::binary);

		if (!ifs.good())
		{
			return;
		}
		const auto begin = ifs.tellg();
		ifs.seekg(0, std::ios::end);
		const auto end = ifs.tellg();
		const auto fsize = (end - begin);
		ifs.close();

		if (fsize > tTrgtLogFileSize)
		{
			std::string dateTime = GetDateTime();
			std::string backUpLog = gLogFilename + dateTime + ".backup";
			int ret;
			if ((ret = rename(gLogFilename.c_str(), backUpLog.c_str())) != 0)
			{
				//perror("Error renaming log file");
			}
		}
	}
}

std::string TSEPrintLog::GetLogMessage(const char * tArg, ...)
{
	std::string sbuf = "";
	char buffer[TSEDEBUGBUFFER];
	va_list argv;

	va_start(argv, tArg);
	_vsnprintf_s(buffer, TSEDEBUGBUFFER, tArg, argv);
	va_end(argv);

	return std::string(buffer);
}


std::string TSEPrintLog::MakePrintableString(const std::vector<unsigned char>& tBuffer) 
{
	std::string sBuf = "";
	for (unsigned long i = 0; i < tBuffer.size(); i++) {
		switch (tBuffer[i])
		{
			case(0x00): { sBuf += "[0x00]"; break; }
			case(0x01): { sBuf += "[0x01]"; break; }
			case(0x02): { sBuf += "[0x02]"; break; }
			case(0x03): { sBuf += "[0x03]"; break; }
			case(0x04): { sBuf += "[0x04]"; break; }
			case(0x05): { sBuf += "[0x05]"; break; }
			case(0x06): { sBuf += "[0x06]"; break; }
			case(0x07): { sBuf += "[0x07]"; break; }
			case(0x08): { sBuf += "[0x08]"; break; }
			case(0x09): { sBuf += "[0x09]"; break; }
			//	case(0x0a): { sBuf +=  "[0x0A]"; break; }
			case(0x0b): { sBuf += "[0x0B]"; break; }
			case(0x0c): { sBuf += "[0x0C]"; break; }
			//	case(0x0d): { sBuf +=  "[0x0D]"; break; }
			case(0x0e): { sBuf += "[0x0E]"; break; }
			case(0x0f): { sBuf += "[0x0F]"; break; }
			case(0x10): { sBuf += "[0x10]"; break; }
			case(0x11): { sBuf += "[0x11]"; break; }
			case(0x12): { sBuf += "[0x12]"; break; }
			case(0x13): { sBuf += "[0x13]"; break; }
			case(0x14): { sBuf += "[0x14]"; break; }
			case(0x15): { sBuf += "[0x15]"; break; }
			case(0x16): { sBuf += "[0x16]"; break; }
			case(0x17): { sBuf += "[0x17]"; break; }
			case(0x18): { sBuf += "[0x18]"; break; }
			case(0x19): { sBuf += "[0x19]"; break; }
			case(0x1a): { sBuf += "[0x1A]"; break; }
			case(0x1b): { sBuf += "[0x1B]"; break; }
			case(0x1c): { sBuf += "[0x1C]"; break; }
			case(0x1d): { sBuf += "[0x1D]"; break; }
			case(0x1e): { sBuf += "[0x1E]"; break; }
			case(0x1f): { sBuf += "[0x1F]"; break; }
			//	case(0x20): { sBuf +=  "[0x20]"; break; }
			case(0x7F): { sBuf += "[0x7F]"; break; }
			default: {sBuf += tBuffer[i]; break; }
		}
	}

	return sBuf;
}

void TSEPrintLog::PrintLog(unsigned short tDbgLvl, std::string tFileName, unsigned long tLine, std::string tFuncName, std::string tMsg)
{
	std::string sbuf = "";
	std::stringstream ssLine;
	
	if (gIsLogSet == false)
	{
		/*setting defaults*/
		gLogFilename = "";
		gLogLevel = LIBLOG_LEVEL_DISABLE;
		gLogProcName = TSELOGNAME;
		gLogMethod = TSELOGONDEBUGGER;
		gIsLogSet = true;
	}

	if (tDbgLvl > gLogLevel)
	{
		return;
	}

	ssLine << tLine;

	sbuf = gLogProcName;

	switch (tDbgLvl)
	{
		case LIBLOG_LEVEL_ERROR:			{sbuf += "[ERROR]"; break; }
		case LIBLOG_LEVEL_WARNING:			{sbuf += "[WARNI]"; break; }
		case LIBLOG_LEVEL_INFO:				{sbuf += "[INFOR]"; break; }
		case LIBLOG_LEVEL_TRACE:			{sbuf += "[TRACE]"; break; }
		case LIBLOG_LEVEL_VERBOSE:			{sbuf += "[VERBO]"; break; }
	}

	sbuf += " " + GetDate();	
	sbuf += " " + tFileName.substr(tFileName.find_last_of("/\\") + 1) + "-" + ssLine.str() + ":" + tFuncName;
	sbuf += ":: " + tMsg;

	if (gLogMethod & TSELOGONDEBUGGER)
	{
		OutputDebugString(sbuf.c_str());
	}

	if (gLogMethod & TSELOGONFILE)
	{
		if (gLogFilename != "")
		{
			std::ofstream ofs(gLogFilename, std::ios::app);
			if (ofs.good())
			{
				ofs << sbuf << std::endl;
				ofs.close();
			}
		}
	}

	if (gLogMethod & TSELOGONSTDOUT)
	{
		HANDLE hConsole = GetStdHandle(STD_OUTPUT_HANDLE);

		SetConsoleTextAttribute(hConsole, FOREGROUND_BLUE | FOREGROUND_GREEN | FOREGROUND_INTENSITY);
		std::cout << sbuf << std::endl;
		SetConsoleTextAttribute(hConsole, FOREGROUND_RED | FOREGROUND_GREEN | FOREGROUND_BLUE);
	}
	return;
}
