// Copyright 2020 Seiko Epson Corporation.
// Epson Europe
// EEB/RDC
// 2020/09  ka
// This Application is intended for demonstration purposes only and not for production environment.

#pragma once
#include <string>
#include <filesystem>
#include <vector>

typedef enum enumLiblogLevel {
	LIBLOG_LEVEL_DISABLE	= 0,
	LIBLOG_LEVEL_ERROR		= 1,
	LIBLOG_LEVEL_WARNING	= 2,
	LIBLOG_LEVEL_INFO		= 3,
	LIBLOG_LEVEL_TRACE		= 4,
	LIBLOG_LEVEL_VERBOSE	= 5,
	LIBLOG_LEVEL_MAX		= 6,
} LiblogLevel;


#define TSELOGONDEBUGGER	(1<<0)
#define TSELOGONFILE		(1<<1)
#define TSELOGONSTDOUT		(1<<2)

namespace TSEPrintLog
{

	void PrintLog(unsigned short tLogLvl, std::string tFileName, unsigned long tLine, std::string tFuncName, std::string tParam);
	void SetLog(std::string& tProcName, LiblogLevel tLogLevel, uint8_t tLogMethod, std::string& tLogFile);
	void ManageLogFile(unsigned long tTrgtLogFileSize);
	std::string GetLogMessage(const char * tArg, ...);
	std::string MakePrintableString(const std::vector<unsigned char>& tBuffer);
};

#define TSEPRINTLOG(n,x) { TSEPrintLog::PrintLog((n),(__FILE__),(__LINE__),(__func__), TSEPrintLog::GetLogMessage x); } 

