// Copyright 2019-2021 Seiko Epson Corporation.
// Epson Europe
// EEB/RDC
// 2021/03  ka
// This Application is intended for demonstration purposes only and not for production environment.

#pragma once
#include <string>
#include <vector>

namespace TSEUtil
{
	std::string GetCurrentUtcTime();
	void DecodeBase64(const std::string& tString, std::vector<unsigned char>& tDecoded);
	std::string EncodeBase64(const std::vector<unsigned char>& tData);
	std::string EncodeBase64Sha256(const std::vector<unsigned char>& tData);
	bool SaveToFile(const std::string& tFilename, const unsigned char* tMsg, const unsigned long& tSize);
	bool IsNumber(const std::string& tTestNum);
	bool IsDateTime(const std::string& tTestNum);
	bool CreateTseDirectory(const std::string& tFileName);
	std::string GetProgramDataPath();
};

//EOF