// Copyright 2019-2021 Seiko Epson Corporation.
// Epson Europe
// EEB/RDC
// 2021/03  ka
// This Application is intended for demonstration purposes only and not for production environment.

#pragma once

#include "../../Core/TSEOperate.h"
#include "../../Core/TSEAccess.h"
#include "../../Core/TSEOptions.h"
#include <list>
#include <windows.h>

#define AS_ADMIN		0x00
#define AS_TIMEADMIN	0x01

class CuiOperateTSE
{
public:
	CuiOperateTSE(const TSEOptions& tTseOpt);
	~CuiOperateTSE();
	bool CuiGetTseId(const std::string &tIpAddress, std::string& tTseId);
	bool ShowMenu();
	bool ConnectToTse(const TSEOptions& tTseOpt);
	bool DisconnectFromTse();

protected:
	
private:
	TSEOperate*		mTseOpr;

	HANDLE			mConsole;
	bool			mIsTseInitialized;
	bool			mIsAdminLogin;
	bool			mIsHostAuthenticated;
	std::string		mCurrentUserId;
	std::string		mLastExportFile;
	std::list<std::string> mClientIdLogInList;

	bool CuiFactoryReset();
	void CuiGetStorageInfo();
	void CuiGetStorageSmartInfo();
	void CuiRunTseSelfTest();
	void CuiSetup();
	void CuiGetLogMsgCertificate();
	void CuiGetLastTrxResponse();
	void CuiGetStartedTrxList();
	void CuiExportSerialNumber();

	void CuiAdmin();
	void CuiAdminLogin();
	void CuiAdminLogout();
	void CuiUpdateTimeFirstTime();
	void CuiUpdateTime();
	void CuiUpdateTimeManually();
	void CuiAdminSetTimeout();
	void CuiAdminGetTimeout();

	void CuiAdminEnableExportIfCspTestFails();
	void CuiAdminDisableExportIfCspTestFails();
	void CuiAdminSetUpForPrinter();

	void CuiAdminGetExportDataArchive();
	void CuiAdminGetExportDataFilterByTrx();
	void CuiAdminGetExportDataFilterByTrxNoInterval();
	void CuiAdminGetExportDataFilterByPeriod();
	void CuiAdminFinalizeExport();
	void CuiAdminCancelExportData();

	void CuiAdminRegisterSecretKey();
	void CuiAdminDisableSecureElement();
	
	void CuiChangeUserPin();
	void CuiAdminRegisterClient();
	void CuiAdminDeregisterClient();
	void CuiAdminUnlockTse();
	void CuiAdminLockTse();

	void CuiAdminGetAuthenticatedUserList();
	void CuiAdminGetRegisteredClientList();

	void CuiTimeAdmin();
	void CuiTimeAdminLogin();
	void CuiTimeAdminLogout();
	void CuiTimeAdminStartTransaction();
	void CuiTimeAdminUpdateTransaction();
	void CuiTimeAdminFinishTransaction();

	void CuiHost();

	void CuiHostAuthenticate();
	void CuiHostDeauthenticate();

	void CuiHostUnblockUser(bool tIsAdmin);
	void CuiHostChangePuk();

	bool IsAdminLogin();
	bool IsTimeAdminLogin(); 
	bool IsHostAuthenticated();

	bool GetHexString(std::string hexString, std::vector<unsigned char> &binData);
	void LStringToVector(const std::string& tString, std::vector<std::string> &tStr);
};

//EOF